/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.input;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.tooltip.TooltipManager;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.IconManager;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.input.AbstractInputMaker;
import mod.adrenix.nostalgic.client.gui.widget.input.ActiveSync;
import mod.adrenix.nostalgic.client.gui.widget.input.IconSync;
import mod.adrenix.nostalgic.client.gui.widget.input.InputModule;
import mod.adrenix.nostalgic.client.gui.widget.input.InputSync;
import mod.adrenix.nostalgic.client.gui.widget.input.LayoutSync;
import mod.adrenix.nostalgic.client.gui.widget.input.suggestion.InputSuggester;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.client.timer.ClientTimer;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.data.RecursionAvoidance;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.timer.TickTimer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInput<Builder extends AbstractInputMaker<Builder, Input>, Input extends AbstractInput<Builder, Input>>
extends DynamicWidget<Builder, Input>
implements TooltipManager {
    protected InputModule<Builder, Input> module;
    @Nullable
    protected final InputSuggester<Input> suggester;
    protected final UniqueArrayList<DynamicWidget<?, ?>> internal;
    protected final IconManager<Input> icon;
    protected final IconWidget controls;
    protected final BlankWidget printer;
    protected final Color borderColor;
    protected final Color backgroundColor;
    protected final RecursionAvoidance changingInput = RecursionAvoidance.create();
    protected final NullableHolder<TickTimer> responseTimer = NullableHolder.empty();
    protected boolean dragging;
    protected boolean editable;
    protected long focusedTime;
    protected int minCursorPos;
    protected int cursorPos;
    protected int displayPos;
    protected int highlightPos;
    protected String input;

    protected AbstractInput(Builder builder) {
        super(builder);
        this.internal = new UniqueArrayList();
        this.icon = new IconManager<AbstractInput>((AbstractInput)this.self());
        this.icon.apply(this::setIconTooltip);
        this.icon.apply(this.internal::add);
        this.input = ((AbstractInputMaker)builder).startWith;
        this.editable = ((AbstractInputMaker)builder).editable;
        this.focusedTime = Util.getMillis();
        this.minCursorPos = 0;
        this.backgroundColor = new Color(() -> {
            Color background;
            Color color = background = this.isFocused() ? ((AbstractInputMaker)this.getBuilder()).backgroundFocusColor : ((AbstractInputMaker)this.getBuilder()).backgroundColor;
            if (this.isHoveredOrFocused()) {
                background = ((AbstractInputMaker)this.getBuilder()).hoverBackgroundColor != null ? ((AbstractInputMaker)this.getBuilder()).hoverBackgroundColor : background.brighter();
            }
            return background.get();
        });
        this.borderColor = new Color(() -> {
            Color border;
            Color color = border = this.isFocused() ? ((AbstractInputMaker)this.getBuilder()).borderFocusColor : ((AbstractInputMaker)this.getBuilder()).borderColor;
            if (this.isHoveredOrFocused()) {
                border = ((AbstractInputMaker)this.getBuilder()).hoverBorderColor != null ? ((AbstractInputMaker)this.getBuilder()).hoverBorderColor : border.brighter();
            }
            return border.get();
        });
        this.module = InputModule.generic((AbstractInput)this.self());
        this.controls = ((IconFactory)((IconFactory)((IconFactory)IconTemplate.menu().posX(() -> this.getEndX() - 12)).posY(() -> Math.round(MathUtil.center(this.getY(), 9, this.getHeight())))).onPress(() -> this.module.getOverlay().openOrClose()).disableIf(this::isControlDisabled)).build(this.internal::add);
        this.printer = ((BlankBuilder)((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().posX(this::getIconEndX)).posY(() -> Math.round(MathUtil.center(this.getY(), GuiUtil.textHeight(), this.getHeight())))).height(GuiUtil.textHeight())).extendWidthTo(this.controls, 4)).renderer(this::renderText).build(this.internal::add);
        ((AbstractInputMaker)this.getBuilder()).addFunction(new ActiveSync());
        ((AbstractInputMaker)this.getBuilder()).addFunction(new LayoutSync());
        ((AbstractInputMaker)this.getBuilder()).addFunction(new IconSync());
        ((AbstractInputMaker)this.getBuilder()).addFunction(new InputSync((AbstractInput)this.self()));
        this.suggester = ((AbstractInputMaker)builder).suggesterProvider != null ? ((AbstractInputMaker)builder).suggesterProvider.apply((AbstractInput)this.self()) : null;
    }

    protected boolean isControlDisabled() {
        return this.isNotEditable() || this.getY() < 22;
    }

    protected void setIconSize(IconWidget icon) {
        icon.setSize(Mth.clamp((int)icon.getHeight(), (int)0, (int)(this.getHeight() - 2)));
    }

    protected void setIconTooltip(IconWidget icon) {
        MutableComponent tooltip = Lang.Input.TIP_CLICK.get(new Object[0]);
        if (((AbstractInputMaker)this.getBuilder()).searchShortcut) {
            tooltip.append(String.format(" %s", Lang.Input.TIP_SEARCH.getString(new Object[0])));
        }
        ((IconFactory)((IconFactory)icon.getBuilder()).tooltip(Lang.Input.TIP, 500L, TimeUnit.MILLISECONDS)).infoTooltip((Component)tooltip, 45);
    }

    protected int getIconPadding() {
        return this.icon.isEmpty() ? 0 : ((AbstractInputMaker)this.builder).iconPadding;
    }

    protected int getIconWidth() {
        if (this.icon.isEmpty()) {
            return 2;
        }
        return this.icon.getWidth() + 2 + this.getIconPadding();
    }

    protected int getIconX() {
        return this.getX() + 2 + this.getIconPadding();
    }

    protected int getIconEndX() {
        return this.getIconX() + this.getIconWidth();
    }

    protected int getIconY() {
        return Math.round(MathUtil.center(this.getY(), this.icon.getHeight(), this.getHeight()));
    }

    public int getMaxLength() {
        return ((AbstractInputMaker)this.getBuilder()).maxLength;
    }

    public int getPrinterWidth() {
        return this.printer.getWidth() - GuiUtil.font().width(((AbstractInputMaker)this.getBuilder()).cursor);
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getTooltipWidgets() {
        return this.internal;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isNotEditable() {
        return !this.editable;
    }

    public void setEditable(boolean isEditable) {
        this.editable = isEditable;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public boolean isProcessingInput() {
        return this.responseTimer.isPresent();
    }

    protected void respondToInput(String text) {
        if (((AbstractInputMaker)this.getBuilder()).responder != null) {
            ((AbstractInputMaker)this.getBuilder()).responder.accept((AbstractInput)this.self(), text);
        }
        ((AbstractInputMaker)this.getBuilder()).listeners.forEach((Consumer<Consumer<String>>)((Consumer<Consumer>)listener -> listener.accept(text)));
    }

    protected void onInputChange(String text) {
        if (((AbstractInputMaker)this.getBuilder()).delayedResponse) {
            long delay = ((AbstractInputMaker)this.getBuilder()).responseDelay;
            TickTimer timer = ClientTimer.getInstance().create(delay, TimeUnit.MILLISECONDS, () -> {
                this.respondToInput(text);
                this.responseTimer.clear();
            });
            ClientTimer.getInstance().run(timer);
            this.responseTimer.ifPresent(ClientTimer.getInstance()::cancel);
            this.responseTimer.set(timer);
        } else {
            this.respondToInput(text);
        }
    }

    public void setInput(String text) {
        String lastInput = this.input;
        this.setNonReactiveInput(text);
        if (this.changingInput.isProcessing()) {
            return;
        }
        if (!lastInput.equals(this.input)) {
            this.changingInput.process(() -> this.onInputChange(text));
            this.moveCursorToEnd(false);
            if (this.suggester != null) {
                this.suggester.generate();
            }
        }
    }

    public void setNonReactiveInput(String text) {
        if (!((AbstractInputMaker)this.getBuilder()).filter.test(text)) {
            return;
        }
        String lastInput = this.input;
        String string = this.input = text.length() > this.getMaxLength() ? text.substring(0, this.getMaxLength()) : text;
        if (!lastInput.equals(this.input)) {
            this.setCursorPosition(this.input.length());
            this.setHighlightPos(this.cursorPos);
        }
    }

    public String getInput() {
        return this.input;
    }

    public String getHighlighted() {
        int min = Math.min(this.cursorPos, this.highlightPos);
        int max = Math.max(this.cursorPos, this.highlightPos);
        return this.input.substring(min, max);
    }

    @Nullable
    public InputSuggester<Input> getSuggester() {
        return this.suggester;
    }

    public void addListener(Consumer<String> listener) {
        ((AbstractInputMaker)this.getBuilder()).addListener(listener);
    }

    public void removeListener(Consumer<String> listener) {
        ((AbstractInputMaker)this.getBuilder()).removeListener(listener);
    }

    public void insertText(String text) {
        int min = Math.min(this.cursorPos, this.highlightPos);
        int max = Math.max(this.cursorPos, this.highlightPos);
        int start = this.getMaxLength() - this.input.length() - (min - max);
        String filtered = StringUtil.filterText((String)text);
        String insert = new StringBuilder(this.input).replace(min, max, filtered).toString();
        int end = filtered.length();
        if (start < end) {
            end = start;
        }
        if (!((AbstractInputMaker)this.getBuilder()).filter.test(insert)) {
            return;
        }
        this.setInput(insert);
        this.setCursorPosition(min + end);
        this.setHighlightPos(this.cursorPos);
    }

    protected void deleteText(int direction) {
        if (Screen.hasControlDown()) {
            this.deleteWords(direction);
        } else {
            this.deleteChars(direction);
        }
    }

    public void deleteWords(int direction) {
        if (this.input.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        this.deleteChars(this.getWordPosition(direction) - this.cursorPos);
    }

    public void deleteChars(int direction) {
        int maxPos;
        if (this.input.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        int directionPos = this.getCursorPos(direction);
        int minPos = Math.min(directionPos, this.cursorPos);
        if (minPos == (maxPos = Math.max(directionPos, this.cursorPos))) {
            return;
        }
        String deletion = new StringBuilder(this.input).delete(minPos, maxPos).toString();
        if (!((AbstractInputMaker)this.getBuilder()).filter.test(deletion)) {
            return;
        }
        this.setInput(deletion);
        this.moveCursorTo(minPos, false);
    }

    public int getWordPosition(int numberOfWords) {
        return this.getWordPosition(numberOfWords, this.cursorPos);
    }

    protected int getWordPosition(int numberOfWords, int cursorPos) {
        for (int i = 0; i < Math.abs(numberOfWords); ++i) {
            if (numberOfWords < 0) {
                while (cursorPos > 0 && this.input.charAt(cursorPos - 1) == ' ') {
                    --cursorPos;
                }
                while (cursorPos > 0 && this.input.charAt(cursorPos - 1) != ' ') {
                    --cursorPos;
                }
                continue;
            }
            int inputLength = this.input.length();
            if ((cursorPos = this.input.indexOf(32, cursorPos)) == -1) {
                cursorPos = inputLength;
                continue;
            }
            while (cursorPos < inputLength && this.input.charAt(cursorPos) == ' ') {
                ++cursorPos;
            }
        }
        return cursorPos;
    }

    protected void scrollTo(int position) {
        this.displayPos = Math.min(this.displayPos, this.input.length());
        int printerWidth = this.getPrinterWidth();
        String displayString = GuiUtil.font().plainSubstrByWidth(this.input.substring(this.displayPos), printerWidth);
        int maxPos = displayString.length() + this.displayPos;
        if (position == this.displayPos) {
            this.displayPos -= GuiUtil.font().plainSubstrByWidth(this.input, printerWidth, true).length();
        }
        if (position > maxPos) {
            this.displayPos += position - maxPos;
        } else if (position <= this.displayPos) {
            this.displayPos -= this.displayPos - position;
        }
        this.displayPos = Mth.clamp((int)this.displayPos, (int)0, (int)this.input.length());
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPos = Mth.clamp((int)cursorPosition, (int)this.minCursorPos, (int)this.input.length());
        this.scrollTo(this.cursorPos);
    }

    public void setHighlightPos(int position) {
        this.highlightPos = Mth.clamp((int)position, (int)this.minCursorPos, (int)this.input.length());
        this.scrollTo(this.highlightPos);
    }

    protected int getCursorPos(int delta) {
        return Util.offsetByCodepoints((String)this.input, (int)this.cursorPos, (int)delta);
    }

    public void moveCursor(int delta, boolean highlight) {
        this.moveCursorTo(this.getCursorPos(delta), highlight);
    }

    public void moveCursorTo(int cursorPos, boolean highlight) {
        this.setCursorPosition(cursorPos);
        if (!highlight) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onInputChange(this.input);
    }

    public void moveCursorToStart(boolean highlight) {
        this.moveCursorTo(this.minCursorPos, highlight);
    }

    public void moveCursorToEnd(boolean highlight) {
        this.moveCursorTo(this.input.length(), highlight);
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (focused) {
            this.focusedTime = Util.getMillis();
        }
    }

    @Override
    public boolean isUnfocused() {
        return super.isUnfocused() || !this.isVisible() || !this.editable;
    }

    @Override
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (this.isInvisible() || !this.editable) {
            return null;
        }
        return super.nextFocusPath(event);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInvalidClick(mouseX, mouseY, button)) {
            return false;
        }
        this.dragging = true;
        if (this.controls.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isUnfocused()) {
            this.setFocused(true);
            return true;
        }
        if (this.icon.get().isMouseOver(mouseX, mouseY)) {
            this.setInput("");
        }
        String text = GuiUtil.font().plainSubstrByWidth(this.input.substring(this.displayPos), this.getPrinterWidth());
        int maxWidth = Mth.floor((double)mouseX) - this.printer.getX();
        int cursorPos = GuiUtil.font().plainSubstrByWidth(text, maxWidth).length() + this.displayPos;
        this.moveCursorTo(cursorPos, Screen.hasShiftDown());
        this.setHighlightPos(this.cursorPos);
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return this.controls.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.dragging) {
            return false;
        }
        int offset = Mth.floor((double)mouseX) - this.getX() - this.getIconWidth();
        String text = GuiUtil.font().plainSubstrByWidth(this.input.substring(this.displayPos), this.getPrinterWidth());
        this.setHighlightPos(GuiUtil.font().plainSubstrByWidth(text, offset).length() + this.displayPos);
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (KeyboardUtil.isSearching(keyCode) && ((AbstractInputMaker)this.getBuilder()).searchShortcut) {
            if (this.isUnfocused()) {
                this.setFocused(true);
            }
            if (this.getScreen() != null) {
                this.getScreen().setFocused((GuiEventListener)this);
            }
            return true;
        }
        if (this.isUnfocused()) {
            return false;
        }
        if (KeyboardUtil.isEsc(keyCode)) {
            this.module.getOverlay().close();
            this.setFocused(false);
            return true;
        }
        if (Screen.isSelectAll((int)keyCode)) {
            this.moveCursorToEnd(false);
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            if (this.editable) {
                this.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
            }
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            if (this.editable) {
                this.insertText("");
            }
            return true;
        }
        return switch (keyCode) {
            case 263 -> {
                if (this.cursorPos == this.minCursorPos) {
                    yield false;
                }
                if (Screen.hasControlDown()) {
                    this.moveCursorTo(this.getWordPosition(-1), Screen.hasShiftDown());
                } else {
                    this.moveCursor(-1, Screen.hasShiftDown());
                }
                yield true;
            }
            case 262 -> {
                if (this.cursorPos == this.input.length()) {
                    yield false;
                }
                if (Screen.hasControlDown()) {
                    this.moveCursorTo(this.getWordPosition(1), Screen.hasShiftDown());
                } else {
                    this.moveCursor(1, Screen.hasShiftDown());
                }
                yield true;
            }
            case 258 -> {
                String suggestion;
                if (this.suggester != null && !(suggestion = this.suggester.get()).isEmpty()) {
                    this.setInput(this.suggester.get());
                    yield true;
                }
                yield false;
            }
            case 259 -> {
                if (this.editable) {
                    this.deleteText(-1);
                }
                yield true;
            }
            case 261 -> {
                if (this.editable) {
                    this.deleteText(1);
                }
                yield true;
            }
            case 268 -> {
                this.moveCursorToStart(Screen.hasShiftDown());
                yield true;
            }
            case 269 -> {
                this.moveCursorToEnd(Screen.hasShiftDown());
                yield true;
            }
            default -> false;
        };
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (this.isUnfocused()) {
            return false;
        }
        if (StringUtil.isAllowedChatCharacter((char)codePoint)) {
            if (this.editable) {
                this.insertText(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    protected void renderText(BlankWidget printer, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int beginIndex = this.cursorPos - this.displayPos;
        Color color = this.isFocused() ? ((AbstractInputMaker)this.getBuilder()).textColor : ((AbstractInputMaker)this.getBuilder()).textUnfocusedColor;
        String text = GuiUtil.font().plainSubstrByWidth(this.input.substring(this.displayPos), this.getPrinterWidth());
        boolean isInputSplit = beginIndex >= 0 && beginIndex <= text.length();
        boolean isFlashing = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && isInputSplit;
        int startX = printer.getX();
        int startY = printer.getY();
        int textEndX = startX;
        int highlightPos = Mth.clamp((int)(this.highlightPos - this.displayPos), (int)0, (int)text.length());
        String suggestion = null;
        String snippet = null;
        String ghost = null;
        String hint = null;
        if (text.isEmpty()) {
            text = ((AbstractInputMaker)this.getBuilder()).whenEmpty;
            color = ((AbstractInputMaker)this.getBuilder()).textEmptyColor;
        }
        if (!text.isEmpty()) {
            String displayText = isInputSplit ? text.substring(0, beginIndex) : text;
            textEndX = DrawText.begin(graphics, ((AbstractInputMaker)this.getBuilder()).formatter.apply(displayText, this.displayPos)).pos(textEndX, startY).color(color).draw();
        }
        boolean isVerticalCursor = this.cursorPos < this.input.length() || this.input.length() >= this.getMaxLength();
        int verticalX = textEndX;
        if (!isInputSplit) {
            verticalX = beginIndex > 0 ? startX + printer.getWidth() : startX;
        } else if (isVerticalCursor) {
            --verticalX;
            --textEndX;
        }
        if (!text.isEmpty() && isInputSplit && beginIndex < text.length()) {
            textEndX = DrawText.begin(graphics, ((AbstractInputMaker)this.getBuilder()).formatter.apply(text.substring(beginIndex), this.cursorPos)).pos(textEndX, startY).color(color).draw();
        }
        if (!text.isEmpty() && !text.equals(((AbstractInputMaker)this.getBuilder()).whenEmpty) && this.suggester != null) {
            suggestion = this.suggester.get();
            snippet = suggestion.substring(Math.min(suggestion.length(), this.displayPos));
            ghost = GuiUtil.font().plainSubstrByWidth(snippet, this.getPrinterWidth());
            if (!ghost.isEmpty() && !ghost.isBlank()) {
                hint = ghost.substring(Math.min(ghost.length(), text.length()));
                DrawText.begin(graphics, hint).color(color.fromAlpha(0.5)).pos(textEndX, startY).draw();
            }
        }
        if (isFlashing) {
            if (isVerticalCursor) {
                int x0 = verticalX;
                int x1 = verticalX + 1;
                int y0 = startY - 1;
                int y1 = startY + 1 + GuiUtil.textHeight();
                Color cursorColor = ((AbstractInputMaker)this.getBuilder()).cursorVerticalColor;
                RenderUtil.deferredRenderer(() -> {
                    RenderUtil.setFillZOffset(1);
                    RenderUtil.setRenderType(RenderType.guiOverlay());
                    RenderUtil.fill(graphics, (float)x0, (float)y0, (float)x1, (float)y1, cursorColor.get());
                });
            } else {
                DrawText.begin(graphics, ((AbstractInputMaker)this.getBuilder()).cursor).pos(verticalX, startY).color(((AbstractInputMaker)this.getBuilder()).cursorColor).draw();
            }
        }
        if (highlightPos != beginIndex) {
            int endX = startX + GuiUtil.font().width(text.substring(0, highlightPos)) - 1;
            this.renderHighlight(graphics, verticalX, startY - 1, endX, startY + 1 + GuiUtil.textHeight());
        } else if (hint != null && hint.isEmpty() && suggestion.length() < this.input.length()) {
            this.displayPos += Math.max(0, snippet.length() - ghost.length());
        }
    }

    protected void renderHighlight(GuiGraphics graphics, int minX, int minY, int maxX, int maxY) {
        int delta;
        if (minX < maxX) {
            delta = minX;
            minX = maxX;
            maxX = delta;
        }
        if (minY < maxY) {
            delta = minY;
            minY = maxY;
            maxY = delta;
        }
        if (maxX > this.getX() + this.width) {
            maxX = this.getX() + this.width;
        }
        if (minX > this.getX() + this.width) {
            minX = this.getX() + this.width;
        }
        int x0 = minX;
        int y0 = minY;
        int x1 = maxX;
        int y1 = maxY;
        RenderUtil.deferredRenderer(() -> {
            RenderUtil.setFillZOffset(1);
            RenderUtil.setRenderType(RenderType.guiTextHighlight());
            RenderUtil.fill(graphics, (float)x0, (float)y0, (float)x1, (float)y1, -16776961);
        });
    }

    protected void renderBox(GuiGraphics graphics) {
        Color border = this.getBorderColor();
        Color background = this.getBackgroundColor();
        int x0 = this.getX();
        int y0 = this.getY();
        int x1 = this.getEndX();
        int y1 = this.getEndY();
        RenderUtil.vLine(graphics, (float)x0, (float)y0, (float)y1, border);
        RenderUtil.vLine(graphics, (float)(x1 - 1), (float)y0, (float)y1, border);
        RenderUtil.hLine(graphics, (float)(x0 + 1), (float)y0, (float)(x1 - 1), border);
        RenderUtil.hLine(graphics, (float)(x0 + 1), (float)(y1 - 1), (float)(x1 - 1), border);
        RenderUtil.fill(graphics, (float)(x0 + 1), (float)(y0 + 1), (float)(x1 - 1), (float)(y1 - 1), background);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        RenderUtil.beginBatching();
        this.renderBox(graphics);
        this.icon.apply(this.internal::remove);
        this.icon.pushCache();
        this.icon.pos(this.getIconX(), this.getIconY());
        this.icon.render(graphics, mouseX, mouseY, partialTick);
        this.icon.popCache();
        DynamicWidget.render(this.internal, graphics, mouseX, mouseY, partialTick);
        RenderUtil.endBatching();
        this.icon.apply(this.internal::add);
        this.renderDebug(graphics);
    }
}

