/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.icon;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.IconManager;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class IconWidget
extends DynamicWidget<IconFactory, IconWidget> {
    private Supplier<TextureIcon> icon;
    private final Supplier<TextureIcon> pressIcon;
    private final Runnable onPress;
    private boolean holding;
    private double zOffset;

    public static IconFactory create(TextureIcon icon) {
        return new IconFactory(() -> icon);
    }

    public static IconFactory create(Supplier<TextureIcon> supplier) {
        return new IconFactory(supplier);
    }

    protected IconWidget(IconFactory builder) {
        super(builder);
        this.icon = builder.icon;
        this.pressIcon = builder.pressIcon;
        this.onPress = builder.onPress;
        this.zOffset = builder.zOffset;
        if (this.isEmpty()) {
            this.setWidth(builder.emptyWidth);
            this.setHeight(builder.emptyHeight);
        }
    }

    public void setIcon(Supplier<TextureIcon> supplier) {
        this.icon = supplier;
    }

    public TextureIcon getIcon() {
        if (this.icon == null) {
            return TextureIcon.EMPTY;
        }
        return this.icon.get();
    }

    public boolean isEmpty() {
        return this.getIcon().isEmpty();
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setSize(int size) {
        this.setSize(size, size);
    }

    public void setZOffset(double offset) {
        this.zOffset = offset;
    }

    private float getAverageWidgetSize() {
        return (float)(this.width + this.height) / 2.0f;
    }

    private float getAverageIconSize(TextureIcon icon) {
        return (float)(icon.getWidth() + icon.getHeight()) / 2.0f;
    }

    private float getTextureScale(TextureIcon icon) {
        if (icon.getTextureLocation().isPresent()) {
            return this.getAverageWidgetSize() / icon.getTextureLocation().get().getAverageSize();
        }
        return this.getAverageWidgetSize() / this.getAverageIconSize(icon);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean isHandled;
        boolean bl = isHandled = KeyboardUtil.isEnterLike(keyCode) || KeyboardUtil.match(keyCode, 32);
        if (this.isFocused() && isHandled && this.onPress != null) {
            GuiUtil.playClick();
            this.onPress.run();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isValidClick(mouseX, mouseY, button) && this.onPress != null) {
            this.holding = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.onPress == null || !this.holding) {
            return false;
        }
        if (this.isValidClick(mouseX, mouseY, button)) {
            GuiUtil.playClick();
            this.onPress.run();
        }
        this.holding = false;
        return true;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean isDisabledEmpty;
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.isEmpty() || this.isInvisible()) {
            return;
        }
        TextureIcon hoverIcon = IconManager.getHovered(this.getBuilder()).get();
        TextureIcon disabledIcon = IconManager.getDisabled(this.getBuilder()).get();
        boolean isHoverEmpty = hoverIcon == TextureIcon.EMPTY;
        boolean bl = isDisabledEmpty = disabledIcon == TextureIcon.EMPTY;
        if (RenderSystem.getShaderColor()[0] == 1.0f) {
            float brightness = 1.0f;
            if (isHoverEmpty) {
                brightness = IconManager.getLightenAmount(this, brightness);
            }
            if (isDisabledEmpty) {
                brightness = IconManager.getDarkenAmount(this, brightness);
            }
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        if (this.holding && this.pressIcon != null) {
            this.renderIcon(this.pressIcon.get(), graphics);
        } else if (this.isHoveredOrFocused() && this.isActive() && !isHoverEmpty) {
            this.renderIcon(hoverIcon, graphics);
        } else if (this.isInactive() && !isDisabledEmpty) {
            this.renderIcon(disabledIcon, graphics);
        } else {
            this.renderIcon(this.getIcon(), graphics);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderDebug(graphics);
    }

    private void renderIcon(TextureIcon icon, GuiGraphics graphics) {
        float scale = this.getTextureScale(icon);
        int x = this.x;
        int y = this.y;
        if (icon.getTextureLocation().isPresent()) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, 0.0, this.zOffset);
            RenderUtil.blitTexture(icon.getTextureLocation().get(), graphics, scale, x, y);
            graphics.pose().popPose();
            this.renderDebug(graphics);
            return;
        }
        if (icon.getSpriteLocation().isPresent()) {
            int width = icon.getWidth();
            int height = icon.getHeight();
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, 0.0, this.zOffset);
            RenderUtil.blitSprite(icon.getSpriteLocation().get(), graphics, scale, x, y, width, height);
            graphics.pose().popPose();
            this.renderDebug(graphics);
            return;
        }
        float[] color = RenderSystem.getShaderColor();
        float brightness = (color[0] + color[1] + color[2]) / 3.0f;
        Item item = icon.getItem().orElse(icon.getBlock().orElse(Blocks.AIR).asItem());
        graphics.pose().pushPose();
        graphics.pose().translate((double)x, (double)y, this.zOffset);
        graphics.pose().scale(scale, scale, scale);
        RenderUtil.renderItem(graphics, item.getDefaultInstance(), 0, 0, brightness);
        graphics.pose().popPose();
    }

    @Override
    protected void renderDebug(GuiGraphics graphics) {
        if (this.isNotDebugging() || this.isInvisible()) {
            return;
        }
        Matrix4f position = new Matrix4f((Matrix4fc)graphics.pose().last().pose());
        RenderUtil.deferredRenderer(() -> {
            int startX = this.x;
            int startY = this.y;
            int endX = this.getEndX();
            int endY = this.getEndY();
            graphics.pose().pushPose();
            graphics.pose().setIdentity();
            graphics.pose().mulPose(position);
            graphics.pose().translate(0.0, 0.0, 1.0);
            RenderUtil.beginBatching();
            RenderUtil.fill(graphics, (float)startX, (float)startY, (float)(startX + 1), (float)(startY + 1), -65536);
            RenderUtil.fill(graphics, (float)(endX - 1), (float)startY, (float)endX, (float)(startY + 1), -16711936);
            RenderUtil.fill(graphics, (float)startX, (float)(endY - 1), (float)(startX + 1), (float)endY, -16711681);
            RenderUtil.fill(graphics, (float)(endX - 1), (float)(endY - 1), (float)endX, (float)endY, -65281);
            RenderUtil.endBatching();
            graphics.pose().popPose();
        });
    }
}

