/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.grid;

import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.ActiveBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.VisibleBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Cell;
import mod.adrenix.nostalgic.client.gui.widget.grid.CellBuilder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridSync;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;

public class GridBuilder
extends DynamicBuilder<GridBuilder, Grid>
implements LayoutBuilder<GridBuilder, Grid>,
ActiveBuilder<GridBuilder, Grid>,
VisibleBuilder<GridBuilder, Grid> {
    final WidgetHolder parent;
    final ToIntFunction<Grid> cellsPerRow;
    final UniqueArrayList<Cell> cells;
    ToIntFunction<Grid> rowSpacing = grid -> 1;
    ToIntFunction<Grid> columnSpacing = grid -> 1;
    boolean extendLastCell = false;
    boolean alignRowHeights = false;
    boolean alignAllCells = false;
    boolean useWidgetHeight = false;
    int cellPadding = 0;

    protected GridBuilder(WidgetHolder parent, ToIntFunction<Grid> cellsPerRow) {
        this.parent = parent;
        this.cellsPerRow = cellsPerRow;
        this.cells = new UniqueArrayList();
        this.canFocus = BooleanSupplier.NEVER;
        this.addFunction(new GridSync());
    }

    @Override
    public GridBuilder self() {
        return this;
    }

    public GridBuilder addCell(Cell cell) {
        this.cells.add(cell);
        this.followers.add(cell);
        this.parent.addWidgets(cell.widget);
        ((CellBuilder)cell.getBuilder()).grid = this.widget;
        if (this.widget.isPresent()) {
            ((Grid)this.widget.getOrThrow()).alignCells();
        }
        return this;
    }

    public GridBuilder addCells(DynamicWidget<?, ?> ... widgets) {
        for (DynamicWidget<?, ?> widget : widgets) {
            this.addCell(widget);
        }
        return this;
    }

    private CellBuilder makeCell(DynamicWidget<?, ?> widget) {
        CellBuilder builder = Cell.create(widget);
        if (this.useWidgetHeight) {
            builder.height(() -> widget.getHeight() + builder.paddingTop + builder.paddingBottom);
        }
        return builder;
    }

    public GridBuilder addCell(DynamicWidget<?, ?> widget) {
        return this.addCell((Cell)((CellBuilder)this.makeCell(widget).padding(this.cellPadding)).build());
    }

    public GridBuilder addCell(DynamicWidget<?, ?> widget, int padding) {
        return this.addCell((Cell)((CellBuilder)this.makeCell(widget).padding(padding)).build());
    }

    public GridBuilder addCell(DynamicWidget<?, ?> widget, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        return this.addCell((Cell)((CellBuilder)this.makeCell(widget).padding(paddingLeft, paddingTop, paddingRight, paddingBottom)).build());
    }

    public GridBuilder useWidgetHeight() {
        this.useWidgetHeight = true;
        return this;
    }

    public GridBuilder cellPadding(int padding) {
        this.cellPadding = padding;
        return this;
    }

    public GridBuilder alignAllCells() {
        this.alignAllCells = true;
        return this;
    }

    public GridBuilder alignRowHeights() {
        this.alignRowHeights = true;
        return this;
    }

    public GridBuilder extendLastCell() {
        this.extendLastCell = true;
        return this;
    }

    public GridBuilder rowSpacing(ToIntFunction<Grid> spacing) {
        this.rowSpacing = spacing;
        return this;
    }

    public GridBuilder rowSpacing(IntSupplier spacing) {
        return this.rowSpacing((Grid grid) -> spacing.getAsInt());
    }

    public GridBuilder rowSpacing(int spacing) {
        return this.rowSpacing(() -> spacing);
    }

    public GridBuilder columnSpacing(ToIntFunction<Grid> spacing) {
        this.columnSpacing = spacing;
        return this;
    }

    public GridBuilder columnSpacing(IntSupplier spacing) {
        return this.columnSpacing((Grid grid) -> spacing.getAsInt());
    }

    public GridBuilder columnSpacing(int spacing) {
        return this.columnSpacing(() -> spacing);
    }

    public GridBuilder spacing(ToIntFunction<Grid> spacing) {
        return this.rowSpacing(spacing).columnSpacing(spacing);
    }

    public GridBuilder spacing(IntSupplier spacing) {
        return this.rowSpacing(spacing).columnSpacing(spacing);
    }

    public GridBuilder spacing(int spacing) {
        return this.rowSpacing(spacing).columnSpacing(spacing);
    }

    @Override
    protected Grid construct() {
        return new Grid(this);
    }
}

