/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.grid;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Cell;
import mod.adrenix.nostalgic.client.gui.widget.grid.CellBuilder;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.function.ForEachWithPrevious;
import net.minecraft.client.gui.GuiGraphics;

public class Grid
extends DynamicWidget<GridBuilder, Grid> {
    private final UniqueArrayList<Cell> cells;
    protected boolean isAlignmentPaused = false;
    protected boolean isRealignNeeded = false;
    protected int cellsPerRow = 0;

    public static GridBuilder create(WidgetHolder parent, ToIntFunction<Grid> cellsPerRow) {
        return new GridBuilder(parent, cellsPerRow);
    }

    public static GridBuilder create(WidgetHolder parent, IntSupplier cellsPerRow) {
        return new GridBuilder(parent, grid -> cellsPerRow.getAsInt());
    }

    public static GridBuilder create(WidgetHolder parent, int cellsPerRow) {
        return new GridBuilder(parent, grid -> cellsPerRow);
    }

    protected Grid(GridBuilder builder) {
        super(builder);
        this.cells = builder.cells;
        this.cellsPerRow = builder.cellsPerRow.applyAsInt(this);
        this.alignCells();
    }

    public void addCell(Cell cell) {
        ((GridBuilder)this.builder).addCell(cell);
    }

    public void addCell(DynamicWidget<?, ?> widget) {
        ((GridBuilder)this.builder).addCell(widget);
    }

    public void addCells(DynamicWidget<?, ?> ... widgets) {
        ((GridBuilder)this.builder).addCells(widgets);
    }

    public void addCell(DynamicWidget<?, ?> widget, int padding) {
        ((GridBuilder)this.builder).addCell(widget, padding);
    }

    public void addCell(DynamicWidget<?, ?> widget, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        ((GridBuilder)this.builder).addCell(widget, paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    public void removeCell(Cell cell) {
        this.cells.remove(cell);
        ((GridBuilder)this.builder).parent.removeWidget(cell.widget);
    }

    public void pauseAlignment() {
        this.isAlignmentPaused = true;
    }

    public void resumeAlignment() {
        this.isAlignmentPaused = false;
    }

    public int size() {
        return this.cells.size();
    }

    private Stream<DynamicWidget<?, ?>> getWidgetsFromRow(List<Cell> row) {
        return row.stream().map(Cell::getWidget);
    }

    private void setLayoutForCells(List<Cell> row, Consumer<LayoutBuilder<?, ?>> consumer) {
        CollectionUtil.fromCast(row.stream().map(DynamicWidget::getBuilder), LayoutBuilder.class).forEach(consumer::accept);
    }

    void alignCells() {
        if (this.isAlignmentPaused) {
            return;
        }
        this.cells.stream().map(DynamicWidget::getBuilder).forEach(DynamicBuilder::resetLayout);
        int cellsPerRow = Math.max(((GridBuilder)this.builder).cellsPerRow.applyAsInt(this), 1);
        int rowSpacing = ((GridBuilder)this.builder).rowSpacing.applyAsInt(this);
        int columnSpacing = ((GridBuilder)this.builder).columnSpacing.applyAsInt(this);
        int rowWidth = this.getWidth() - columnSpacing * (cellsPerRow - 1);
        int cellWidth = Math.round((float)rowWidth / (float)cellsPerRow);
        int roundingError = this.getWidth() - cellWidth * cellsPerRow - columnSpacing * (cellsPerRow - 1);
        List<List<Cell>> rows = CollectionUtil.partition(this.cells.stream().filter(DynamicWidget::isVisible), cellsPerRow);
        int maxCellHeight = rows.stream().flatMap(this::getWidgetsFromRow).mapToInt(DynamicWidget::getHeight).max().orElse(20);
        rows.forEach(row -> {
            int maxRowHeight = row.stream().map(Cell::getWidget).mapToInt(DynamicWidget::getHeight).max().orElse(20);
            if (((GridBuilder)this.builder).alignAllCells) {
                this.setLayoutForCells((List<Cell>)row, builder -> builder.height(() -> maxCellHeight));
            } else if (((GridBuilder)this.builder).alignRowHeights) {
                this.setLayoutForCells((List<Cell>)row, builder -> builder.height(() -> maxRowHeight));
            }
            this.setLayoutForCells((List<Cell>)row, builder -> builder.width(() -> cellWidth));
            ForEachWithPrevious.create(row).applyToFirst(cell -> ((CellBuilder)cell.getBuilder()).posX(this::getX)).applyToLast(cell -> ((CellBuilder)cell.getBuilder()).width(() -> cellWidth + roundingError)).forEach((lastCell, nextCell) -> ((CellBuilder)nextCell.getBuilder()).rightOf((DynamicWidget<?, ?>)lastCell, columnSpacing)).run();
        });
        ForEachWithPrevious.create(rows).forEach((lastRow, nextRow) -> CollectionUtil.first(nextRow).ifPresent(cell -> ((CellBuilder)cell.getBuilder()).belowAll((Collection<? extends DynamicWidget<?, ?>>)lastRow, rowSpacing))).run();
        CollectionUtil.first(rows).flatMap(CollectionUtil::first).ifPresent(cell -> ((CellBuilder)cell.getBuilder()).pos(this::getX, this::getY));
        if (((GridBuilder)this.builder).extendLastCell) {
            CollectionUtil.last(rows).flatMap(CollectionUtil::last).ifPresent(cell -> {
                ((CellBuilder)cell.getBuilder()).extendWidthToEnd(this, 0);
                ((CellBuilder)cell.getBuilder()).resetWidth();
            });
        } else {
            CollectionUtil.last(rows).ifPresent(row -> {
                if (row.size() < cellsPerRow) {
                    CollectionUtil.last(row).ifPresent(cell -> ((CellBuilder)cell.getBuilder()).width(() -> cellWidth));
                }
            });
        }
        DynamicWidget.syncWithoutCache(this.cells.stream().map(Cell::getWidget).toList());
        DynamicWidget.syncWithoutCache(this.cells);
        this.setHeight(this.cells.stream().mapToInt(DynamicWidget::getEndY).max().orElse(this.getEndY()) - this.getY());
        this.cellsPerRow = cellsPerRow;
    }

    @Override
    public void setVisible(boolean state) {
        super.setVisible(state);
        this.cells.forEach(cell -> cell.setVisible(state));
    }

    @Override
    public void setActive(boolean state) {
        super.setActive(state);
        this.cells.forEach(cell -> cell.setActive(state));
    }

    protected void realign() {
        DynamicWidget.syncWithoutCache(this.cells.stream().map(Cell::getWidget).toList());
        DynamicWidget.sync(this.cells);
        if (this.isRealignNeeded) {
            this.isRealignNeeded = false;
            this.alignCells();
            DynamicWidget.syncWithoutCache(this.cells.stream().map(Cell::getWidget).toList());
            DynamicWidget.sync(this.cells);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        this.realign();
        this.renderDebug(graphics);
    }
}

