/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.embed;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.client.gui.tooltip.TooltipManager;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.RelativeLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.embed.EmbedBuilder;
import mod.adrenix.nostalgic.client.gui.widget.embed.EmbedWidgets;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.Scrollbar;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.ScrollbarBuilder;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.renderer.MatrixUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.CacheValue;
import mod.adrenix.nostalgic.util.common.data.RecursionAvoidance;
import mod.adrenix.nostalgic.util.common.math.DynamicRectangle;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import org.jetbrains.annotations.Nullable;

public class Embed
extends DynamicWidget<EmbedBuilder, Embed>
implements WidgetHolder,
TooltipManager,
RelativeLayout,
ContainerEventHandler {
    protected final RecursionAvoidance pathFinder = RecursionAvoidance.create();
    protected GuiEventListener focusedListener;
    protected DynamicRectangle<Embed> scissor;
    protected final EmbedBuilder builder;
    protected final EmbedWidgets widgets = new EmbedWidgets();
    protected final BlankWidget relativeTop;
    protected final BlankWidget relativeLeft;
    protected final Scrollbar verticalScrollbar;
    protected final Scrollbar horizontalScrollbar;
    protected final int scrollbarSize;
    protected boolean isEmbeddedDragging;
    protected boolean isResizingPaused;

    public static EmbedBuilder create() {
        return new EmbedBuilder();
    }

    protected Embed(EmbedBuilder builder) {
        super(builder);
        this.builder = builder;
        this.scrollbarSize = builder.scrollbarSize;
        this.relativeTop = (BlankWidget)((BlankBuilder)((BlankBuilder)BlankWidget.create().size(0)).relativeTo(this)).build(List.of(this.widgets.all::add, this.widgets.internal::add, this.widgets.relatives::add));
        this.relativeLeft = (BlankWidget)((BlankBuilder)((BlankBuilder)BlankWidget.create().size(0)).relativeTo(this)).build(List.of(this.widgets.all::add, this.widgets.internal::add, this.widgets.relatives::add));
        this.verticalScrollbar = (Scrollbar)((ScrollbarBuilder)((ScrollbarBuilder)((ScrollbarBuilder)((ScrollbarBuilder)Scrollbar.vertical(this::getContentHeight, this::getAverageWidgetHeight).animation(Animate.easeInOutCircular(1L, TimeUnit.SECONDS)).size(this.scrollbarSize).pos(this::getVerticalScrollbarStartX, this::getVerticalScrollbarStartY)).height(this::getScrollbarHeight)).visibleIf(this::isVerticalScrollable)).onVisibleChange(this::updateWidgets)).build(List.of(this.widgets.all::add, this.widgets.internal::add, this.widgets.scrollbars::add));
        this.horizontalScrollbar = (Scrollbar)((ScrollbarBuilder)((ScrollbarBuilder)((ScrollbarBuilder)((ScrollbarBuilder)Scrollbar.horizontal(this::getContentWidth, this::getAverageWidgetWidth).animation(Animate.easeInOutCircular(1L, TimeUnit.SECONDS)).size(this.scrollbarSize).pos(this::getHorizontalScrollbarStartX, this::getHorizontalScrollbarStartY)).width(this::getScrollbarWidth)).visibleIf(this::isHorizontalScrollable)).onVisibleChange(this::updateWidgets)).build(List.of(this.widgets.all::add, this.widgets.internal::add, this.widgets.scrollbars::add));
        this.setDefaultScissor();
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets.all.stream().filter(DynamicWidget::isVisible).toList();
    }

    public boolean isDragging() {
        return this.isEmbeddedDragging;
    }

    public void setDragging(boolean isDragging) {
        this.isEmbeddedDragging = isDragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focusedListener;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        this.setFocused(focused, true);
    }

    public void setFocused(@Nullable GuiEventListener focused, boolean smoothScrollToFocused) {
        DynamicWidget dynamic;
        this.widgets.all.stream().filter(DynamicWidget::isFocused).forEach(DynamicWidget::setUnfocused);
        if (this.focusedListener != null) {
            this.focusedListener.setFocused(false);
        }
        if (focused instanceof DynamicWidget && (dynamic = (DynamicWidget)focused).canFocus()) {
            dynamic.setFocused(true);
            this.setScrollOn(dynamic);
        }
        this.focusedListener = focused;
    }

    public void setScrollOn(DynamicWidget<?, ?> widget) {
        if (this.widgets.internal.contains(widget) || widget.isAnchored()) {
            return;
        }
        this.getVisibleWidgets().filter(visible -> visible.equals(widget)).findFirst().ifPresent(this::scrollTo);
    }

    protected void scrollTo(DynamicWidget<?, ?> widget) {
        int relX = widget.getX() - (this.getScrollOffsetX() + this.getPaddingLeft());
        int relY = widget.getY() - (this.getScrollOffsetY() + this.getPaddingTop());
        int width = widget.getWidth();
        int height = widget.getHeight();
        if (this.isVerticalScrollbarVisible()) {
            this.verticalScrollbar.setScrollAmount((double)relY + (double)height / 2.0 - (double)this.getInsideHeight() / 2.0);
        }
        if (this.isHorizontalScrollbarVisible()) {
            this.horizontalScrollbar.setScrollAmount((double)relX + (double)width / 2.0 - (double)this.getInsideWidth() / 2.0);
        }
    }

    @Nullable
    protected ComponentPath getNextPath(FocusNavigationEvent event) {
        if (this.getScreen() == null) {
            return null;
        }
        ComponentPath nextPath = super.nextFocusPath(event);
        if (this.focusedListener != null && nextPath == null) {
            this.focusedListener.setFocused(false);
            this.focusedListener = null;
            return null;
        }
        return nextPath;
    }

    @Override
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (!this.canFocus() || this.isInactive() || this.isInvisible() || this.pathFinder.isProcessing()) {
            return null;
        }
        return this.pathFinder.process(() -> this.getNextPath(event));
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets() {
        return this.widgets.all;
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getTooltipWidgets() {
        return this.widgets.all;
    }

    protected void syncEmbeddedWithoutCache() {
        int prevWidth = this.width;
        int prevHeight = this.height;
        int widthOffset = this.verticalScrollbar.isVisible() ? this.scrollbarSize : 0;
        int heightOffset = this.horizontalScrollbar.isVertical() ? this.scrollbarSize : 0;
        this.setWidth(this.width - widthOffset - this.getPaddingRight());
        this.setHeight(this.height - heightOffset - this.getPaddingBottom());
        DynamicWidget.syncWithoutCache(this.widgets.embedded);
        this.setWidth(prevWidth);
        this.setHeight(prevHeight);
        DynamicWidget.sync(List.of(this));
    }

    public void updateWidgets() {
        DynamicWidget.syncWithoutCache(this.widgets.relatives);
        this.syncEmbeddedWithoutCache();
        DynamicWidget.syncWithoutCache(this.widgets.relatives);
    }

    @Override
    public void addWidget(DynamicWidget<?, ?> widget) {
        Object obj = widget.getBuilder();
        if (obj instanceof LayoutBuilder) {
            LayoutBuilder layout = (LayoutBuilder)obj;
            layout.relativeTo(this);
        }
        this.widgets.addScissored(widget);
        this.resizeIfNeeded();
    }

    @Override
    public void addWidgets(DynamicWidget<?, ?> ... widgets) {
        for (DynamicWidget<?, ?> widget : widgets) {
            this.addWidget(widget);
        }
    }

    public void addProjectedWidget(DynamicWidget<?, ?> widget) {
        this.addWidget(widget);
        this.widgets.addProjected(widget);
    }

    public void addProjectedWidgets(DynamicWidget<?, ?> ... widgets) {
        for (DynamicWidget<?, ?> widget : widgets) {
            this.addProjectedWidget(widget);
        }
    }

    @Override
    public void removeWidget(@Nullable DynamicWidget<?, ?> widget) {
        if (widget == null) {
            return;
        }
        this.widgets.removeAll(widget);
    }

    public void removeAllWidgets() {
        UniqueArrayList embedded = new UniqueArrayList(this.widgets.embedded);
        embedded.forEach((Consumer<DynamicWidget<?, ?>>)((Consumer<DynamicWidget>)xva$0 -> this.widgets.removeAll((DynamicWidget<?, ?>)xva$0)));
        embedded.clear();
    }

    public void setCustomScissor(DynamicRectangle<Embed> scissor) {
        this.scissor = scissor;
    }

    public int getScissorX(Embed embed) {
        return embed.getInsideX() + embed.builder.scissorPadding;
    }

    public int getScissorY(Embed embed) {
        return embed.getInsideY() + embed.builder.scissorPadding;
    }

    public int getScissorEndX(Embed embed) {
        return embed.getInsideEndX() - embed.builder.scissorPadding;
    }

    public int getScissorEndY(Embed embed) {
        return embed.getInsideEndY() - embed.builder.scissorPadding;
    }

    public void setDefaultScissor() {
        this.scissor = new DynamicRectangle<Embed>(this::getScissorX, this::getScissorY, this::getScissorEndX, this::getScissorEndY);
    }

    public int getInsideX() {
        return this.getX() + this.getOutlineThickness();
    }

    public int getInsideY() {
        return this.getY() + this.getOutlineThickness();
    }

    public int getInsideWidth() {
        return this.width - this.getOutlineThickness() * 2;
    }

    public int getInsideHeight() {
        return this.height - this.getOutlineThickness() * 2;
    }

    public int getInsideEndX() {
        return this.x + this.width - this.getOutlineThickness();
    }

    public int getInsideEndY() {
        return this.y + this.height - this.getOutlineThickness();
    }

    public int getScrollOffsetX() {
        return (int)((double)this.getInsideX() - this.getScrollAmountX());
    }

    public int getScrollOffsetY() {
        return (int)((double)this.getInsideY() - this.getScrollAmountY());
    }

    public int getPaddingTop() {
        return Math.max(this.builder.paddingTop, this.builder.scissorPadding);
    }

    public int getPaddingRight() {
        return Math.max(this.builder.paddingRight, this.builder.scissorPadding);
    }

    public int getPaddingBottom() {
        return Math.max(this.builder.paddingBottom, this.builder.scissorPadding);
    }

    public int getPaddingLeft() {
        return Math.max(this.builder.paddingLeft, this.builder.scissorPadding);
    }

    public int getOutlineThickness() {
        return this.builder.borderColor.isPresent() ? this.builder.borderThickness : 0;
    }

    @Override
    public int getRelativeX(DynamicWidget<?, ?> widget) {
        boolean isInternal = this.widgets.internal.contains(widget) && !this.widgets.relatives.contains(widget);
        return isInternal ? this.getInsideX() : this.getScrollOffsetX() + this.getPaddingLeft();
    }

    @Override
    public int getRelativeY(DynamicWidget<?, ?> widget) {
        boolean isInternal = this.widgets.internal.contains(widget) && !this.widgets.relatives.contains(widget);
        return isInternal ? this.getInsideY() : this.getScrollOffsetY() + this.getPaddingTop();
    }

    @Override
    public int getAnchoredX(DynamicWidget<?, ?> widget) {
        return this.getX() + this.getPaddingLeft();
    }

    @Override
    public int getAnchoredY(DynamicWidget<?, ?> widget) {
        return this.getY() + this.getPaddingTop();
    }

    public boolean isHorizontalScrollbarVisible() {
        if (this.horizontalScrollbar == null) {
            return false;
        }
        return this.horizontalScrollbar.isVisible();
    }

    public boolean isVerticalScrollbarVisible() {
        if (this.verticalScrollbar == null) {
            return false;
        }
        return this.verticalScrollbar.isVisible();
    }

    public boolean areScrollbarsVisible() {
        return this.isHorizontalScrollbarVisible() && this.isVerticalScrollbarVisible();
    }

    public boolean isScrollbarHeld() {
        return this.verticalScrollbar.isDragging() || this.horizontalScrollbar.isDragging();
    }

    public void resetScrollAmount() {
        this.verticalScrollbar.setScrollAmount(0.0);
        this.horizontalScrollbar.setScrollAmount(0.0);
    }

    protected Stream<DynamicWidget<?, ?>> getScrollableWidgets() {
        return this.widgets.embedded.stream().filter(DynamicWidget::isNotAnchored).filter(DynamicWidget::isVisible);
    }

    protected int getVerticalScrollbarStartX() {
        return this.getInsideEndX() - this.scrollbarSize;
    }

    protected int getVerticalScrollbarStartY() {
        return this.getInsideY();
    }

    protected int getHorizontalScrollbarStartX() {
        return this.getInsideX();
    }

    protected int getHorizontalScrollbarStartY() {
        return this.getInsideEndY() - this.scrollbarSize;
    }

    protected int getScrollbarWidth() {
        return this.getInsideWidth() - (this.areScrollbarsVisible() ? this.scrollbarSize : 0);
    }

    protected int getScrollbarHeight() {
        return this.getInsideHeight() - (this.areScrollbarsVisible() ? this.scrollbarSize : 0);
    }

    public double getScrollAmountX() {
        return this.horizontalScrollbar.getScrollAmount();
    }

    public double getScrollAmountY() {
        return this.verticalScrollbar.getScrollAmount();
    }

    protected int getContentWidth() {
        int endX = this.isVerticalScrollbarVisible() ? this.getVerticalScrollbarStartX() : this.getInsideEndX();
        int x1 = this.getScrollableWidgets().mapToInt(DynamicWidget::getEndX).max().orElse(endX);
        int x0 = this.relativeLeft.getX();
        return Math.abs(x1 - x0) + this.getPaddingLeft() + this.getPaddingRight();
    }

    protected int getContentHeight() {
        int endY = this.isHorizontalScrollbarVisible() ? this.getHorizontalScrollbarStartY() : this.getInsideEndY();
        int y1 = this.getScrollableWidgets().mapToInt(DynamicWidget::getEndY).max().orElse(endY);
        int y0 = this.relativeTop.getY();
        return Math.abs(y1 - y0) + this.getPaddingTop() + this.getPaddingBottom();
    }

    protected double getAverageWidgetWidth() {
        return (double)this.getScrollableWidgets().mapToInt(DynamicWidget::getWidth).sum() / (double)this.getContentWidth();
    }

    protected double getAverageWidgetHeight() {
        return (double)this.getScrollableWidgets().mapToInt(DynamicWidget::getHeight).sum() / (double)this.getContentHeight();
    }

    protected boolean isVerticalScrollable(Scrollbar scrollbar) {
        if (this.getContentHeight() <= this.getHeight()) {
            return false;
        }
        return scrollbar.getMaxScrollAmount() > 0;
    }

    protected boolean isHorizontalScrollable(Scrollbar scrollbar) {
        if (this.getContentWidth() <= this.getWidth()) {
            return false;
        }
        return scrollbar.getMaxScrollAmount() > 0;
    }

    public int getScrollbarSize() {
        return ((EmbedBuilder)this.getBuilder()).scrollbarSize;
    }

    @Override
    public void tick() {
        this.widgets.all.forEach((Consumer<DynamicWidget<?, ?>>)((Consumer<DynamicWidget>)DynamicWidget::tick));
        if (this.builder.onTick != null) {
            this.builder.onTick.run();
        }
    }

    @Override
    public Stream<DynamicWidget<?, ?>> getWidgetStream() {
        return this.widgets.embedded.stream();
    }

    @Override
    public Stream<DynamicWidget<?, ?>> getVisibleWidgets() {
        return this.widgets.embedded.stream().filter(DynamicWidget::isVisible);
    }

    public Stream<DynamicWidget<?, ?>> getVisibleWidgets(UniqueArrayList<DynamicWidget<?, ?>> widgets) {
        return widgets.stream().filter(DynamicWidget::isVisible);
    }

    public Optional<DynamicWidget<?, ?>> getWidgetAtPoint(double mouseX, double mouseY) {
        return this.getVisibleWidgets().filter(DynamicWidget::isVisible).filter(widget -> widget.isMouseOver(mouseX, mouseY)).findFirst();
    }

    public boolean isWidgetOutside(DynamicWidget<?, ?> widget) {
        boolean isOutsideX = widget.getEndX() < this.getInsideX() || widget.getX() > this.getInsideEndX();
        boolean isOutsideY = widget.getEndY() < this.getInsideY() || widget.getY() > this.getInsideEndY();
        return isOutsideX || isOutsideY;
    }

    public boolean isWidgetInside(DynamicWidget<?, ?> widget) {
        return !this.isWidgetOutside(widget);
    }

    public boolean isMouseInsideWindow(double mouseX, double mouseY) {
        double dx = this.isHorizontalScrollbarVisible() ? (double)this.scrollbarSize : 0.0;
        double dy = this.isVerticalScrollbarVisible() ? (double)this.scrollbarSize : 0.0;
        double embedX = this.getInsideX();
        double embedY = this.getInsideY();
        double embedW = (double)this.getInsideWidth() - dx;
        double embedH = (double)this.getInsideHeight() - dy;
        return MathUtil.isWithinBox(mouseX, mouseY, embedX, embedY, embedW, embedH);
    }

    protected boolean isEventListened(Predicate<DynamicWidget<?, ?>> predicate) {
        if (this.isInvisible()) {
            return false;
        }
        return CollectionUtil.test(this.getVisibleWidgets(this.widgets.all), predicate);
    }

    public boolean isWidgetClicked(double mouseX, double mouseY, int button) {
        if (this.isInvisible() || button != 0) {
            return false;
        }
        boolean isMouseOverScrollbar = this.widgets.scrollbars.stream().filter(DynamicWidget::isVisible).anyMatch(scrollbar -> scrollbar.isMouseOver(mouseX, mouseY));
        if (this.isScrollbarHeld() || isMouseOverScrollbar) {
            return false;
        }
        return this.widgets.embedded.stream().anyMatch(widget -> widget.isMouseOver(mouseX, mouseY));
    }

    @Override
    public boolean isValidClick(double mouseX, double mouseY, int button) {
        if (this.isInvisible()) {
            return false;
        }
        return button == 0 && MathUtil.isWithinBox(mouseX, mouseY, this.x, this.y, this.width, this.height);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInvisible()) {
            return false;
        }
        if (this.builder.mouseClicked != null && this.builder.mouseClicked.accept(mouseX, mouseY, button)) {
            return true;
        }
        if (this.widgets.scrollbars.stream().anyMatch(scrollbar -> scrollbar.mouseClicked(mouseX, mouseY, button))) {
            return true;
        }
        boolean isWidgetClicked = this.isEventListened(widget -> {
            if (this.widgets.embedded.contains(widget) && !this.isMouseInsideWindow(mouseX, mouseY)) {
                return false;
            }
            boolean isClicked = widget.mouseClicked(mouseX, mouseY, button);
            if (isClicked) {
                this.widgets.all.stream().filter(DynamicWidget::isFocused).forEach(DynamicWidget::setUnfocused);
                widget.setClickFocus();
            }
            return isClicked;
        });
        if (isWidgetClicked) {
            return true;
        }
        if (this.isMouseInsideWindow(mouseX, mouseY) && this.isValidClick(mouseX, mouseY, button)) {
            this.widgets.embedded.stream().filter(DynamicWidget::isFocused).forEach(DynamicWidget::setUnfocused);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isInvisible()) {
            return false;
        }
        if (this.builder.mouseReleased != null && this.builder.mouseReleased.accept(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isEventListened(widget -> widget.mouseReleased(mouseX, mouseY, button))) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isInvisible()) {
            return false;
        }
        if (this.builder.mouseDragged != null && this.builder.mouseDragged.accept(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.isEventListened(widget -> widget.mouseDragged(mouseX, mouseY, button, dragX, dragY))) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isInvisible() || !this.isMouseInsideWindow(mouseX, mouseY)) {
            return false;
        }
        if (this.builder.mouseScrolled != null && this.builder.mouseScrolled.accept(mouseX, mouseY, deltaY)) {
            return true;
        }
        boolean isWidgetScrolled = this.getWidgetAtPoint(mouseX, mouseY).stream().anyMatch(widget -> widget.mouseScrolled(mouseX, mouseY, deltaX, deltaY));
        if (isWidgetScrolled) {
            return true;
        }
        if (this.isEventListened(widget -> widget.mouseScrolled(mouseX, mouseY, deltaX, deltaY))) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isInvisible()) {
            return false;
        }
        if (this.builder.keyPressed != null && this.builder.keyPressed.accept(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.isEventListened(widget -> widget.keyPressed(keyCode, scanCode, modifiers))) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.isInvisible()) {
            return false;
        }
        if (this.builder.keyReleased != null && this.builder.keyReleased.accept(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.isEventListened(widget -> widget.keyReleased(keyCode, scanCode, modifiers))) {
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (this.isInvisible()) {
            return false;
        }
        if (this.builder.charTyped != null && this.builder.charTyped.accept(codePoint, modifiers)) {
            return true;
        }
        if (this.isEventListened(widget -> widget.charTyped(codePoint, modifiers))) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    protected int getInsideWidgetWidth() {
        int minX = this.getVisibleWidgets().mapToInt(DynamicWidget::getX).min().orElse(this.getInsideX());
        int maxX = this.getVisibleWidgets().mapToInt(DynamicWidget::getEndX).max().orElse(this.getInsideX() + 20);
        int margin = Math.abs(this.relativeLeft.getX() - minX) * 2;
        return Math.abs(maxX - minX) + margin;
    }

    protected int getInsideWidgetHeight() {
        int minY = this.getVisibleWidgets().mapToInt(DynamicWidget::getY).min().orElse(this.getInsideY());
        int maxY = this.getVisibleWidgets().mapToInt(DynamicWidget::getEndY).max().orElse(this.getInsideY() + 20);
        int margin = Math.abs(this.relativeTop.getY() - minY) * 2;
        return Math.abs(maxY - minY) + margin;
    }

    public void setResizerToPaused() {
        this.isResizingPaused = true;
    }

    public void setResizerToResume() {
        this.isResizingPaused = false;
    }

    protected void resizeIfNeeded() {
        boolean isHeightChanged;
        boolean isWidthChanged;
        if (this.isResizingPaused) {
            return;
        }
        boolean isResized = false;
        if ((this.builder.resizeWidthForWidgets || this.builder.resizeForWidgets) && (isWidthChanged = this.widgets.embedded.stream().map(DynamicWidget::getCache).map(WidgetCache::getWidth).anyMatch(CacheValue::isExpired))) {
            isResized = true;
        }
        if ((this.builder.resizeHeightForWidgets || this.builder.resizeForWidgets) && (isHeightChanged = this.widgets.embedded.stream().map(DynamicWidget::getCache).map(WidgetCache::getHeight).anyMatch(CacheValue::isExpired))) {
            isResized = true;
        }
        if (isResized) {
            this.syncBeforeRender();
            this.updateSize();
        }
    }

    protected void updateSize() {
        this.verticalScrollbar.setScrollAmount(0.0);
        this.horizontalScrollbar.setSmoothScrollAmount(0.0);
        this.updateWidgets();
        if (this.builder.resizeForWidgets) {
            this.resizeWidthToFitContent();
            this.resizeHeightToFitContent();
        } else if (this.builder.resizeWidthForWidgets) {
            this.resizeWidthToFitContent();
        } else if (this.builder.resizeHeightForWidgets) {
            this.resizeHeightToFitContent();
        }
        this.updateWidgets();
    }

    public void resizeForOverflow() {
        int width = this.getInsideWidgetWidth();
        int height = this.getInsideWidgetHeight();
        if (this.width != width) {
            this.setWidth(width + this.getPaddingLeft() + this.getPaddingRight());
        }
        if (this.height != height) {
            this.setHeight(height + this.getPaddingTop() + this.getPaddingBottom());
        }
    }

    public void resizeWidthToFitContent() {
        this.setWidth(0);
        int width = this.getInsideWidgetWidth();
        if (width != this.width) {
            this.setWidth(width + this.getPaddingLeft() + this.getPaddingRight());
        }
    }

    public void resizeHeightToFitContent() {
        this.setHeight(0);
        int height = this.getInsideWidgetHeight();
        if (height != this.height) {
            this.setHeight(height + this.getPaddingTop() + this.getPaddingBottom());
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isInvisible()) {
            return;
        }
        this.renderBackground(graphics);
        this.renderWidgets(graphics, mouseX, mouseY, partialTick);
        if (((EmbedBuilder)this.getBuilder()).borderRenderer != null) {
            ((EmbedBuilder)this.getBuilder()).borderRenderer.accept(this, graphics, mouseX, mouseY, partialTick);
        }
    }

    protected void renderBackground(GuiGraphics graphics) {
        this.resizeIfNeeded();
        RenderUtil.beginBatching();
        int startX = this.getInsideX();
        int startY = this.getInsideY();
        int endX = this.getInsideEndX();
        int endY = this.getInsideEndY();
        if (this.builder.backgroundGradient == null) {
            RenderUtil.fill(graphics, (float)startX, (float)startY, (float)endX, (float)endY, this.builder.backgroundColor);
        } else {
            RenderUtil.gradient(this.builder.backgroundGradient, graphics, startX, startY, endX, endY);
        }
        if (this.builder.borderColor.isPresent()) {
            RenderUtil.outline(graphics, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)this.builder.borderThickness, this.builder.borderColor);
        }
        RenderUtil.endBatching();
    }

    protected void syncBeforeRender() {
        this.syncEmbeddedWithoutCache();
        DynamicWidget.syncWithoutCache(this.widgets.relatives);
        DynamicWidget.syncWithoutCache(this.widgets.scrollbars);
    }

    protected void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.verticalScrollbar.isInvisible() && this.verticalScrollbar.getScrollAmount() > 0.0) {
            this.verticalScrollbar.setScrollAmount(0.0);
        }
        if (this.horizontalScrollbar.isInvisible() && this.horizontalScrollbar.getScrollAmount() > 0.0) {
            this.horizontalScrollbar.setScrollAmount(0.0);
        }
        boolean isVerticalVisible = this.verticalScrollbar.isVisible();
        boolean isHorizontalVisible = this.horizontalScrollbar.isVisible();
        this.syncBeforeRender();
        boolean isVerticalChanged = isVerticalVisible != this.verticalScrollbar.isVisible();
        boolean isHorizontalChanged = isHorizontalVisible != this.horizontalScrollbar.isVisible();
        boolean isBatchRendering = RenderUtil.isBatching();
        if (isVerticalChanged || isHorizontalChanged) {
            this.syncBeforeRender();
        }
        if (isBatchRendering) {
            RenderUtil.endBatching();
        }
        RenderUtil.pushZoneScissor(this.scissor.getRectangle(this));
        RenderUtil.batch(() -> {
            if (((EmbedBuilder)this.getBuilder()).preRenderer != null) {
                ((EmbedBuilder)this.getBuilder()).preRenderer.accept(this, graphics, mouseX, mouseY, partialTick);
            }
            DynamicWidget.renderWithoutSync(this.widgets.scissored, graphics, mouseX, mouseY, partialTick);
            if (((EmbedBuilder)this.getBuilder()).postRenderer != null) {
                ((EmbedBuilder)this.getBuilder()).postRenderer.accept(this, graphics, mouseX, mouseY, partialTick);
            }
        });
        RenderUtil.popScissor();
        if (isBatchRendering) {
            RenderUtil.beginBatching();
        }
        DynamicWidget.renderWithoutSync(this.widgets.projected, graphics, mouseX, mouseY, partialTick);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, MatrixUtil.getZ(graphics.pose()) + 20.0f);
        DynamicWidget.render(this.widgets.internal, graphics, mouseX, mouseY, partialTick);
        if (this.areScrollbarsVisible()) {
            int sX = this.getInsideEndX() - this.scrollbarSize;
            int sY = this.getInsideEndY() - this.scrollbarSize;
            int eX = this.getInsideEndX();
            int eY = this.getInsideEndY();
            RenderUtil.fill(graphics, (float)sX, (float)sY, (float)eX, (float)eY, Color.SONIC_SILVER);
        }
        graphics.pose().popPose();
        DynamicWidget.applyCache(this.widgets.embedded);
        DynamicWidget.applyCache(this.widgets.relatives);
    }
}

