/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.dynamic;

import java.util.Collection;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;

public interface WidgetHolder {
    public Collection<DynamicWidget<?, ?>> getWidgets();

    default public Stream<DynamicWidget<?, ?>> getWidgetStream() {
        return this.getWidgets().stream();
    }

    default public Stream<DynamicWidget<?, ?>> getVisibleWidgets() {
        return this.getWidgets().stream().filter(DynamicWidget::isVisible);
    }

    default public void addWidget(DynamicWidget<?, ?> widget) {
        this.getWidgets().add(widget);
    }

    default public void addWidgets(DynamicWidget<?, ?> ... widgets) {
        for (DynamicWidget<?, ?> widget : widgets) {
            this.addWidget(widget);
        }
    }

    default public void addWidgets(Collection<DynamicWidget<?, ?>> widgets) {
        widgets.forEach(this::addWidget);
    }

    default public void removeWidget(DynamicWidget<?, ?> widget) {
        this.getWidgets().remove(widget);
    }

    default public void removeWidgets(DynamicWidget<?, ?> ... widgets) {
        for (DynamicWidget<?, ?> widget : widgets) {
            this.removeWidget(widget);
        }
    }

    default public void removeWidgets(Collection<DynamicWidget<?, ?>> widgets) {
        widgets.forEach(this::removeWidget);
    }
}

