/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.dynamic;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.MouseManager;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.tooltip.Tooltip;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.RelativeLayout;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderPass;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.RecursionAvoidance;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.math.Rectangle;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWidget<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
implements Renderable,
GuiEventListener,
LayoutElement {
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected int tabOrderGroup;
    protected boolean active = true;
    protected boolean visible = true;
    protected boolean focused = false;
    protected boolean overrideFocus = false;
    protected final Builder builder;
    protected final RenderPass renderPass;
    @Nullable
    protected Screen screen;
    public final WidgetCache cache;
    private final RecursionAvoidance hoverOrFocusSync;

    public static void sync(Collection<? extends DynamicWidget<?, ?>> widgets) {
        DynamicWidget.syncWithoutCache(widgets);
        DynamicWidget.applyCache(widgets);
    }

    public static void applyCache(Collection<? extends DynamicWidget<?, ?>> widgets) {
        widgets.stream().map(DynamicWidget::getCache).forEach(WidgetCache::update);
    }

    public static void syncWithoutCache(Collection<? extends DynamicWidget<?, ?>> widgets) {
        widgets.forEach(widget -> {
            ((DynamicBuilder)widget.builder).relativeSync();
            ((DynamicBuilder)widget.builder).preSync();
            ((DynamicBuilder)widget.builder).sync();
            ((DynamicBuilder)widget.builder).postSync();
        });
    }

    public static void render(Collection<? extends DynamicWidget<?, ?>> widgets, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        DynamicWidget.sync(widgets);
        DynamicWidget.renderWithoutSync(widgets, graphics, mouseX, mouseY, partialTick);
    }

    public static void renderWithoutSync(Collection<? extends DynamicWidget<?, ?>> widgets, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderPass.apply(widgets, DynamicWidget::getRenderPass, widget -> widget.render(graphics, mouseX, mouseY, partialTick));
    }

    protected DynamicWidget(Builder builder) {
        this.builder = builder;
        this.renderPass = ((DynamicBuilder)builder).renderPass;
        this.tabOrderGroup = ((DynamicBuilder)builder).tabOrderGroup;
        this.hoverOrFocusSync = RecursionAvoidance.create();
        this.cache = WidgetCache.from(this);
    }

    public Widget self() {
        return (Widget)this;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public WidgetCache getCache() {
        return this.cache;
    }

    public void setScreen(@Nullable Screen screen) {
        this.screen = screen;
    }

    @Nullable
    public Screen getScreen() {
        if (this.screen != null) {
            return this.screen;
        }
        return GuiUtil.getScreen().orElse(null);
    }

    public int getScreenWidth() {
        Screen screen = this.getScreen();
        if (screen == null) {
            return 0;
        }
        if (screen instanceof Overlay) {
            Overlay overlay = (Overlay)screen;
            return overlay.getScreenEndX();
        }
        return screen.width;
    }

    public int getScreenHeight() {
        Screen screen = this.getScreen();
        if (screen == null) {
            return 0;
        }
        if (screen instanceof Overlay) {
            Overlay overlay = (Overlay)screen;
            return overlay.getScreenEndY();
        }
        return screen.height;
    }

    private void setInfoTooltip() {
        if (((DynamicBuilder)this.builder).infoTooltip != null) {
            Tooltip.setInfo(((DynamicBuilder)this.builder).infoTooltip.get());
        }
        if (((DynamicBuilder)this.builder).multilineInfoTooltip != null) {
            Tooltip.setInfo(((DynamicBuilder)this.builder).multilineInfoTooltip.get());
        }
        if (this.isInactive()) {
            if (((DynamicBuilder)this.builder).disabledInfoTooltip != null) {
                Tooltip.setInfo(((DynamicBuilder)this.builder).disabledInfoTooltip.get());
            }
            if (((DynamicBuilder)this.builder).disabledMultilineInfoTooltip != null) {
                Tooltip.setInfo(((DynamicBuilder)this.builder).disabledMultilineInfoTooltip.get());
            }
        }
    }

    private void setActiveTooltip() {
        List<Component> components;
        boolean isHidden;
        boolean isTimeInvalid = ((DynamicBuilder)this.builder).tooltipTimer == null || !((DynamicBuilder)this.builder).tooltipTimer.getFlag();
        boolean isInactive = ((DynamicBuilder)this.builder).disabledTooltipTimer != null && this.isInactive();
        boolean bl = isHidden = ((DynamicBuilder)this.builder).hideTimer != null && ((DynamicBuilder)this.builder).hideTimer.getFlag();
        if (isTimeInvalid || isInactive || isHidden) {
            return;
        }
        if (((DynamicBuilder)this.builder).tooltip != null) {
            Component tooltip = ((DynamicBuilder)this.builder).tooltip.get();
            if (GuiUtil.isComponentPresent(tooltip)) {
                Tooltip.setTooltip(tooltip);
                Tooltip.setRelativeToIfFocused(this);
                this.setInfoTooltip();
            }
        } else if (((DynamicBuilder)this.builder).multilineTooltip != null && GuiUtil.isComponentPresent(components = ((DynamicBuilder)this.builder).multilineTooltip.get())) {
            Tooltip.setListTooltip(components);
            Tooltip.setRelativeToIfFocused(this);
            this.setInfoTooltip();
        }
    }

    private void setInactiveTooltip() {
        List<Component> components;
        boolean isHidden;
        boolean isTimeInvalid = ((DynamicBuilder)this.builder).disabledTooltipTimer == null || !((DynamicBuilder)this.builder).disabledTooltipTimer.getFlag();
        boolean bl = isHidden = ((DynamicBuilder)this.builder).hideTimer != null && ((DynamicBuilder)this.builder).hideTimer.getFlag();
        if (this.isActive() || isTimeInvalid || isHidden) {
            return;
        }
        if (((DynamicBuilder)this.builder).disabledTooltip != null) {
            Component tooltip = ((DynamicBuilder)this.builder).disabledTooltip.get();
            if (GuiUtil.isComponentPresent(tooltip)) {
                Tooltip.setTooltip(tooltip);
                Tooltip.setRelativeToIfFocused(this);
                this.setInfoTooltip();
            }
        } else if (((DynamicBuilder)this.builder).disabledMultilineTooltip != null && GuiUtil.isComponentPresent(components = ((DynamicBuilder)this.builder).disabledMultilineTooltip.get())) {
            Tooltip.setListTooltip(components);
            Tooltip.setRelativeToIfFocused(this);
            this.setInfoTooltip();
        }
    }

    private void resetActiveTooltipTimer() {
        if (((DynamicBuilder)this.builder).tooltipTimer != null) {
            ((DynamicBuilder)this.builder).tooltipTimer.reset();
            if (((DynamicBuilder)this.builder).hideTimer != null) {
                ((DynamicBuilder)this.builder).hideTimer.reset();
            }
        }
    }

    private void resetInactiveTooltipTimer() {
        if (((DynamicBuilder)this.builder).disabledTooltipTimer != null) {
            ((DynamicBuilder)this.builder).disabledTooltipTimer.reset();
            if (((DynamicBuilder)this.builder).hideTimer != null) {
                ((DynamicBuilder)this.builder).hideTimer.reset();
            }
        }
    }

    public void resetTooltipTimer() {
        boolean isNotHoveredOrFocused;
        boolean isComboTimer = ((DynamicBuilder)this.builder).tooltipTimer != null && ((DynamicBuilder)this.builder).disabledTooltipTimer != null;
        boolean isMouseNotOver = !this.isMouseOver(this.getMouseX(), this.getMouseY());
        boolean bl = isNotHoveredOrFocused = !this.isHoveredOrFocused();
        if (isComboTimer) {
            if (this.isActive() && isNotHoveredOrFocused) {
                this.resetActiveTooltipTimer();
            }
            if (this.isInactive() && isMouseNotOver) {
                this.resetInactiveTooltipTimer();
            }
        } else {
            if (isNotHoveredOrFocused || this.isInactive() && isMouseNotOver) {
                this.resetActiveTooltipTimer();
            }
            if (isMouseNotOver) {
                this.resetInactiveTooltipTimer();
            }
        }
    }

    public boolean hasTooltipBuilder() {
        return ((DynamicBuilder)this.builder).tooltipTimer != null || ((DynamicBuilder)this.builder).disabledTooltipTimer != null;
    }

    public void setTooltip() {
        this.setActiveTooltip();
        this.setInactiveTooltip();
    }

    protected boolean isValidPoint(double mouseX, double mouseY) {
        return this.isActive() && this.isVisible() && this.isMouseOver(mouseX, mouseY);
    }

    protected boolean isInvalidPoint(double mouseX, double mouseY) {
        return !this.isValidPoint(mouseX, mouseY);
    }

    protected boolean isValidClick(double mouseX, double mouseY, int button) {
        return button == 0 && this.isValidPoint(mouseX, mouseY);
    }

    protected boolean isInvalidClick(double mouseX, double mouseY, int button) {
        return !this.isValidClick(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClick(mouseX, mouseY, button)) {
            this.onDrag(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.isWithinBox(mouseX, mouseY, this.x, this.y, this.width, this.height);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return super.charTyped(codePoint, modifiers);
    }

    public void setFocused(boolean focused) {
        if (focused && !this.canFocus()) {
            return;
        }
        this.focused = focused;
        if (((DynamicBuilder)this.builder).whenFocused != null && focused) {
            ((DynamicBuilder)this.builder).whenFocused.accept((DynamicWidget)((DynamicBuilder)this.builder).widget.get());
        }
    }

    public void setOverrideFocused(boolean focused) {
        this.focused = focused;
        this.overrideFocus = focused;
        if (((DynamicBuilder)this.builder).whenFocused != null && focused) {
            ((DynamicBuilder)this.builder).whenFocused.accept((DynamicWidget)((DynamicBuilder)this.builder).widget.get());
        }
        if (this.getScreen() != null) {
            this.getScreen().setFocused((GuiEventListener)this);
        }
    }

    public void setFocused() {
        this.setFocused(true);
    }

    public void setUnfocused() {
        this.setFocused(false);
    }

    public void setClickFocus() {
        this.setFocused(((DynamicBuilder)this.getBuilder()).focusOnClick);
    }

    public boolean canFocusOnClick() {
        return ((DynamicBuilder)this.getBuilder()).focusOnClick;
    }

    public boolean canFocus() {
        if (this.overrideFocus) {
            return true;
        }
        return ((DynamicBuilder)this.getBuilder()).canFocus.getAsBoolean();
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isUnfocused() {
        return !this.isFocused();
    }

    public int getMouseX() {
        return MouseManager.getX();
    }

    public int getMouseY() {
        return MouseManager.getY();
    }

    public boolean isFocusedAndActive() {
        return this.isActive() && this.isFocused();
    }

    public boolean isHoveredOrFocused() {
        boolean isHoveredOrFocused;
        if (this.isInvisible()) {
            return false;
        }
        int mouseX = this.getMouseX();
        int mouseY = this.getMouseY();
        boolean bl = isHoveredOrFocused = this.isFocused() || this.isMouseOver(mouseX, mouseY);
        if (this.hoverOrFocusSync.isProcessing()) {
            return isHoveredOrFocused;
        }
        boolean areAnySyncedHoveredOrFocused = Boolean.TRUE.equals(this.hoverOrFocusSync.process(() -> ((DynamicBuilder)this.builder).hoverSync.stream().anyMatch(DynamicWidget::isHoveredOrFocused)));
        return isHoveredOrFocused || areAnySyncedHoveredOrFocused;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (this.isInactive() || this.isInvisible() || !this.canFocus()) {
            return null;
        }
        if (this.isUnfocused()) {
            return ComponentPath.leaf((GuiEventListener)this);
        }
        return null;
    }

    @Nullable
    public ComponentPath getCurrentFocusPath() {
        return super.getCurrentFocusPath();
    }

    public ScreenRectangle getRectangle() {
        return super.getRectangle();
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
    }

    public int getTabOrderGroup() {
        return this.tabOrderGroup;
    }

    public Rectangle getPositionRectangle() {
        return new Rectangle(this.x, this.y, this.getEndX(), this.getEndY());
    }

    public void setTabOrderGroup(int tabOrderGroup) {
        this.tabOrderGroup = tabOrderGroup;
    }

    public void pos(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void setX(int x) {
        if (((DynamicBuilder)this.builder).forceRelativeX && ((DynamicBuilder)this.builder).isProcessingLayout) {
            return;
        }
        this.x = x;
    }

    public void setY(int y) {
        if (((DynamicBuilder)this.builder).forceRelativeY && ((DynamicBuilder)this.builder).isProcessingLayout) {
            return;
        }
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getEndX() {
        return this.x + this.width;
    }

    public int getEndY() {
        return this.y + this.height;
    }

    public int getRelativeX() {
        if (((DynamicBuilder)this.builder).relativeLayout != null) {
            return this.x - ((DynamicBuilder)this.builder).getRelativeLayoutX();
        }
        return this.x;
    }

    public int getRelativeY() {
        if (((DynamicBuilder)this.builder).relativeLayout != null) {
            return this.y - ((DynamicBuilder)this.builder).getRelativeLayoutY();
        }
        return this.y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getScaleWidth() {
        return ((DynamicBuilder)this.builder).getScaleWidth(this.self());
    }

    public float getScaleHeight() {
        return ((DynamicBuilder)this.builder).getScaleHeight(this.self());
    }

    public float getSquareScale() {
        return (this.getScaleWidth() + this.getScaleHeight()) / 2.0f;
    }

    public void setActive(boolean state) {
        this.active = state;
    }

    public void setActive() {
        this.setActive(true);
    }

    public void setInactive() {
        this.setActive(false);
    }

    public boolean getActiveTest() {
        if (((DynamicBuilder)this.builder).active == null) {
            return this.active;
        }
        return ((DynamicBuilder)this.builder).active.test(this.self());
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInactive() {
        return !this.isActive();
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public void setVisible() {
        this.setVisible(true);
    }

    public void setInvisible() {
        this.setVisible(false);
    }

    public boolean getVisibleTest() {
        if (((DynamicBuilder)this.builder).visible == null) {
            return this.visible;
        }
        return ((DynamicBuilder)this.builder).visible.test(this.self());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isInvisible() {
        return !this.isVisible();
    }

    public boolean isAnchored() {
        DynamicWidget relativeWidget;
        RelativeLayout relativeLayout = ((DynamicBuilder)this.builder).relativeLayout;
        if (relativeLayout instanceof DynamicWidget && (relativeWidget = (DynamicWidget)((Object)relativeLayout)).isAnchored()) {
            return true;
        }
        return ((DynamicBuilder)this.builder).relativeAnchor;
    }

    public boolean isNotAnchored() {
        return !this.isAnchored();
    }

    public void tick() {
    }

    public RenderPass getRenderPass() {
        return this.renderPass;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean has(Object data) {
        return ((DynamicBuilder)this.builder).attachedData.contains(data);
    }

    public <T> Optional<T> maybeHas(@Nullable T data) {
        return ((DynamicBuilder)this.builder).attachedData.stream().filter(obj -> obj.equals(data)).findFirst();
    }

    public UniqueArrayList<Object> getAttachments() {
        return ((DynamicBuilder)this.builder).attachedData;
    }

    public <T> Stream<T> find(Class<T> data) {
        return CollectionUtil.fromCast(((DynamicBuilder)this.builder).attachedData, data);
    }

    protected boolean isDebugging() {
        return NostalgicTweaks.isDebugging();
    }

    protected boolean isNotDebugging() {
        return !this.isDebugging();
    }

    protected void renderDebug(GuiGraphics graphics) {
        if (this.isNotDebugging() || this.isInvisible()) {
            return;
        }
        RenderUtil.deferredRenderer(() -> {
            int startX = this.x;
            int startY = this.y;
            int endX = this.getEndX();
            int endY = this.getEndY();
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, 0.0, 1.0);
            RenderUtil.beginBatching();
            RenderUtil.fill(graphics, (float)startX, (float)startY, (float)endX, (float)(startY + 1), Color.RED.fromAlpha(0.4f));
            RenderUtil.fill(graphics, (float)(endX - 1), (float)(startY + 1), (float)endX, (float)(endY - 1), Color.PINK.fromAlpha(0.4f));
            RenderUtil.fill(graphics, (float)startX, (float)(startY + 1), (float)(startX + 1), (float)(endY - 1), Color.CYAN.fromAlpha(0.4f));
            RenderUtil.fill(graphics, (float)startX, (float)(endY - 1), (float)endX, (float)endY, Color.GREEN.fromAlpha(0.4f));
            RenderUtil.endBatching();
            graphics.pose().popPose();
        });
    }
}

