/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.dynamic;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.ToIntFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicField;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.util.common.data.CacheValue;
import mod.adrenix.nostalgic.util.common.function.ToFloatFunction;
import mod.adrenix.nostalgic.util.common.math.MathUtil;

interface DynamicLayout {

    public static interface Height {

        public static class ExtendToLargestEnd<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicHeight<Builder, Widget> {
            private final Collection<DynamicWidget<?, ?>> all;

            ExtendToLargestEnd(Collection<DynamicWidget<?, ?>> all) {
                this.all = all;
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setHeight(this.all.stream().mapToInt(DynamicWidget::getHeight).max().orElse(((DynamicWidget)widget).getHeight()));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return cache.height.isExpired() || this.all.stream().map(DynamicWidget::getCache).map(WidgetCache::getHeight).anyMatch(CacheValue::isExpired);
            }
        }

        public static class ExtendToWidgetEnd<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicHeight<Builder, Widget> {
            private final DynamicWidget<?, ?> extendTo;
            private final CacheValue<Integer> margin;

            ExtendToWidgetEnd(Builder builder, DynamicWidget<?, ?> extendTo, ToIntFunction<Widget> margin) {
                this.extendTo = extendTo;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setHeight(this.extendTo.getEndY() - ((DynamicWidget)widget).getY() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.y, cache.height, this.margin, this.extendTo.cache.getY(), this.extendTo.cache.getHeight());
            }
        }

        public static class ExtendToWidgetStart<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicHeight<Builder, Widget> {
            private final DynamicWidget<?, ?> extendTo;
            private final CacheValue<Integer> margin;

            ExtendToWidgetStart(Builder builder, DynamicWidget<?, ?> extendTo, ToIntFunction<Widget> margin) {
                this.extendTo = extendTo;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setHeight(this.extendTo.getY() - ((DynamicWidget)widget).getY() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.height, cache.y, this.margin, this.extendTo.cache.getY());
            }
        }

        public static class ExtendToScreen<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicHeight<Builder, Widget> {
            private final CacheValue<Integer> margin;

            ExtendToScreen(Builder builder, ToIntFunction<Widget> margin) {
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setHeight(((DynamicWidget)widget).getCache().screen.height.next() - ((DynamicWidget)widget).getY() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.y, cache.height, cache.screen.y, cache.screen.height, this.margin);
            }
        }

        public static class OfWidget<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicHeight<Builder, Widget> {
            private final DynamicWidget<?, ?> ofWidget;
            private final CacheValue<Float> ofAmount;

            OfWidget(Builder builder, DynamicWidget<?, ?> ofWidget, ToFloatFunction<Widget> ofAmount) {
                this.ofWidget = ofWidget;
                this.ofAmount = CacheValue.nullable(((DynamicBuilder)builder).widget, ofAmount::applyAsFloat, Float.valueOf(1.0f));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setHeight(Math.round((float)this.ofWidget.getHeight() * this.ofAmount.getAndUpdate().floatValue()));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.height, this.ofAmount, this.ofWidget.cache.getHeight());
            }
        }

        public static class OfScreen<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicHeight<Builder, Widget> {
            private final CacheValue<Float> ofScreen;

            OfScreen(Builder builder, ToFloatFunction<Widget> ofScreen) {
                this.ofScreen = CacheValue.nullable(((DynamicBuilder)builder).widget, ofScreen::applyAsFloat, Float.valueOf(1.0f));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                int screenY = ((DynamicWidget)widget).getCache().screen.y.next();
                int height = ((DynamicWidget)widget).getCache().screen.height.next() - screenY;
                ((DynamicWidget)widget).setHeight(Math.round(this.ofScreen.getAndUpdate().floatValue() * (float)height));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.height, cache.screen.height, this.ofScreen);
            }
        }

        public static abstract class DynamicHeight<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        implements DynamicLayout,
        DynamicFunction<Builder, Widget> {
            @Override
            public List<DynamicField> getManaging(Builder builder) {
                return List.of(DynamicField.HEIGHT);
            }
        }
    }

    public static interface Width {

        public static class ExtendToLargestEnd<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicWidth<Builder, Widget> {
            private final Collection<DynamicWidget<?, ?>> all;

            ExtendToLargestEnd(Collection<DynamicWidget<?, ?>> all) {
                this.all = all;
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setWidth(this.all.stream().mapToInt(DynamicWidget::getWidth).max().orElse(((DynamicWidget)widget).getWidth()));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return cache.width.isExpired() || this.all.stream().map(DynamicWidget::getCache).map(WidgetCache::getWidth).anyMatch(CacheValue::isExpired);
            }
        }

        public static class ExtendToWidgetEnd<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicWidth<Builder, Widget> {
            private final DynamicWidget<?, ?> extendTo;
            private final CacheValue<Integer> margin;

            ExtendToWidgetEnd(Builder builder, DynamicWidget<?, ?> extendTo, ToIntFunction<Widget> margin) {
                this.extendTo = extendTo;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setWidth(this.extendTo.getEndX() - ((DynamicWidget)widget).getX() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.width, this.margin, this.extendTo.cache.getX(), this.extendTo.cache.getWidth());
            }
        }

        public static class ExtendToWidgetStart<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicWidth<Builder, Widget> {
            private final DynamicWidget<?, ?> extendTo;
            private final CacheValue<Integer> margin;

            ExtendToWidgetStart(Builder builder, DynamicWidget<?, ?> extendTo, ToIntFunction<Widget> margin) {
                this.extendTo = extendTo;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setWidth(this.extendTo.getX() - ((DynamicWidget)widget).getX() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.width, this.margin, this.extendTo.cache.getX());
            }
        }

        public static class ExtendToScreen<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicWidth<Builder, Widget> {
            private final CacheValue<Integer> margin;

            ExtendToScreen(Builder builder, ToIntFunction<Widget> margin) {
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setWidth(((DynamicWidget)widget).getCache().screen.width.next() - ((DynamicWidget)widget).getX() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.width, cache.screen.x, cache.screen.width, this.margin);
            }
        }

        public static class OfWidget<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicWidth<Builder, Widget> {
            private final DynamicWidget<?, ?> ofWidget;
            private final CacheValue<Float> ofAmount;

            OfWidget(Builder builder, DynamicWidget<?, ?> ofWidget, ToFloatFunction<Widget> ofAmount) {
                this.ofWidget = ofWidget;
                this.ofAmount = CacheValue.nullable(((DynamicBuilder)builder).widget, ofAmount::applyAsFloat, Float.valueOf(1.0f));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setWidth(Math.round((float)this.ofWidget.getWidth() * this.ofAmount.getAndUpdate().floatValue()));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.width, this.ofAmount, this.ofWidget.cache.getWidth());
            }
        }

        public static class OfScreen<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicWidth<Builder, Widget> {
            private final CacheValue<Float> ofScreen;

            OfScreen(Builder builder, ToFloatFunction<Widget> ofScreen) {
                this.ofScreen = CacheValue.nullable(((DynamicBuilder)builder).widget, ofScreen::applyAsFloat, Float.valueOf(1.0f));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                int screenX = ((DynamicWidget)widget).getCache().screen.x.next();
                int width = ((DynamicWidget)widget).getCache().screen.width.next() - screenX;
                ((DynamicWidget)widget).setWidth(Math.round(this.ofScreen.getAndUpdate().floatValue() * (float)width));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.width, cache.screen.width, this.ofScreen);
            }
        }

        public static abstract class DynamicWidth<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        implements DynamicLayout,
        DynamicFunction<Builder, Widget> {
            @Override
            public List<DynamicField> getManaging(Builder builder) {
                return List.of(DynamicField.WIDTH);
            }
        }
    }

    public static interface XYPos {

        public static class RightOf<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicXY<Builder, Widget> {
            private final DynamicWidget<?, ?> rightOf;
            private final CacheValue<Integer> margin;

            RightOf(Builder builder, DynamicWidget<?, ?> rightOf, ToIntFunction<Widget> margin) {
                this.rightOf = rightOf;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setX(this.rightOf.getEndX() + this.margin.getAndUpdate());
                ((DynamicWidget)widget).setY(this.rightOf.getY());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.y, this.margin, this.rightOf.cache.getX(), this.rightOf.cache.getY(), this.rightOf.cache.getWidth());
            }
        }

        public static class LeftOf<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicXY<Builder, Widget> {
            private final DynamicWidget<?, ?> leftOf;
            private final CacheValue<Integer> margin;

            LeftOf(Builder builder, DynamicWidget<?, ?> leftOf, ToIntFunction<Widget> margin) {
                this.leftOf = leftOf;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setX(this.leftOf.getX() - this.margin.getAndUpdate() - ((DynamicWidget)widget).getWidth());
                ((DynamicWidget)widget).setY(this.leftOf.getY());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.y, cache.width, this.margin, this.leftOf.cache.getX(), this.leftOf.cache.getY());
            }
        }

        public static abstract class DynamicXY<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        implements DynamicLayout,
        DynamicFunction<Builder, Widget> {
            @Override
            public List<DynamicField> getManaging(Builder builder) {
                return List.of(DynamicField.X, DynamicField.Y);
            }
        }
    }

    public static interface YPos {

        public static class CenterInScreen<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicY<Builder, Widget> {
            private final CacheValue<Integer> extraHeight;

            CenterInScreen(Builder builder, ToIntFunction<Widget> extraHeight) {
                this.extraHeight = CacheValue.nullable(((DynamicBuilder)builder).widget, extraHeight::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                int screenY = ((DynamicWidget)widget).getCache().screen.y.next();
                int maxSize = ((DynamicWidget)widget).getCache().screen.height.next() - screenY;
                int size = ((DynamicWidget)widget).getHeight() + this.extraHeight.getAndUpdate();
                ((DynamicWidget)widget).setY(screenY + Math.round(MathUtil.center(size, maxSize)));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.y, cache.height, cache.screen.height, cache.screen.y, this.extraHeight);
            }
        }

        public static class CenterInWidget<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicY<Builder, Widget> {
            private final DynamicWidget<?, ?> centerIn;
            private final CacheValue<Integer> extraHeight;

            CenterInWidget(Builder builder, DynamicWidget<?, ?> centerIn, ToIntFunction<Widget> extraHeight) {
                this.centerIn = centerIn;
                this.extraHeight = CacheValue.nullable(((DynamicBuilder)builder).widget, extraHeight::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                int size = ((DynamicWidget)widget).getHeight() + this.extraHeight.getAndUpdate();
                int maxSize = this.centerIn.getHeight();
                ((DynamicWidget)widget).setY(Math.round(MathUtil.center(this.centerIn.getY(), size, maxSize)));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.y, cache.height, this.extraHeight, this.centerIn.cache.getHeight(), this.centerIn.cache.getY());
            }
        }

        public static class AlignVertical<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicY<Builder, Widget> {
            private final DynamicWidget<?, ?> verticalTo;
            private final CacheValue<Integer> offset;

            AlignVertical(Builder builder, DynamicWidget<?, ?> verticalTo, ToIntFunction<Widget> offset) {
                this.verticalTo = verticalTo;
                this.offset = CacheValue.nullable(((DynamicBuilder)builder).widget, offset::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setY(this.verticalTo.getY() + this.offset.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.y, this.offset, this.verticalTo.cache.getY());
            }
        }

        public static class FromWidgetEnd<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicY<Builder, Widget> {
            private final DynamicWidget<?, ?> fromEnd;
            private final CacheValue<Integer> margin;

            FromWidgetEnd(Builder builder, DynamicWidget<?, ?> fromEnd, ToIntFunction<Widget> margin) {
                this.fromEnd = fromEnd;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setY(this.fromEnd.getEndY() - ((DynamicWidget)widget).getHeight() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.y, cache.height, this.margin, this.fromEnd.cache.getY(), this.fromEnd.cache.getHeight());
            }
        }

        public static class FromScreenEnd<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicY<Builder, Widget> {
            private final CacheValue<Integer> margin;

            FromScreenEnd(Builder builder, ToIntFunction<Widget> margin) {
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setY(((DynamicWidget)widget).getCache().screen.height.next() - ((DynamicWidget)widget).getHeight() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.screen.height, cache.y, cache.height, this.margin);
            }
        }

        public static class BelowAll<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicY<Builder, Widget> {
            private final LinkedHashSet<DynamicWidget<?, ?>> all;
            private final CacheValue<Integer> margin;

            BelowAll(Builder builder, LinkedHashSet<DynamicWidget<?, ?>> all, ToIntFunction<Widget> margin) {
                this.all = all;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                if (this.all.isEmpty()) {
                    return;
                }
                DynamicWidget.syncWithoutCache(this.all);
                int maxEndY = this.all.stream().filter(DynamicWidget::isVisible).mapToInt(DynamicWidget::getEndY).max().orElse(0);
                ((DynamicWidget)widget).setY(this.margin.getAndUpdate() + maxEndY);
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                if (this.all.isEmpty()) {
                    return false;
                }
                return CacheValue.isAnyExpired(cache.y, this.margin) || this.all.stream().anyMatch(dynamic -> CacheValue.isAnyExpired(dynamic.cache.y, dynamic.cache.height, dynamic.cache.visible));
            }
        }

        public static class Below<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicY<Builder, Widget> {
            private final DynamicWidget<?, ?> below;
            private final CacheValue<Integer> margin;

            Below(Builder builder, DynamicWidget<?, ?> below, ToIntFunction<Widget> margin) {
                this.below = below;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setY(this.below.getEndY() + this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.y, this.margin, this.below.cache.getY(), this.below.cache.getHeight());
            }
        }

        public static class Above<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicY<Builder, Widget> {
            private final DynamicWidget<?, ?> above;
            private final CacheValue<Integer> margin;

            Above(Builder builder, DynamicWidget<?, ?> above, ToIntFunction<Widget> margin) {
                this.above = above;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setY(this.above.getY() - this.margin.getAndUpdate() - ((DynamicWidget)widget).getHeight());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.y, cache.height, this.margin, this.above.cache.getY());
            }
        }

        public static abstract class DynamicY<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        implements DynamicLayout,
        DynamicFunction<Builder, Widget> {
            @Override
            public List<DynamicField> getManaging(Builder builder) {
                return List.of(DynamicField.Y);
            }
        }
    }

    public static interface XPos {

        public static class CenterInScreen<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicX<Builder, Widget> {
            private final CacheValue<Integer> extraWidth;

            CenterInScreen(Builder builder, ToIntFunction<Widget> extraWidth) {
                this.extraWidth = CacheValue.nullable(((DynamicBuilder)builder).widget, extraWidth::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                int screenX = ((DynamicWidget)widget).getCache().screen.x.next();
                int maxSize = ((DynamicWidget)widget).getCache().screen.width.next() - screenX;
                int size = ((DynamicWidget)widget).getWidth() + this.extraWidth.getAndUpdate();
                ((DynamicWidget)widget).setX(screenX + Math.round(MathUtil.center(size, maxSize)));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.width, cache.screen.x, cache.screen.width, this.extraWidth);
            }
        }

        public static class CenterInWidget<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicX<Builder, Widget> {
            private final DynamicWidget<?, ?> centerIn;
            private final CacheValue<Integer> extraWidth;

            CenterInWidget(Builder builder, DynamicWidget<?, ?> centerIn, ToIntFunction<Widget> extraWidth) {
                this.centerIn = centerIn;
                this.extraWidth = CacheValue.nullable(((DynamicBuilder)builder).widget, extraWidth::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                int size = ((DynamicWidget)widget).getWidth() + this.extraWidth.getAndUpdate();
                int maxSize = this.centerIn.getWidth();
                ((DynamicWidget)widget).setX(Math.round(MathUtil.center(this.centerIn.getX(), size, maxSize)));
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.width, this.extraWidth, this.centerIn.cache.getX(), this.centerIn.cache.getWidth());
            }
        }

        public static class AlignFlush<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicX<Builder, Widget> {
            private final DynamicWidget<?, ?> flushTo;
            private final CacheValue<Integer> offset;

            AlignFlush(Builder builder, DynamicWidget<?, ?> flushTo, ToIntFunction<Widget> offset) {
                this.flushTo = flushTo;
                this.offset = CacheValue.nullable(((DynamicBuilder)builder).widget, offset::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setX(this.flushTo.getX() + this.offset.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, this.offset, this.flushTo.cache.getX());
            }
        }

        public static class FromWidgetEnd<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicX<Builder, Widget> {
            private final DynamicWidget<?, ?> fromEnd;
            private final CacheValue<Integer> margin;

            FromWidgetEnd(Builder builder, DynamicWidget<?, ?> fromEnd, ToIntFunction<Widget> margin) {
                this.fromEnd = fromEnd;
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setX(this.fromEnd.getEndX() - ((DynamicWidget)widget).getWidth() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.width, this.margin, this.fromEnd.cache.getX(), this.fromEnd.cache.getWidth());
            }
        }

        public static class FromScreenEnd<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        extends DynamicX<Builder, Widget> {
            private final CacheValue<Integer> margin;

            FromScreenEnd(Builder builder, ToIntFunction<Widget> margin) {
                this.margin = CacheValue.nullable(((DynamicBuilder)builder).widget, margin::applyAsInt, Integer.valueOf(0));
            }

            @Override
            public void apply(Widget widget, Builder builder) {
                ((DynamicWidget)widget).setX(((DynamicWidget)widget).getScreenWidth() - ((DynamicWidget)widget).getWidth() - this.margin.getAndUpdate());
            }

            @Override
            public boolean isReapplyNeeded(Widget widget, Builder builder, WidgetCache cache) {
                return CacheValue.isAnyExpired(cache.x, cache.width, cache.screen.width, this.margin);
            }
        }

        public static abstract class DynamicX<Builder extends DynamicBuilder<Builder, Widget>, Widget extends DynamicWidget<Builder, Widget>>
        implements DynamicLayout,
        DynamicFunction<Builder, Widget> {
            @Override
            public List<DynamicField> getManaging(Builder builder) {
                return List.of(DynamicField.X);
            }
        }
    }
}

