/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.button;

import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.ColorPicker;
import mod.adrenix.nostalgic.client.gui.overlay.types.item.ItemPicker;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonRenderer;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.BooleanConsumer;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public abstract class ButtonTemplate {
    public static ButtonBuilder colorPicker(Supplier<Color> color, Consumer<ColorPicker> onClose, boolean isOpaque) {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(Icons.COLOR_PICKER)).tooltip(Lang.Colorize.OPEN, 30, 500L, TimeUnit.MILLISECONDS)).onPress(() -> ColorPicker.create((Color)color.get(), onClose).opaque(isOpaque).open())).postRenderer((button, graphics, mouseX, mouseY, partialTick) -> {
            int iconX = button.getIconManager().get().getX();
            int iconY = button.getIconManager().get().getY();
            Color fill = (Color)color.get();
            RenderUtil.beginBatching();
            graphics.pose().pushPose();
            graphics.pose().translate((double)iconX, (double)iconY, 1.0);
            RenderUtil.fill(graphics, 1.0f, 10.0f, 2.0f, 11.0f, fill);
            RenderUtil.fill(graphics, 2.0f, 8.0f, 4.0f, 10.0f, fill);
            RenderUtil.fill(graphics, 3.0f, 7.0f, 6.0f, 8.0f, fill);
            RenderUtil.fill(graphics, 4.0f, 8.0f, 5.0f, 9.0f, fill);
            RenderUtil.fill(graphics, 4.0f, 6.0f, 7.0f, 7.0f, fill);
            graphics.pose().popPose();
            RenderUtil.endBatching();
        });
    }

    public static ButtonBuilder colorPicker(Color color, boolean isOpaque) {
        return ButtonTemplate.colorPicker(() -> color, picker -> {}, isOpaque);
    }

    public static ButtonBuilder itemPicker(Consumer<ItemStack> onItemAdd, Runnable onEmptyAdd, ItemRule ... rules) {
        return (ButtonBuilder)((ButtonBuilder)ButtonWidget.create().tooltip(Lang.Itemize.OPEN, 30, 500L, TimeUnit.MILLISECONDS)).onPress(() -> ItemPicker.create(onItemAdd, onEmptyAdd, rules).open());
    }

    public static ButtonBuilder itemPicker(Consumer<ItemStack> onItemAdd, ItemRule ... rules) {
        return (ButtonBuilder)((ButtonBuilder)ButtonWidget.create().tooltip(Lang.Itemize.OPEN, 30, 500L, TimeUnit.MILLISECONDS)).onPress(() -> ItemPicker.create(onItemAdd, rules).open());
    }

    public static ButtonBuilder checkbox(Component title, BooleanSupplier supplier) {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(title).icon(() -> supplier.getAsBoolean() ? Icons.CHECKBOX_SELECTED : Icons.CHECKBOX)).width(Icons.CHECKBOX.getWidth() + GuiUtil.font().width((FormattedText)title))).height(Icons.CHECKBOX.getHeight())).backgroundRenderer(ButtonRenderer.EMPTY).iconTextPadding(6)).padding(0)).alignLeft()).useTextWidth();
    }

    public static ButtonBuilder checkbox(Translation lang, BooleanSupplier supplier) {
        return ButtonTemplate.checkbox((Component)lang.get(new Object[0]), supplier);
    }

    public static ButtonBuilder toggle(BooleanSupplier getter, BooleanConsumer setter) {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().onPress(() -> setter.accept(!getter.getAsBoolean()))).icon(() -> getter.getAsBoolean() ? Icons.TOGGLE_ON : Icons.TOGGLE_OFF)).hoverIcon(() -> getter.getAsBoolean() ? Icons.TOGGLE_ON_HOVER : Icons.TOGGLE_OFF_HOVER)).disabledIcon(() -> getter.getAsBoolean() ? Icons.TOGGLE_ON_DISABLED : Icons.TOGGLE_OFF_DISABLED)).backgroundRenderer(ButtonRenderer.EMPTY).iconCenterOffset(4)).height(8)).width(12);
    }

    public static ButtonBuilder openFolder(Path path) {
        return (ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.OPEN_FOLDER).icon(Icons.FOLDER)).onPress(() -> Util.getPlatform().openFile(path.toFile()));
    }
}

