/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.button;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.button.AbstractButton;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonRenderer;
import mod.adrenix.nostalgic.client.gui.widget.button.Cooldown;
import mod.adrenix.nostalgic.client.gui.widget.button.LayoutListener;
import mod.adrenix.nostalgic.client.gui.widget.button.TitleListener;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.ActiveBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.IconBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.TooltipBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.VisibleBuilder;
import mod.adrenix.nostalgic.util.client.timer.ClientTimer;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.timer.TickTimer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractButtonMaker<Builder extends AbstractButtonMaker<Builder, Button>, Button extends AbstractButton<Builder, Button>>
extends DynamicBuilder<Builder, Button>
implements LayoutBuilder<Builder, Button>,
IconBuilder<Builder, Button>,
TooltipBuilder<Builder, Button>,
ActiveBuilder<Builder, Button>,
VisibleBuilder<Builder, Button> {
    protected final Component title;
    @Nullable
    protected Supplier<Component> titleSupplier = null;
    protected int offsetIcon = 0;
    protected int padding = -1;
    protected int iconTextPadding = -1;
    protected int iconCenterOffset = 0;
    protected int alignLeftOffset = 0;
    protected boolean useClickSound = true;
    protected boolean useTextWidth = false;
    protected boolean alignLeft = false;
    protected boolean shrunk = false;
    protected FlagHolder cooldownFlag = FlagHolder.off();
    @Nullable
    protected TickTimer holdTimer = null;
    @Nullable
    protected TickTimer cooldownTimer = null;
    protected boolean useTextColors;
    protected Color textColor = new Color(0xE0E0E0);
    protected Color hoverColor = new Color(0xFFFFA0);
    @Nullable
    protected Consumer<Button> onPress = null;
    @Nullable
    protected ButtonRenderer<Builder, Button> renderer = null;
    @Nullable
    protected ButtonRenderer<Builder, Button> postRenderer = null;
    @Nullable
    protected ButtonRenderer<Builder, Button> backgroundRenderer = null;

    protected AbstractButtonMaker(Component title) {
        this.title = title;
        this.brightenOnHover = true;
        this.addFunction(new Cooldown.Disable());
        this.addFunction(new Cooldown.Enable());
        this.addFunction(new LayoutListener());
        this.addFunction(new TitleListener());
    }

    public Builder title(Supplier<Component> supplier) {
        this.titleSupplier = supplier;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder color(Color textColor, Color hoverColor) {
        this.useTextColors = true;
        this.textColor = textColor;
        this.hoverColor = hoverColor;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder color(IntSupplier textColor, IntSupplier hoverColor) {
        return this.color(new Color(textColor), new Color(hoverColor));
    }

    public Builder color(int textColor, int hoverColor) {
        return this.color(new Color(textColor), new Color(hoverColor));
    }

    public Builder padding(int padding) {
        this.padding = padding;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder iconTextPadding(int padding) {
        this.iconTextPadding = padding;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder iconCenterOffset(int offset) {
        this.iconCenterOffset = offset;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder offsetIcon(int offset) {
        this.offsetIcon = offset;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder noClickSound() {
        this.useClickSound = false;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder useTextWidth() {
        this.useTextWidth = true;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder alignLeft() {
        this.alignLeft = true;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder alignLeft(int offset) {
        this.alignLeft = true;
        this.alignLeftOffset = offset;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder cooldown(long delay, TimeUnit timeUnit) {
        this.cooldownTimer = ClientTimer.getInstance().create(delay, timeUnit);
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder holdFor(long holdFor, TimeUnit timeUnit) {
        this.holdTimer = ClientTimer.getInstance().create(holdFor, timeUnit);
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder onPress(Consumer<Button> onPress) {
        this.onPress = onPress;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder onPress(Runnable onPress) {
        return this.onPress((Button widget) -> onPress.run());
    }

    public Builder renderer(ButtonRenderer<Builder, Button> renderer) {
        this.renderer = renderer;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder postRenderer(ButtonRenderer<Builder, Button> renderer) {
        this.postRenderer = renderer;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    public Builder backgroundRenderer(ButtonRenderer<Builder, Button> renderer) {
        this.backgroundRenderer = renderer;
        return (Builder)((AbstractButtonMaker)this.self());
    }

    protected void onPress(Button button) {
        if (this.holdTimer != null && this.holdTimer.isTicking()) {
            return;
        }
        if (this.onPress != null) {
            this.onPress.accept(button);
        }
        if (this.cooldownTimer != null) {
            this.cooldownFlag.enable();
            ClientTimer.getInstance().run(this.cooldownTimer, () -> this.cooldownFlag.disable());
        }
    }
}

