/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.button;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.widget.WidgetBackground;
import mod.adrenix.nostalgic.client.gui.widget.button.AbstractButtonMaker;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.IconManager;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.client.timer.ClientTimer;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.CacheValue;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.timer.SimpleTimer;
import mod.adrenix.nostalgic.util.common.timer.TickTimer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public abstract class AbstractButton<Builder extends AbstractButtonMaker<Builder, Button>, Button extends AbstractButton<Builder, Button>>
extends DynamicWidget<Builder, Button> {
    protected final SimpleTimer scrollTimer = SimpleTimer.create(1500L, TimeUnit.MILLISECONDS).waitFirst().build();
    protected final Animation scrollAnimator = Animate.linear();
    protected final CacheValue<Component> cacheTitle = CacheValue.create(this::getTitle);
    protected final IconManager<Button> iconManager = new IconManager<AbstractButton>((AbstractButton)this.self());
    protected final Consumer<Button> onPress;
    protected boolean scrollingText;
    protected boolean shrunk;
    protected boolean holding;
    protected int textX = 0;
    protected int textY = 0;
    protected int iconX = 0;
    protected int iconY = 0;

    protected AbstractButton(Builder builder, Consumer<Button> onPress) {
        super(builder);
        this.shrunk = ((AbstractButtonMaker)builder).shrunk;
        this.onPress = onPress;
    }

    public IconManager<Button> getIconManager() {
        return this.iconManager;
    }

    public Component getTitle() {
        if (this.shrunk) {
            return Component.empty();
        }
        if (((AbstractButtonMaker)this.builder).titleSupplier != null) {
            return ((AbstractButtonMaker)this.builder).titleSupplier.get();
        }
        return ((AbstractButtonMaker)this.builder).title;
    }

    protected int getTextColor() {
        int color;
        boolean isOldHover = (Boolean)CandyTweak.OLD_BUTTON_TEXT_COLOR.get();
        int n = this.active ? (isOldHover ? 0xE0E0E0 : 0xFFFFFF) : (color = 0xA0A0A0);
        if (this.isHoveredOrFocused() && this.active && isOldHover) {
            color = 0xFFFFA0;
        }
        if (((AbstractButtonMaker)this.builder).useTextColors && this.active) {
            color = this.isHoveredOrFocused() ? ((AbstractButtonMaker)this.builder).hoverColor.get() : ((AbstractButtonMaker)this.builder).textColor.get();
        }
        return color;
    }

    public int getTextX() {
        return this.textX;
    }

    public int getTextY() {
        return this.textY;
    }

    public int getIconX() {
        return this.iconX;
    }

    public int getIconY() {
        return this.iconY;
    }

    protected void setTextAndIconPos() {
        if (this.iconManager.isEmpty()) {
            this.textX = this.x + this.width / 2;
            this.textY = this.y + (this.height - 8) / 2;
            this.iconX = this.x + 4;
            this.iconY = this.y + 4;
        } else {
            IconWidget icon = this.iconManager.get();
            int iconWidth = icon.getWidth();
            int iconHeight = icon.getHeight();
            if (((AbstractButtonMaker)this.builder).padding < 0 && GuiUtil.font().width((FormattedText)this.getTitle()) > 0) {
                int n = ((AbstractButtonMaker)this.builder).padding = MathUtil.isOdd(iconWidth) ? 5 : 6;
            }
            if (((AbstractButtonMaker)this.builder).iconTextPadding < 0 && GuiUtil.font().width((FormattedText)this.getTitle()) > 0) {
                ((AbstractButtonMaker)this.builder).iconTextPadding = ((AbstractButtonMaker)this.builder).padding;
            }
            int padding = ((AbstractButtonMaker)this.builder).padding;
            int textOffset = ((AbstractButtonMaker)this.builder).useTextWidth ? -1 : 0;
            int iconTextPadding = ((AbstractButtonMaker)this.builder).iconTextPadding;
            if (this.shrunk) {
                padding = -1;
                textOffset = 0;
                iconTextPadding = -1;
            }
            int width = iconWidth + GuiUtil.font().width((FormattedText)this.getTitle()) + padding;
            int centerX = this.x + (((AbstractButtonMaker)this.builder).alignLeft ? ((AbstractButtonMaker)this.builder).alignLeftOffset : (int)MathUtil.center(width, this.width));
            this.textX = centerX + iconWidth + iconTextPadding + textOffset;
            this.textY = this.y + (this.height - 8) / 2;
            this.iconX = centerX + ((AbstractButtonMaker)this.builder).offsetIcon;
            this.iconY = (int)MathUtil.center(iconHeight, this.height) + this.y - ((AbstractButtonMaker)this.builder).iconCenterOffset;
        }
    }

    protected void setWidthFromText() {
        if (this.shrunk) {
            this.setWidth(20);
            return;
        }
        if (((AbstractButtonMaker)this.builder).useTextWidth) {
            IconWidget icon = this.iconManager.get();
            if (((AbstractButtonMaker)this.builder).padding < 0) {
                int n = ((AbstractButtonMaker)this.builder).padding = MathUtil.isOdd(icon.getWidth()) ? 5 : 6;
            }
            if (((AbstractButtonMaker)this.builder).iconTextPadding < 0) {
                ((AbstractButtonMaker)this.builder).iconTextPadding = ((AbstractButtonMaker)this.builder).padding;
            }
            int padding = ((AbstractButtonMaker)this.builder).iconTextPadding + ((AbstractButtonMaker)this.builder).padding * 2;
            this.setWidth(padding + icon.getWidth() + GuiUtil.font().width((FormattedText)this.getTitle()));
        }
    }

    public void shrink() {
        this.shrunk = true;
        this.setWidthFromText();
        ((AbstractButtonMaker)this.getBuilder()).sync();
    }

    public void grow() {
        this.shrunk = false;
        this.setWidthFromText();
        ((AbstractButtonMaker)this.getBuilder()).sync();
    }

    public boolean isScrollingText() {
        return this.scrollingText;
    }

    public void onPress() {
        if (this.holding) {
            return;
        }
        if (((AbstractButtonMaker)this.getBuilder()).holdTimer != null) {
            FlagHolder isFocused = new FlagHolder(this.isFocused());
            if (this.canFocus()) {
                this.setFocused();
            }
            this.holding = true;
            ClientTimer.getInstance().run(((AbstractButtonMaker)this.getBuilder()).holdTimer, () -> {
                this.holding = false;
                if (((AbstractButtonMaker)this.getBuilder()).useClickSound) {
                    GuiUtil.playClick();
                }
                if (this.isFocused() && !((Boolean)isFocused.get()).booleanValue()) {
                    this.setUnfocused();
                }
                this.onPress.accept((AbstractButton)this.self());
            });
            return;
        }
        if (((AbstractButtonMaker)this.getBuilder()).useClickSound) {
            GuiUtil.playClick();
        }
        this.onPress.accept((AbstractButton)this.self());
    }

    public void runIfPossible(boolean withSound) {
        if (this.isInactive() || this.isInvisible()) {
            return;
        }
        boolean useClickSound = ((AbstractButtonMaker)this.getBuilder()).useClickSound;
        ((AbstractButtonMaker)this.getBuilder()).useClickSound = withSound;
        this.onPress();
        ((AbstractButtonMaker)this.getBuilder()).useClickSound = useClickSound;
    }

    public void runIfPossible() {
        this.runIfPossible(((AbstractButtonMaker)this.getBuilder()).useClickSound);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInactive() || this.isInvisible()) {
            return false;
        }
        if (this.isValidClick(mouseX, mouseY, button)) {
            this.onPress();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean isValidClick = this.isValidClick(mouseX, mouseY, button);
        if (this.holding || this.isInactive() || this.isInvisible()) {
            this.holding = false;
            if (((AbstractButtonMaker)this.getBuilder()).holdTimer != null) {
                ClientTimer.getInstance().cancel(((AbstractButtonMaker)this.getBuilder()).holdTimer);
            }
            return isValidClick;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isInactive() || this.isInvisible() || this.isUnfocused()) {
            return false;
        }
        if (this.holding) {
            return true;
        }
        if (KeyboardUtil.isEnterLike(keyCode)) {
            this.onPress();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.holding || this.isInactive() || this.isInvisible() || this.isUnfocused()) {
            boolean wasHolding = this.holding;
            this.holding = false;
            if (((AbstractButtonMaker)this.getBuilder()).holdTimer != null) {
                ClientTimer.getInstance().cancel(((AbstractButtonMaker)this.getBuilder()).holdTimer);
            }
            return wasHolding;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    protected void renderTextAndIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.iconManager.pushCache();
        boolean isDefaultBackground = ((AbstractButtonMaker)this.builder).backgroundRenderer == null;
        int margin = isDefaultBackground ? 3 : 0;
        int endX = this.getEndX() - margin;
        int startX = this.iconManager.isEmpty() ? this.getX() + margin : this.textX;
        int textWidth = GuiUtil.font().width((FormattedText)this.getTitle()) + margin;
        boolean bl = this.scrollingText = startX + GuiUtil.font().width((FormattedText)this.getTitle()) > endX;
        if (((AbstractButtonMaker)this.builder).renderer != null) {
            this.scrollingText = false;
        }
        if (this.scrollingText) {
            startX = isDefaultBackground ? this.x + 2 + margin : this.iconX;
            endX -= isDefaultBackground ? 3 : 0;
            if (this.iconManager.isPresent()) {
                this.iconManager.get().pos(startX, this.iconY);
                startX += this.iconManager.get().getWidth() + ((AbstractButtonMaker)this.builder).iconTextPadding - 1;
            }
        }
        if (this.iconManager.isPresent()) {
            if (!this.scrollingText) {
                this.iconManager.get().pos(this.iconX, this.iconY);
            }
            this.iconManager.get().render(graphics, mouseX, mouseY, partialTick);
        }
        int extraWidth = Math.abs(startX + textWidth - endX - margin);
        if (this.scrollAnimator.isMoving()) {
            this.scrollTimer.reset();
        }
        if (this.scrollingText && this.scrollTimer.hasElapsed() && this.scrollAnimator.isFinished()) {
            this.scrollAnimator.setDuration(40L * (long)extraWidth, TimeUnit.MILLISECONDS);
            this.scrollAnimator.playOrRewind();
        }
        if (this.iconManager.isEmpty() && !this.scrollingText) {
            DrawText.begin(graphics, this.getTitle()).pos(this.textX, this.textY).color(this.getTextColor()).center().draw();
        } else if (this.scrollingText) {
            int scissorX = startX;
            int scissorEndX = endX;
            float scrollX = (float)Mth.lerp((double)this.scrollAnimator.getValue(), (double)startX, (double)(startX - extraWidth));
            RenderUtil.deferredRenderer(() -> {
                RenderUtil.pushScissor(scissorX, this.getY(), scissorEndX, this.getEndY());
                RenderUtil.pauseBatching();
                DrawText.begin(graphics, this.getTitle()).pos(scrollX, (float)this.textY).color(this.getTextColor()).draw();
                RenderUtil.popScissor();
                RenderUtil.resumeBatching();
            });
        } else {
            DrawText.begin(graphics, this.getTitle()).pos(startX, this.textY).color(this.getTextColor()).draw();
        }
        this.iconManager.render(graphics, mouseX, mouseY, partialTick);
        this.iconManager.popCache();
    }

    protected void renderTimerHighlight(GuiGraphics graphics) {
        boolean isHoldingOn;
        if (((AbstractButtonMaker)this.getBuilder()).cooldownTimer == null && ((AbstractButtonMaker)this.getBuilder()).holdTimer == null) {
            return;
        }
        NullableHolder timer = NullableHolder.empty();
        boolean isCooldownOn = ((AbstractButtonMaker)this.getBuilder()).cooldownTimer != null && ((AbstractButtonMaker)this.getBuilder()).cooldownTimer.isTicking();
        boolean bl = isHoldingOn = ((AbstractButtonMaker)this.getBuilder()).holdTimer != null && ((AbstractButtonMaker)this.getBuilder()).holdTimer.isTicking();
        if (isHoldingOn) {
            timer.set(((AbstractButtonMaker)this.getBuilder()).holdTimer);
        }
        if (isCooldownOn && this.isInactive()) {
            timer.set(((AbstractButtonMaker)this.getBuilder()).cooldownTimer);
        }
        if (timer.isEmpty()) {
            return;
        }
        RenderUtil.deferredRenderer(() -> {
            float endX = (float)Mth.lerp((double)((TickTimer)timer.getOrThrow()).getProgress(), (double)this.getX(), (double)((float)this.getEndX() - 1.0f));
            RenderUtil.fill(graphics, (float)this.getX(), (float)this.getY(), endX, (float)this.getEndY(), Color.WHITE.fromAlpha(0.2f));
        });
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        if (((AbstractButtonMaker)this.builder).renderer != null) {
            ((AbstractButtonMaker)this.builder).renderer.accept((AbstractButton)this.self(), graphics, mouseX, mouseY, partialTick);
            if (((AbstractButtonMaker)this.builder).postRenderer != null) {
                ((AbstractButtonMaker)this.builder).postRenderer.accept((AbstractButton)this.self(), graphics, mouseX, mouseY, partialTick);
            }
            this.renderDebug(graphics);
            return;
        }
        if (((AbstractButtonMaker)this.builder).backgroundRenderer != null) {
            ((AbstractButtonMaker)this.builder).backgroundRenderer.accept((AbstractButton)this.self(), graphics, mouseX, mouseY, partialTick);
        } else {
            WidgetBackground.BUTTON.render(this, graphics);
        }
        this.renderTimerHighlight(graphics);
        this.renderTextAndIcon(graphics, mouseX, mouseY, partialTick);
        if (((AbstractButtonMaker)this.builder).postRenderer != null) {
            ((AbstractButtonMaker)this.builder).postRenderer.accept((AbstractButton)this.self(), graphics, mouseX, mouseY, partialTick);
        }
        this.renderDebug(graphics);
    }
}

