/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget;

import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.client.renderer.TextureLayer;
import mod.adrenix.nostalgic.util.common.asset.GameSprite;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.resources.ResourceLocation;

public record WidgetBackground(ResourceLocation background, ResourceLocation highlighted, ResourceLocation disabled) {
    public static final TextureLayer LAYER = TextureLayer.withIndex(1);
    public static final WidgetBackground BUTTON = new WidgetBackground(GameSprite.BUTTON, GameSprite.BUTTON_HIGHLIGHTED, GameSprite.BUTTON_DISABLED);
    public static final WidgetBackground SLIDER = new WidgetBackground(GameSprite.SLIDER, GameSprite.SLIDER, GameSprite.SLIDER);

    public ResourceLocation get(boolean isActive, boolean isHoveredOrFocused) {
        if (isHoveredOrFocused && isActive) {
            return this.highlighted;
        }
        if (!isActive) {
            return this.disabled;
        }
        return this.background;
    }

    public ResourceLocation get(DynamicWidget<?, ?> widget) {
        return this.get(widget.isActive(), widget.isHoveredOrFocused());
    }

    public ResourceLocation get(AbstractWidget widget) {
        return this.get(widget.isActive(), widget.isHoveredOrFocused());
    }

    public void render(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        RenderUtil.beginBatching();
        RenderUtil.pushLayer(LAYER);
        RenderUtil.blitSprite(sprite, graphics, x, y, width, height);
        RenderUtil.endBatching();
        RenderUtil.popLayer();
    }

    public void render(DynamicWidget<?, ?> widget, GuiGraphics graphics) {
        this.render(graphics, this.get(widget), widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
    }

    public void render(AbstractWidget widget, GuiGraphics graphics) {
        this.render(graphics, this.get(widget), widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
    }
}

