/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.tooltip;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mod.adrenix.nostalgic.client.gui.tooltip.TooltipManager;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public abstract class Tooltip {
    private static int mouseX = -1;
    private static int mouseY = -1;
    private static boolean visible = true;
    @Nullable
    private static LayoutElement focused = null;
    @Nullable
    private static Component message = null;
    @Nullable
    private static List<Component> info = null;
    @Nullable
    private static List<Component> multiline = null;

    public static void setVisible(boolean state) {
        visible = state;
    }

    public static void setMousePosition(int mouseX, int mouseY) {
        Tooltip.mouseX = mouseX;
        Tooltip.mouseY = mouseY;
    }

    public static void setTooltip(Component tooltip) {
        multiline = null;
        message = tooltip;
    }

    public static void setListTooltip(List<Component> tooltip) {
        multiline = tooltip;
        message = null;
    }

    public static void setInfo(Component info) {
        Tooltip.info = List.of(info);
    }

    public static void setInfo(List<Component> info) {
        Tooltip.info = info;
    }

    public static void setRelativeToIfFocused(DynamicWidget<?, ?> widget) {
        focused = widget;
        if (widget.isFocused()) {
            mouseX = widget.getX() - 9;
            mouseY = widget.getY() - Tooltip.getHeight() - 1;
        }
    }

    public static int getHeight() {
        List<Component> tooltip = Tooltip.get();
        List<ClientTooltipComponent> clientTooltips = Lists.transform(tooltip, Component::getVisualOrderText).stream().map(ClientTooltipComponent::create).toList();
        return (tooltip.size() == 1 ? -2 : 0) - 8 + clientTooltips.stream().mapToInt(ClientTooltipComponent::getHeight).sum();
    }

    public static List<Component> get() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (message != null) {
            tooltip.add(message);
        } else if (multiline != null) {
            tooltip.addAll(multiline);
        }
        if (tooltip.size() > 1) {
            tooltip.add((Component)Component.empty());
        }
        tooltip.add((Component)Lang.Tooltip.HIDE.withStyle(ChatFormatting.GRAY));
        if (info != null) {
            if (Screen.hasShiftDown()) {
                tooltip.removeLast();
                tooltip.addAll(info);
            } else {
                tooltip.add((Component)Lang.Tooltip.SHIFT.withStyle(ChatFormatting.GRAY));
            }
        }
        return tooltip;
    }

    public static void render(Screen screen, GuiGraphics graphics) {
        if (!visible) {
            return;
        }
        boolean isNotManager = ClassUtil.isNotInstanceOf(screen, TooltipManager.class);
        if (Screen.hasControlDown() || isNotManager) {
            if (isNotManager) {
                focused = null;
            }
            return;
        }
        TooltipManager manager = (TooltipManager)screen;
        manager.setTooltipUsingMouse();
        if (message == null && multiline == null) {
            manager.setTooltipUsingFocused();
        }
        manager.resetTooltipTimers();
        if (message == null && multiline == null) {
            focused = null;
            return;
        }
        List tooltips = Tooltip.get().stream().map(Component::getVisualOrderText).collect(Collectors.toCollection(ArrayList::new));
        ClientTooltipPositioner position = (screenWidth, screenHeight, mouseX, mouseY, tooltipWidth, tooltipHeight) -> {
            Vector2i pos = new Vector2i(mouseX, mouseY).add(12, -12);
            if (focused != null) {
                pos.x = focused.getX() + 3;
                pos.y = focused.getY() + focused.getHeight() + 5;
                if (pos.x + tooltipWidth + 5 > screenWidth) {
                    pos.x = focused.getX() + focused.getWidth() - tooltipWidth - 4;
                }
                if (pos.y + tooltipHeight + 5 > screenHeight) {
                    pos.y = focused.getY() - tooltipHeight - 5;
                }
            }
            if (pos.x + tooltipWidth + 5 > screenWidth) {
                pos.x = screenWidth - tooltipWidth - 5;
            }
            if (pos.y + tooltipHeight + 5 > screenHeight) {
                pos.y = screenHeight - tooltipHeight - 5;
            }
            pos.x = Math.max(5, pos.x);
            pos.y = Math.max(5, pos.y);
            return pos;
        };
        graphics.renderTooltip(GuiUtil.font(), tooltips, position, Tooltip.mouseX, Tooltip.mouseY);
        focused = null;
        multiline = null;
        info = null;
        message = null;
    }
}

