/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.toast;

import com.mojang.math.Axis;
import java.util.List;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.GearSpinner;
import mod.adrenix.nostalgic.client.gui.toast.ToastId;
import mod.adrenix.nostalgic.network.ModConnection;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.asset.ModSprite;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.timer.SimpleTimer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class ModToast
implements Toast {
    private static final ModToast WELCOME = new ModToast(ToastId.WELCOME);
    private static final ModToast HANDSHAKE = new ModToast(ToastId.HANDSHAKE);
    private static final ModToast LAN_CHANGE = new ModToast(ToastId.LAN_CHANGE);
    private static final ModToast LAN_REJECTION = new ModToast(ToastId.LAN_REJECTION);
    private static final ModToast SERVERBOUND = new ModToast(ToastId.SERVERBOUND_TWEAK);
    private static final ModToast CLIENTBOUND = new ModToast(ToastId.CLIENTBOUND_TWEAK);
    private SimpleTimer timer = null;
    private final ToastId id;
    private Component title;
    private List<FormattedCharSequence> lines;
    private boolean isVisible = false;
    private int width;

    public static ModToast getInstance(ToastId id) {
        return switch (id) {
            default -> throw new MatchException(null, null);
            case ToastId.WELCOME -> WELCOME;
            case ToastId.HANDSHAKE -> HANDSHAKE;
            case ToastId.LAN_CHANGE -> LAN_CHANGE;
            case ToastId.LAN_REJECTION -> LAN_REJECTION;
            case ToastId.SERVERBOUND_TWEAK -> SERVERBOUND;
            case ToastId.CLIENTBOUND_TWEAK -> CLIENTBOUND;
        };
    }

    public static void update(Screen screen) {
        if (WELCOME.isClosed() && screen instanceof TitleScreen && !((Boolean)ModTweak.OPENED_CONFIG_SCREEN.get()).booleanValue()) {
            WELCOME.open();
        }
        if (WELCOME.isOpened() && ClassUtil.isNotInstanceOf(screen, TitleScreen.class)) {
            WELCOME.close();
        }
    }

    private ModToast(ToastId id) {
        this.id = id;
    }

    private void setText() {
        this.title = switch (this.id) {
            default -> throw new MatchException(null, null);
            case ToastId.WELCOME -> Lang.Toast.WELCOME_TITLE.get(new Object[0]);
            case ToastId.HANDSHAKE -> Lang.Toast.HANDSHAKE_TITLE.get(new Object[0]);
            case ToastId.LAN_CHANGE -> Lang.Toast.LAN_CHANGE_TITLE.get(new Object[0]);
            case ToastId.LAN_REJECTION -> Lang.Toast.LAN_REJECTED_TITLE.get(new Object[0]);
            case ToastId.SERVERBOUND_TWEAK -> Lang.Toast.SERVERBOUND_TWEAK_TITLE.get(new Object[0]);
            case ToastId.CLIENTBOUND_TWEAK -> Lang.Toast.CLIENTBOUND_TWEAK_TITLE.get(new Object[0]);
        };
        Component message = this.getMessage(NostalgicTweaks.getConnection().orElseGet(ModConnection::disconnected));
        this.lines = GuiUtil.font().split((FormattedText)message, 182);
        this.width = 24 + this.lines.stream().mapToInt(arg_0 -> ((Font)GuiUtil.font()).width(arg_0)).max().orElse(182);
        if (this.lines.size() == 1) {
            int titleWidth = 42 + GuiUtil.font().width((FormattedText)this.title);
            int messageWidth = 24 + GuiUtil.font().width(this.lines.getFirst());
            this.width = Math.max(titleWidth, messageWidth);
        }
    }

    private Component getMessage(ModConnection connection) {
        String client = String.valueOf(ChatFormatting.GOLD) + NostalgicTweaks.getTinyVersion();
        String server = String.valueOf(ChatFormatting.GOLD) + connection.getVersion();
        String loader = String.valueOf(ChatFormatting.LIGHT_PURPLE) + connection.getLoader();
        return switch (this.id) {
            default -> throw new MatchException(null, null);
            case ToastId.WELCOME -> Lang.Toast.WELCOME_MESSAGE.get(client);
            case ToastId.HANDSHAKE -> Lang.Toast.HANDSHAKE_MESSAGE.get(server, loader);
            case ToastId.LAN_CHANGE -> Lang.Toast.LAN_CHANGE_MESSAGE.get(new Object[0]);
            case ToastId.LAN_REJECTION -> Lang.Toast.LAN_REJECTED_MESSAGE.get(new Object[0]);
            case ToastId.SERVERBOUND_TWEAK -> Lang.Toast.SERVERBOUND_TWEAK_MESSAGE.get(new Object[0]);
            case ToastId.CLIENTBOUND_TWEAK -> Lang.Toast.CLIENTBOUND_TWEAK_MESSAGE.get(new Object[0]);
        };
    }

    private void setVisible(boolean visible) {
        this.isVisible = visible;
        this.setText();
    }

    public void open() {
        this.setVisible(true);
        Minecraft.getInstance().getToasts().addToast((Toast)this);
    }

    public void close() {
        this.setVisible(false);
    }

    public boolean isOpened() {
        return this.isVisible;
    }

    public boolean isClosed() {
        return !this.isOpened();
    }

    public ModToast setTimer(long time) {
        this.timer = SimpleTimer.create(time, TimeUnit.MILLISECONDS).waitFirst().build();
        return this;
    }

    public Object getToken() {
        return this.id;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return 25 + this.lines.size() * 12;
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent toast, long timeSinceLastVisible) {
        String splash = "N.T";
        float scale = 1.8f - Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        scale = scale * 4.0f / (float)GuiUtil.font().width(splash);
        RenderUtil.blitSprite(ModSprite.OVERLAY, graphics, 0, 0, this.width(), this.height());
        GearSpinner.getInstance().render(graphics, 0.0215f, 6, 3);
        RenderUtil.beginBatching();
        RenderUtil.fill(graphics, 8.0f, 15.0f, (float)(this.width() - 8), (float)(this.height() - 8), -1358954496);
        graphics.pose().pushPose();
        graphics.pose().translate(12.0f, 12.0f, 0.0f);
        graphics.pose().mulPose(Axis.ZP.rotationDegrees(-20.0f));
        graphics.pose().scale(scale, scale, scale);
        DrawText.begin(graphics, splash).pos(1, -6).color(Color.YELLOW).draw();
        graphics.pose().popPose();
        DrawText.begin(graphics, this.title).pos(21, 4).color(Color.YELLOW).draw();
        for (int i = 0; i < this.lines.size(); ++i) {
            DrawText.begin(graphics, this.lines.get(i)).pos(12, 18 + i * 12).draw();
        }
        RenderUtil.endBatching();
        if (this.timer != null && this.timer.hasElapsed()) {
            this.close();
        }
        return this.isVisible ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }
}

