/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select;

import java.time.Instant;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select.WorldRowMaker;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonRenderer;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.client.gui.widget.list.RowData;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.mixin.access.WorldListEntryAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelSummary;

class WorldRow
extends AbstractRow<WorldRowMaker, WorldRow> {
    private final Function<LevelSummary, Supplier<String>> getLevelSize;
    private final WorldSelectionList.WorldListEntry entry;
    private final NullableHolder<WorldRow> selected;
    private final FaviconTexture favicon;
    private final BlankWidget icon;
    private final LevelSummary summary;
    private long lastClickTime;

    WorldRow(WorldRowMaker builder) {
        super(builder);
        this.favicon = ((WorldListEntryAccess)builder.entry).nt$getIcon();
        this.selected = builder.selected;
        this.summary = builder.summary;
        this.entry = builder.entry;
        this.getLevelSize = builder.getLevelSize;
        boolean isIcon = (Boolean)CandyTweak.ADD_WORLD_THUMBNAIL.get();
        this.icon = ((BlankBuilder)((BlankBuilder)BlankWidget.create().pos(isIcon ? 3 : 4, 3)).size(isIcon ? 32 : 0)).renderer(this::renderIcon).build(this::addWidget);
        this.init();
        ((WorldRowMaker)this.getBuilder()).preRenderer(this::renderBox);
    }

    private void init() {
        boolean isMetadata = (Boolean)CandyTweak.ADD_WORLD_METADATA.get();
        boolean isIcon = (Boolean)CandyTweak.ADD_WORLD_THUMBNAIL.get();
        String name = this.summary.getLevelName();
        if (name.isEmpty()) {
            name = "World";
        }
        TextWidget header = ((TextBuilder)((TextBuilder)TextWidget.create(name).rightOf(this.icon, isIcon ? 3 : 0)).extendWidthToEnd(this, 4)).build(this::addWidget);
        Supplier<String> levelSize = this.getLevelSize.apply(this.summary);
        long lastPlayed = this.summary.getLastPlayed();
        String date = WorldSelectionList.DATE_FORMAT.format(Instant.ofEpochMilli(lastPlayed));
        String unknown = Lang.Worlds.BETA_UNKNOWN_LAST_PLAYED.getString(new Object[0]);
        String time = String.format("%s (%s, ", this.summary.getLevelId(), lastPlayed != -1L ? date : unknown);
        TextWidget data = ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(() -> Component.literal((String)(time + (String)levelSize.get() + ")"))).color(Color.GRAY).rightOf(this.icon, isIcon ? 3 : 0)).below(header, 2)).extendWidthToEnd(this, 4)).build(this::addWidget);
        if (Color.RED.matches(this.summary.getInfo().getStyle()) || isMetadata) {
            ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(this.summary.getInfo()).color(isMetadata ? Color.GRAY : Color.RED).rightOf(this.icon, isIcon ? 3 : 0)).below(data, 2)).extendWidthToEnd(this, 4)).build(this::addWidget);
        }
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().noClickSound()).attach(new Object[]{RowData.WIDGET_SYNCED_WITH_HEIGHT})).backgroundRenderer(ButtonRenderer.EMPTY).whenFocused(() -> this.selected.set(this))).onPress(this::onPress)).pos(this::getX, this::getY)).size(this::getWidth, this::getHeight)).build(this::addWidget);
    }

    public WorldSelectionList.WorldListEntry getEntry() {
        return this.entry;
    }

    public boolean isPrimaryActionActive() {
        return this.summary.primaryActionActive();
    }

    public boolean canEdit() {
        return this.summary.canEdit();
    }

    public boolean canDelete() {
        return this.summary.canDelete();
    }

    private void onPress() {
        this.selected.set(this);
        if (Util.getMillis() - this.lastClickTime >= 250L) {
            this.lastClickTime = Util.getMillis();
        } else {
            this.entry.joinWorld();
        }
    }

    private void renderIcon(BlankWidget widget, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (((Boolean)CandyTweak.ADD_WORLD_THUMBNAIL.get()).booleanValue()) {
            RenderUtil.deferredRenderer(() -> graphics.blit(this.favicon.textureLocation(), widget.getX(), widget.getY(), 0.0f, 0.0f, 32, 32, 32, 32));
        }
    }

    private void renderBox(WorldRow row, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!row.equals(this.selected.get())) {
            return;
        }
        Color background = Color.BLACK;
        Color outline = Color.GRAY;
        RenderUtil.beginBatching();
        RenderUtil.fill(graphics, (float)this.getX(), (float)this.getY(), (float)this.getEndX(), (float)this.getEndY(), background);
        RenderUtil.outline(graphics, (float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), outline);
        RenderUtil.endBatching();
    }
}

