/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor;

import java.util.ArrayList;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.screen.EnhancedScreen;
import mod.adrenix.nostalgic.client.gui.screen.home.Panorama;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.FallingBlockRenderer;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockConfig;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockData;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.CanvasTools;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.EditorHistory;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.EditorOverlay;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.EditorWidgets;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.ToolDrawer;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.Rectangle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class FallingBlockEditorScreen
extends EnhancedScreen<FallingBlockEditorScreen, EditorWidgets> {
    private FallingBlockData initial;
    private FallingBlockData managed;
    private EditorWidgets editorWidgets;
    private FallingBlockRenderer blockLogo;
    private boolean hasErrorOccurred = false;
    private boolean areBlocksChanged = false;
    private boolean isInitialAnimationFinished = false;
    private final EditorHistory history = new EditorHistory(this);

    public FallingBlockEditorScreen(Screen parentScreen) {
        super(EditorWidgets::new, parentScreen, (Component)Lang.EMPTY.get(new Object[0]));
        this.reloadFromDisk();
        CanvasTools.reset();
        ToolDrawer.reset();
    }

    @Override
    public void tick() {
        if (this.hasErrorOccurred) {
            this.hasErrorOccurred = false;
            EditorOverlay.couldNotReadConfig(this::reloadFromDisk, true);
        }
        if (this.blockLogo.isFinished() && !this.isInitialAnimationFinished) {
            this.isInitialAnimationFinished = true;
        }
        this.areBlocksChanged = FallingBlockConfig.isDataChanged(this.initial, this.managed);
        super.tick();
    }

    @Override
    public FallingBlockEditorScreen self() {
        return this;
    }

    @Override
    public EditorWidgets getWidgetManager() {
        return this.editorWidgets;
    }

    @Override
    public void setWidgetManager(EditorWidgets editorWidgets) {
        this.editorWidgets = editorWidgets;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.editorWidgets.keyPressed(keyCode) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft.level == null) {
            Panorama.render(graphics);
        }
        RenderUtil.fill(graphics, 0.0f, 0.0f, (float)this.width, (float)this.height, Color.BLACK.fromAlpha(0.85));
        SeparatorWidget separatorTop = this.editorWidgets.getTopOfEditor();
        SeparatorWidget separatorBottom = this.editorWidgets.getBottomOfEditor();
        Rectangle topOfEditor = new Rectangle(0, 0, this.width, separatorTop.getY());
        Rectangle bottomOfEditor = new Rectangle(0, separatorBottom.getY(), this.width, this.height);
        RenderUtil.pushScissor(topOfEditor);
        GuiUtil.renderDirtBackground(graphics);
        this.blockLogo.render(1.8f);
        RenderUtil.popScissor();
        RenderUtil.pushScissor(bottomOfEditor);
        GuiUtil.renderDirtBackground(graphics);
        RenderUtil.popScissor();
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public EditorHistory getHistory() {
        return this.history;
    }

    public void setManagedData(FallingBlockData data) {
        this.managed = data.copy();
    }

    public FallingBlockData getManagedData() {
        return this.managed;
    }

    public ArrayList<FallingBlockData.Block> getManagedBlocks() {
        return this.managed.blocks;
    }

    public void replayAnimation(boolean immediate) {
        if (!this.isInitialAnimationFinished) {
            return;
        }
        this.blockLogo = new FallingBlockRenderer(this.managed, immediate);
    }

    public void replayAnimation() {
        this.replayAnimation(false);
    }

    public void reloadFromDisk() {
        boolean bl = this.hasErrorOccurred = !FallingBlockConfig.read();
        if (FallingBlockConfig.isNotAvailable()) {
            NostalgicTweaks.LOGGER.error("[Falling Blocks] The config isn't ready, this shouldn't happen!");
            this.blockLogo = new FallingBlockRenderer(new FallingBlockData());
        } else {
            if (FallingBlockConfig.hasNoBlocks()) {
                FallingBlockConfig.setBlockDataToDefault();
                FallingBlockConfig.save();
            }
            this.initial = FallingBlockConfig.getData();
            this.managed = this.initial.copy();
            this.blockLogo = new FallingBlockRenderer(this.managed);
            this.history.setFirstPointOnTimeline(this.initial);
        }
    }

    public boolean hasChanges() {
        return this.areBlocksChanged;
    }

    public void save() {
        if (FallingBlockConfig.INSTANCE.isEmpty()) {
            NostalgicTweaks.LOGGER.warn("[Falling Blocks] Could not save config file due to empty block data!");
            return;
        }
        FallingBlockConfig.apply(this.managed);
        FallingBlockConfig.save();
        this.initial = FallingBlockConfig.INSTANCE.orElse(null);
        this.managed = this.initial.copy();
    }

    @Override
    public void onClose() {
        if (!this.hasChanges()) {
            super.onClose();
            return;
        }
        EditorOverlay.areYouSure(this);
    }
}

