/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.ColorPicker;
import mod.adrenix.nostalgic.client.gui.overlay.types.item.ItemPicker;
import mod.adrenix.nostalgic.client.gui.screen.WidgetManager;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockConfig;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockData;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.CanvasTools;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.EditorHistory;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.EditorOverlay;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.FallingBlockEditorScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.ToolDrawer;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.embed.Embed;
import mod.adrenix.nostalgic.client.gui.widget.embed.EmbedBuilder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.slider.SliderBuilder;
import mod.adrenix.nostalgic.client.gui.widget.slider.SliderWidget;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.util.client.dialog.DialogType;
import mod.adrenix.nostalgic.util.client.dialog.FileDialog;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.math.Rectangle;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;

public class EditorWidgets
implements WidgetManager {
    private final FallingBlockEditorScreen editorScreen;
    private final Supplier<ArrayList<FallingBlockData.Block>> blocks;
    private final Supplier<FallingBlockData> data;
    private final NullableHolder<Float> scaling;
    private final ArrayList<Pixel> pixels;
    private final ArrayList<Pixel> moving;
    private final EditorHistory history;
    private final Color shadow;
    private final FlagHolder sound;
    private Item block;
    private Embed canvas;
    private Grid canvasTools;
    private Grid batchEditing;
    private Grid pixelSettings;
    private SeparatorWidget topOfEditor;
    private SeparatorWidget bottomOfEditor;
    private SliderWidget scaleSlider;
    private ButtonWidget colorPicker;
    private ButtonWidget blockPicker;
    private ButtonWidget soundToggle;
    private ButtonWidget clearCanvas;
    private ButtonWidget applySelection;
    private ButtonWidget filterSelection;
    private ButtonWidget helpManual;
    private boolean isMouseClickedOnCanvas;

    EditorWidgets(FallingBlockEditorScreen editorScreen) {
        this.editorScreen = editorScreen;
        this.data = editorScreen::getManagedData;
        this.blocks = editorScreen::getManagedBlocks;
        this.history = editorScreen.getHistory();
        this.shadow = new Color(Color.BLACK);
        this.pixels = new ArrayList();
        this.moving = new ArrayList();
        this.sound = FlagHolder.off();
        this.block = Blocks.STONE.asItem();
        this.scaling = NullableHolder.empty();
        ToolDrawer.reset();
    }

    public SeparatorWidget getTopOfEditor() {
        return this.topOfEditor;
    }

    public SeparatorWidget getBottomOfEditor() {
        return this.bottomOfEditor;
    }

    public Embed getCanvas() {
        return this.canvas;
    }

    public ArrayList<Pixel> getPixels() {
        return this.pixels;
    }

    @Override
    public void init() {
        IntegerHolder tabOrder = IntegerHolder.create(1);
        BlankWidget topZone = ((BlankBuilder)((BlankBuilder)BlankWidget.create().heightOfScreen(0.3f)).extendWidthToScreenEnd(0)).build(this.editorScreen::addWidget);
        this.topOfEditor = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.SILVER_CHALICE).height(1)).extendWidthToScreenEnd(0)).below(topZone, 3)).build(this.editorScreen::addWidget);
        ((BlankBuilder)((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().attach(Direction.NORTH)).height(4)).extendWidthToScreenEnd(0)).above(this.topOfEditor, 0)).renderer(this::borderShadow).build(this.editorScreen::addWidget);
        Embed player = ((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)Embed.create().tabOrderGroup(tabOrder.getAndIncrement())).padding(1)).posX(5)).resizeForWidgets().above(this.topOfEditor, -1)).borderColor(Color.TRANSPARENT).backgroundColor(Color.OLIVE_BLACK).borderRenderer(this::aboveEmbedController).build(this.editorScreen::addWidget);
        ((IconFactory)((IconFactory)((IconFactory)IconTemplate.button(Icons.SMALL_PLAY, Icons.SMALL_PLAY_HOVER, Icons.SMALL_PLAY_OFF).tooltip(Lang.Logo.PLAY, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.PLAY_TOOLTIP, 45)).skipFocusOnClick()).onPress(this.editorScreen::replayAnimation).build(player::addWidget);
        this.scaleSlider = ((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)SliderWidget.create(Float.valueOf(0.1f), Float.valueOf(2.0f), this::setScalingFactor, this::getScalingFactor).tabOrderGroup(tabOrder.getAndIncrement())).height(10)).interval(Float.valueOf(0.1f))).handleWidth(1)).fromScreenEndX(5)).widthOfScreen(0.15f)).scrollWithoutFocus()).above(this.topOfEditor, -1)).backgroundRenderer(this::sliderBackground)).handleRenderer(this::sliderHandle)).onChange(this::onScaleChange)).build(this.editorScreen::addWidget);
        this.canvas = ((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)Embed.create().padding(0)).cannotFocus()).below(this.topOfEditor, 0)).backgroundColor(Color.TRANSPARENT).borderColor(Color.TRANSPARENT).height(this::getCanvasHeight)).mouseClicked(this::onCanvasMouseClicked).mouseDragged(this::onCanvasMouseDragged).mouseReleased(this::onCanvasMouseReleased).build(this.editorScreen::addWidget);
        if (640 < GuiUtil.getGuiWidth()) {
            ((EmbedBuilder)((EmbedBuilder)this.canvas.getBuilder()).centerInScreenX()).resizeWidthForWidgets();
        } else {
            ((EmbedBuilder)this.canvas.getBuilder()).extendWidthToScreenEnd(0);
        }
        SeparatorWidget bottomOfPixels = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.SILVER_CHALICE).height(1)).extendWidthToScreenEnd(0)).below(this.canvas, 0)).build(this.editorScreen::addWidget);
        this.canvasTools = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.editorScreen, Grid::size).centerInScreenX()).extendWidthToScreenEnd(0)).below(bottomOfPixels, 0)).columnSpacing(1).build(this.editorScreen::addWidget);
        tabOrder.increment();
        for (int i = 0; i < CanvasTools.values().length; ++i) {
            CanvasTools mode = CanvasTools.values()[i];
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(mode.underline()).skipFocusOnClick()).attach(new Object[]{mode})).icon(mode.icon())).tabOrderGroup((Integer)tabOrder.get())).tooltip(mode.header(), 500L, TimeUnit.MILLISECONDS)).infoTooltip(mode.tooltip(), 45)).onPress(this::onSetEditorMode)).backgroundRenderer(this::editorToolsBackground)).build(this.canvasTools::addCell);
        }
        this.pixelSettings = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.editorScreen, Grid::size).centerInScreenX()).columnSpacing(1).extendWidthToScreenEnd(0)).below(this.canvasTools, 1)).build(this.editorScreen::addWidget);
        ItemPicker itemPicker = ItemPicker.create(itemStack -> {
            this.block = itemStack.getItem();
        }, ItemRule.ONLY_BLOCKS).title(Lang.Logo.SELECT_BLOCK).build();
        this.blockPicker = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.BLOCK_UNDERLINE).icon(() -> TextureIcon.fromItem(this.block))).tooltip(Lang.Logo.BLOCK, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.BLOCK_TOOLTIP, 45)).skipFocusOnClick()).tabOrderGroup(tabOrder.getAndIncrement())).onPress(itemPicker::open)).backgroundRenderer(this::regularToolsBackground)).build(this.pixelSettings::addCell);
        this.soundToggle = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().infoTooltip(Lang.Logo.SOUND_TOOLTIP, 45)).skipFocusOnClick()).tabOrderGroup((Integer)tabOrder.get())).icon(this::getSoundIcon)).title(this::getSoundTitle)).tooltip(this::getSoundTooltip, 500L, TimeUnit.MILLISECONDS)).onPress(this.sound::toggle)).backgroundRenderer(this::regularToolsBackground)).build(this.pixelSettings::addCell);
        this.colorPicker = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.SHADOW).skipFocusOnClick()).tabOrderGroup((Integer)tabOrder.get())).icon(Icons.COLOR_WHEEL)).tooltip(Lang.Colorize.TITLE, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Colorize.OPEN, 45)).onPress(() -> ColorPicker.create(this.shadow).open())).backgroundRenderer(this::shadowToolBackground)).build(this.pixelSettings::addCell);
        this.batchEditing = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.editorScreen, Grid::size).centerInScreenX()).columnSpacing(1).extendWidthToScreenEnd(0)).below(this.pixelSettings, 1)).build(this.editorScreen::addWidget);
        this.filterSelection = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.FILTER_SELECTION_UNDERLINE).skipFocusOnClick()).tabOrderGroup(tabOrder.getAndIncrement())).icon(Icons.FILTER)).tooltip(Lang.Logo.FILTER_SELECTION, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.FILTER_SELECTION_TOOLTIP, 45)).onPress(this::findMatchedPixels)).backgroundRenderer(this::regularToolsBackground)).build(this.batchEditing::addCell);
        this.applySelection = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.APPLY_SELECTION_UNDERLINE).skipFocusOnClick()).tabOrderGroup((Integer)tabOrder.get())).icon(Icons.CLIPBOARD)).tooltip(Lang.Logo.APPLY_SELECTION, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.APPLY_SELECTION_TOOLTIP, 45)).holdFor(500L, TimeUnit.MILLISECONDS)).onPress(this::applySelectedPixels)).enableIf(this::isAnyPixelSelected)).backgroundRenderer(this::regularToolsBackground)).build(this.batchEditing::addCell);
        this.clearCanvas = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.CLEAR_CANVAS_UNDERLINE).skipFocusOnClick()).tabOrderGroup((Integer)tabOrder.get())).icon(Icons.TRASH_CAN)).tooltip(Lang.Logo.CLEAR_CANVAS, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.CLEAR_CANVAS_TOOLTIP, 45)).holdFor(1L, TimeUnit.SECONDS)).onPress(this::clear)).backgroundRenderer(this::regularToolsBackground)).build(this.batchEditing::addCell);
        this.helpManual = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.HELP_UNDERLINE).skipFocusOnClick()).tabOrderGroup((Integer)tabOrder.get())).icon(Icons.HELP)).hoverIcon(Icons.HELP_HOVER)).tooltip(Lang.Logo.HELP, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.HELP_TOOLTIP, 45)).onPress(EditorOverlay::howToUse)).backgroundRenderer(this::regularToolsBackground)).build(this.batchEditing::addCell);
        this.bottomOfEditor = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.SILVER_CHALICE).below(this.batchEditing, 0)).extendWidthToScreenEnd(0)).height(1)).build(this.editorScreen::addWidget);
        ((BlankBuilder)((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().attach(Direction.SOUTH)).height(4)).extendWidthToScreenEnd(0)).below(this.bottomOfEditor, 0)).renderer(this::borderShadow).build(this.editorScreen::addWidget);
        Embed drawer = ((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)Embed.create().padding(1)).posX(5)).resizeForWidgets().tabOrderGroup(tabOrder.getAndIncrement())).below(this.bottomOfEditor, -1)).borderColor(Color.TRANSPARENT).backgroundColor(Color.OLIVE_BLACK).invisibleIf(() -> this.canvas.getHeight() == 120)).borderRenderer(this::bottomEmbedController).build(this.editorScreen::addWidget);
        IconWidget moveUp = ((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.button(Icons.SMALL_UP_ARROW, Icons.SMALL_UP_ARROW_HOVER, Icons.SMALL_UP_ARROW_OFF).tooltip(Lang.Logo.UP, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.UP_TOOLTIP, 45)).skipFocusOnClick()).onPress(this::moveDrawerUp).disableIf(ToolDrawer::isClosed)).build(drawer::addWidget);
        ((IconFactory)((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.button(Icons.SMALL_DOWN_ARROW, Icons.SMALL_DOWN_ARROW_HOVER, Icons.SMALL_DOWN_ARROW_OFF).tooltip(Lang.Logo.DOWN, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.DOWN_TOOLTIP, 45)).skipFocusOnClick()).rightOf(moveUp, 1)).onPress(this::moveDrawerDown).disableIf(ToolDrawer::isOpen)).build(drawer::addWidget);
        Embed cache = ((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)Embed.create().padding(1)).fromScreenEndX(5)).resizeForWidgets().tabOrderGroup(tabOrder.getAndIncrement())).below(this.bottomOfEditor, -1)).borderColor(Color.TRANSPARENT).backgroundColor(Color.OLIVE_BLACK).borderRenderer(this::bottomEmbedController).build(this.editorScreen::addWidget);
        IconWidget undo = ((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.button(Icons.SMALL_UNDO, Icons.SMALL_UNDO_HOVER, Icons.SMALL_UNDO_OFF).tooltip(Lang.Logo.UNDO, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.UNDO_TOOLTIP, 45)).skipFocusOnClick()).disableIf(this.history::isNothingToUndo)).onPress(this::undoLastAction).build(cache::addWidget);
        ((IconFactory)((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.button(Icons.SMALL_REDO, Icons.SMALL_REDO_HOVER, Icons.SMALL_REDO_OFF).tooltip(Lang.Logo.REDO, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.REDO_TOOLTIP, 45)).skipFocusOnClick()).rightOf(undo, 1)).disableIf(this.history::isNothingToRedo)).onPress(this::redoLastAction).build(cache::addWidget);
        BlankWidget bottomZone = ((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().below(this.bottomOfEditor, 1)).extendWidthToScreenEnd(0)).extendHeightToScreenEnd(0)).build(this.editorScreen::addWidget);
        Grid fileTools = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.editorScreen, Grid::size).centerInScreenX()).widthOfScreen(0.75f)).columnSpacing(1).centerInWidgetY(bottomZone, 21)).build(this.editorScreen::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.openFolder(PathUtil.getLogoPath()).tooltip(Lang.Logo.OPEN_FOLDER, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Logo.OPEN_FOLDER_TOOLTIP, 45)).skipFocusOnClick()).tabOrderGroup(tabOrder.getAndIncrement())).build(fileTools::addCell);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.COPY_CANVAS).icon(Icons.COPY)).tabOrderGroup((Integer)tabOrder.get())).infoTooltip(Lang.Logo.COPY_CANVAS_TOOLTIP, 45)).tooltip(Lang.Logo.COPY_CANVAS, 500L, TimeUnit.MILLISECONDS)).skipFocusOnClick()).onPress(this::copyCanvasToFile)).build(fileTools::addCell);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.UPLOAD_CONFIG).icon(Icons.UP_ARROW)).tabOrderGroup((Integer)tabOrder.get())).infoTooltip(Lang.Logo.UPLOAD_CONFIG_TOOLTIP, 45)).tooltip(Lang.Logo.UPLOAD_CONFIG, 500L, TimeUnit.MILLISECONDS)).skipFocusOnClick()).onPress(this::uploadFileToCanvas)).build(fileTools::addCell);
        Grid bottomGrid = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.editorScreen, Grid::size).centerInScreenX()).widthOfScreen(0.6f)).columnSpacing(1).below(fileTools, 1)).build(this.editorScreen::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.SAVE).icon(Icons.SAVE_FLOPPY)).tabOrderGroup(tabOrder.getAndIncrement())).onPress(this.editorScreen::save)).enableIf(this.editorScreen::hasChanges)).build(bottomGrid::addCell);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().tabOrderGroup((Integer)tabOrder.get())).icon(this::getFinishIcon)).title(this::getFinishTitle)).onPress(this.editorScreen::onClose)).build(bottomGrid::addCell);
        this.populatePixelsForCanvas();
    }

    private void populatePixelsForCanvas() {
        ButtonWidget[][] pixels = new ButtonWidget[64][12];
        this.canvas.setResizerToPaused();
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 12; ++y) {
                Pixel pixel = new Pixel(x, y);
                pixels[x][y] = pixel.getButton();
                if (x == 0 && y > 0) {
                    ((ButtonBuilder)pixels[x][y].getBuilder()).below(pixels[x][y - 1], 0);
                } else if (x > 0) {
                    ((ButtonBuilder)pixels[x][y].getBuilder()).rightOf(pixels[x - 1][y], 0);
                }
                this.canvas.addWidget(pixels[x][y]);
                this.pixels.add(pixel);
            }
        }
        this.canvas.setResizerToResume();
    }

    @Override
    public void tick() {
        if (this.scaling.isEmpty() || this.scaleSlider.isDragging()) {
            return;
        }
        if (this.scaling.getOrThrow().equals(Float.valueOf(this.history.peekLastOrFirst().scale))) {
            this.scaling.clear();
        } else {
            this.data.get().setScale(this.history.peekLastOrFirst().scale);
            this.makeHistory();
            this.data.get().setScale(this.scaling.getOrThrow().floatValue());
            this.scaling.clear();
        }
    }

    private int getCanvasHeight(Embed embed) {
        boolean isFullSizeOutOfBounds;
        int fullSize = 120;
        int endYLargest = CollectionUtil.filterOutByClass(this.editorScreen.getWidgetStream(), BlankWidget.class).mapToInt(DynamicWidget::getEndY).max().orElse(0);
        boolean isWidgetOutOfBounds = endYLargest > this.editorScreen.height;
        boolean bl = isFullSizeOutOfBounds = fullSize - embed.getHeight() + endYLargest >= this.editorScreen.height;
        if (isWidgetOutOfBounds || isFullSizeOutOfBounds) {
            return 56 + (switch (ToolDrawer.get()) {
                default -> throw new MatchException(null, null);
                case ToolDrawer.OPEN -> 0;
                case ToolDrawer.HALF -> 21;
                case ToolDrawer.CLOSED -> 42;
            });
        }
        return fullSize;
    }

    private void onSetEditorMode(ButtonWidget button) {
        if (button.find(CanvasTools.class).noneMatch(CanvasTools::isMoveOrSelect)) {
            this.getSelectedPixels().forEach(Pixel::deselect);
        }
        button.find(CanvasTools.class).findFirst().ifPresent(CanvasTools::set);
    }

    private TextureIcon getFinishIcon() {
        return this.editorScreen.hasChanges() ? Icons.RED_X : Icons.GREEN_CHECK;
    }

    private Component getFinishTitle() {
        return this.editorScreen.hasChanges() ? Lang.Vanilla.GUI_CANCEL.get(new Object[0]) : Lang.Vanilla.GUI_DONE.get(new Object[0]);
    }

    private TextureIcon getSoundIcon() {
        return (Boolean)this.sound.get() != false ? Icons.SOUND : Icons.SOUND_OFF;
    }

    private Component getSoundTitle() {
        return (Boolean)this.sound.get() != false ? Lang.Logo.SOUND_ON_UNDERLINE.get(new Object[0]) : Lang.Logo.SOUND_OFF_UNDERLINE.get(new Object[0]);
    }

    private Component getSoundTooltip() {
        return (Boolean)this.sound.get() != false ? Lang.Logo.SOUND_ON.get(new Object[0]) : Lang.Logo.SOUND_OFF.get(new Object[0]);
    }

    private void makeHistory() {
        if (this.history.isChangeInTimeline()) {
            this.history.capture();
        }
    }

    private void clear() {
        this.makeHistory();
        this.blocks.get().clear();
        this.editorScreen.replayAnimation(true);
    }

    private void copyCanvasToFile() {
        FallingBlockData data = this.data.get().copy();
        CompletableFuture.runAsync(() -> {
            Path defaultFile = PathUtil.getLogoPath().resolve("falling_blocks_copy.json");
            String writeLocation = FileDialog.getJsonLocation("Copy Pixel Canvas", defaultFile, DialogType.SAVE_FILE);
            if (writeLocation != null) {
                FallingBlockConfig.write(data, Path.of(writeLocation, new String[0]).toFile());
                NostalgicTweaks.LOGGER.info("[Falling Blocks] Successfully copied pixel canvas to config file at %s", writeLocation);
            }
        });
    }

    private void uploadFileToCanvas() {
        CompletableFuture.supplyAsync(() -> {
            FallingBlockData data = new FallingBlockData();
            Path defaultFile = PathUtil.getLogoPath().resolve(" ");
            String readLocation = FileDialog.getJsonLocation("Upload Falling Block Config", defaultFile, DialogType.OPEN_FILE);
            if (readLocation != null) {
                FallingBlockConfig.upload(Path.of(readLocation, new String[0]).toFile(), data);
            }
            return data;
        }).whenCompleteAsync((data, throwable) -> Minecraft.getInstance().execute(() -> {
            if (throwable != null) {
                EditorOverlay.couldNotReadConfig();
                NostalgicTweaks.LOGGER.error("[Falling Blocks] An error occurred when trying to read uploaded file\n%s", throwable);
            } else if (data != null && !data.blocks.isEmpty()) {
                this.makeHistory();
                this.blocks.get().clear();
                this.blocks.get().addAll(data.blocks);
                this.scaleSlider.setValue(data.scale);
                this.editorScreen.replayAnimation();
            }
        }));
    }

    private void moveDrawerUp() {
        ToolDrawer.up();
        this.collapseOrExpand();
    }

    private void moveDrawerDown() {
        ToolDrawer.down();
        this.collapseOrExpand();
    }

    private void collapseOrExpand() {
        switch (ToolDrawer.get()) {
            case OPEN: {
                this.pixelSettings.setVisible();
                this.batchEditing.setVisible();
                ((SeparatorBuilder)this.bottomOfEditor.getBuilder()).below(this.batchEditing, 0);
                break;
            }
            case HALF: {
                this.pixelSettings.setVisible();
                this.batchEditing.setInvisible();
                ((SeparatorBuilder)this.bottomOfEditor.getBuilder()).below(this.pixelSettings, 0);
                break;
            }
            case CLOSED: {
                this.pixelSettings.setInvisible();
                this.batchEditing.setInvisible();
                ((SeparatorBuilder)this.bottomOfEditor.getBuilder()).below(this.canvasTools, 0);
            }
        }
    }

    private void undoLastAction() {
        this.history.goBack();
        this.scaleSlider.setValue(this.data.get().scale);
    }

    private void redoLastAction() {
        this.history.goForward();
        this.scaleSlider.setValue(this.data.get().scale);
    }

    private void setScalingFactor(Number number) {
        this.data.get().setScale(MathUtil.roundTo(number.floatValue(), 1));
        this.editorScreen.replayAnimation(true);
    }

    private float getScalingFactor() {
        return this.data.get().scale;
    }

    private void onScaleChange(SliderWidget slider) {
        this.scaling.set(Float.valueOf((float)slider.getValue()));
    }

    boolean isCanvasDragged(double mouseX, double mouseY, int button) {
        return CanvasTools.get().isDraggable() && this.canvas.isWidgetClicked(mouseX, mouseY, button);
    }

    boolean onCanvasMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.canvas.isValidClick(mouseX, mouseY, button)) {
            boolean isMovingClicked;
            if (CanvasTools.get() == CanvasTools.SELECT && !(isMovingClicked = this.editorScreen.getVisibleWidgets().anyMatch(widget -> widget.has((Object)CanvasTools.MOVEIT) && widget.isMouseOver(mouseX, mouseY)))) {
                this.pixels.forEach(Pixel::deselect);
            }
            return false;
        }
        this.isMouseClickedOnCanvas = true;
        if (CanvasTools.get() == CanvasTools.SELECT) {
            if (!Screen.hasControlDown() && !Screen.hasShiftDown()) {
                this.pixels.forEach(Pixel::deselect);
            }
            if (!Screen.hasShiftDown()) {
                this.getPixelAtMouse(mouseX, mouseY).ifPresent(Pixel::select);
            } else {
                this.getPixelAtMouse(mouseX, mouseY).ifPresent(Pixel::deselect);
            }
        }
        if (CanvasTools.get() == CanvasTools.MOVEIT) {
            this.makeHistory();
            this.getSelectedPixels().forEach(Pixel::prepareForMovement);
            this.movePixelsByMouse(mouseX, mouseY);
        }
        return false;
    }

    boolean onCanvasMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isCanvasDragged(mouseX, mouseY, button) && this.isMouseClickedOnCanvas) {
            if (CanvasTools.get() == CanvasTools.MOVEIT) {
                this.movePixelsByMouse(mouseX, mouseY);
                return true;
            }
            Rectangle fromMouse = Rectangle.fromPoint((int)mouseX, (int)mouseY);
            this.pixels.stream().filter(pixel -> pixel.intersects(fromMouse)).forEach(pixel -> {
                switch (CanvasTools.get()) {
                    case DRAW: {
                        pixel.draw();
                        break;
                    }
                    case ERASER: {
                        pixel.erase();
                        break;
                    }
                    case SELECT: {
                        if (Screen.hasShiftDown()) {
                            pixel.deselect();
                            break;
                        }
                        pixel.select();
                    }
                }
            });
            return true;
        }
        return false;
    }

    boolean onCanvasMouseReleased(double mouseX, double mouseY, int button) {
        if (CollectionUtil.isNotEmpty(this.moving)) {
            this.getSelectedPixels().forEach(Pixel::deselect);
            this.moving.forEach(Pixel::applyChangeInMovement);
            this.moving.clear();
        }
        if (this.isCanvasDragged(mouseX, mouseY, button)) {
            this.editorScreen.replayAnimation(true);
        }
        this.isMouseClickedOnCanvas = false;
        return false;
    }

    boolean keyPressed(int keyCode) {
        return switch (keyCode) {
            case 81 -> {
                if (this.canvas.isFocused()) {
                    this.canvas.setOverrideFocused(false);
                } else {
                    this.canvas.setOverrideFocused(true);
                    this.canvas.getVisibleWidgets().filter(DynamicWidget::isFocused).findFirst().ifPresentOrElse(this.canvas::setScrollOn, () -> CollectionUtil.first(this.canvas.getVisibleWidgets()).ifPresent(DynamicWidget::setFocused));
                }
                yield true;
            }
            case 90 -> {
                if (Screen.hasControlDown()) {
                    this.history.goBack();
                    yield true;
                }
                yield false;
            }
            case 89 -> {
                if (Screen.hasControlDown()) {
                    this.history.goForward();
                    yield true;
                }
                yield false;
            }
            case 68 -> {
                CanvasTools.set(CanvasTools.DRAW);
                yield true;
            }
            case 75 -> {
                CanvasTools.set(CanvasTools.PICK);
                yield true;
            }
            case 83 -> {
                if (Screen.hasControlDown()) {
                    if (this.editorScreen.hasChanges()) {
                        this.editorScreen.save();
                    }
                } else {
                    CanvasTools.set(CanvasTools.SELECT);
                }
                yield true;
            }
            case 77 -> {
                CanvasTools.set(CanvasTools.MOVEIT);
                yield true;
            }
            case 69 -> {
                CanvasTools.set(CanvasTools.ERASER);
                yield true;
            }
            case 66 -> {
                this.blockPicker.runIfPossible(false);
                yield true;
            }
            case 79 -> {
                if (Screen.hasControlDown()) {
                    Util.getPlatform().openFile(PathUtil.getLogoPath().toFile());
                    yield true;
                }
                yield false;
            }
            case 85 -> {
                if (Screen.hasControlDown()) {
                    this.uploadFileToCanvas();
                } else {
                    this.soundToggle.runIfPossible(true);
                }
                yield true;
            }
            case 67 -> {
                if (Screen.hasControlDown()) {
                    this.copyCanvasToFile();
                } else {
                    this.colorPicker.runIfPossible(false);
                }
                yield true;
            }
            case 70 -> {
                this.filterSelection.runIfPossible(false);
                yield true;
            }
            case 65 -> {
                this.applySelection.runIfPossible(true);
                yield true;
            }
            case 82 -> {
                this.clearCanvas.runIfPossible(true);
                yield true;
            }
            case 72 -> {
                this.helpManual.runIfPossible(false);
                yield true;
            }
            case 80 -> {
                this.editorScreen.replayAnimation();
                yield true;
            }
            case 61, 334 -> {
                if (Screen.hasControlDown()) {
                    this.scaleSlider.incrementIfPossible();
                    yield true;
                }
                yield false;
            }
            case 45 -> {
                if (Screen.hasControlDown()) {
                    this.scaleSlider.decrementIfPossible();
                    yield true;
                }
                yield false;
            }
            case 267 -> {
                this.moveDrawerDown();
                yield true;
            }
            case 266 -> {
                this.moveDrawerUp();
                yield true;
            }
            case 261 -> {
                if (CanvasTools.get().equals((Object)CanvasTools.SELECT) && this.isAnyPixelSelected()) {
                    this.getSelectedPixels().forEach(Pixel::erase);
                    yield true;
                }
                yield false;
            }
            case 256 -> {
                if (this.isAnyPixelSelected()) {
                    this.getSelectedPixels().forEach(Pixel::deselect);
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void borderShadow(BlankWidget widget, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int x0 = widget.getX();
        int y0 = widget.getY();
        int x1 = widget.getEndX();
        int y1 = widget.getEndY();
        if (widget.has(Direction.NORTH)) {
            RenderUtil.fromTopGradient(graphics, (float)x0, (float)y0, (float)x1, (float)y1, Color.BLACK.fromAlpha(0), Color.BLACK);
        } else {
            RenderUtil.fromTopGradient(graphics, (float)x0, (float)y0, (float)x1, (float)y1, Color.BLACK, Color.BLACK.fromAlpha(0));
        }
    }

    private void shadowToolBackground(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean isActive = button.isHoveredOrFocused();
        Color outline = isActive ? Color.CADET_GRAY.fromAlpha(0.2).brighten(0.2) : Color.CADET_GRAY.fromAlpha(0.2);
        Color fill = isActive ? this.shadow.brighten(0.2) : this.shadow;
        int x = button.getX();
        int y = button.getY();
        int w = button.getWidth();
        int h = button.getHeight();
        RenderUtil.outline(graphics, (float)x, (float)y, (float)w, (float)h, outline);
        RenderUtil.fill(graphics, (float)(x + 1), (float)(y + 1), (float)(x + w - 1), (float)(y + h - 1), fill.fromAlpha(Math.min(0.4, (double)fill.getFloatAlpha())));
    }

    private void editorToolsBackground(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Color fill;
        Color line = button.has((Object)CanvasTools.get()) ? Color.ORANGE : Color.TRANSPARENT;
        Color color = fill = button.has((Object)CanvasTools.get()) ? Color.COPPER_RED.fromAlpha(0.4) : Color.CADET_GRAY.fromAlpha(0.2);
        if (button.isHoveredOrFocused()) {
            fill = fill.brighten(0.2);
        }
        RenderUtil.fill(graphics, (float)button.getX(), (float)button.getY(), (float)button.getEndX(), (float)button.getEndY(), fill);
        RenderUtil.hLine(graphics, (float)button.getX(), (float)(button.getEndY() - 1), (float)button.getEndX(), line);
    }

    private void regularToolsBackground(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Color fill = Color.CADET_GRAY.fromAlpha(0.2);
        if (button.isHoveredOrFocused()) {
            fill = fill.brighten(0.2);
        }
        RenderUtil.fill(graphics, (float)button.getX(), (float)button.getY(), (float)button.getEndX(), (float)button.getEndY(), fill);
    }

    private void aboveEmbedController(Embed embed, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.vLine(graphics, (float)(embed.getX() - 1), (float)(embed.getY() - 1), (float)embed.getEndY(), Color.SILVER_CHALICE);
        RenderUtil.vLine(graphics, (float)embed.getEndX(), (float)(embed.getY() - 1), (float)embed.getEndY(), Color.SILVER_CHALICE);
        RenderUtil.hLine(graphics, (float)embed.getX(), (float)(embed.getY() - 1), (float)embed.getEndX(), Color.SILVER_CHALICE);
    }

    private void bottomEmbedController(Embed embed, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.vLine(graphics, (float)(embed.getX() - 1), (float)embed.getY(), (float)(embed.getEndY() + 1), Color.SILVER_CHALICE);
        RenderUtil.vLine(graphics, (float)embed.getEndX(), (float)embed.getY(), (float)(embed.getEndY() + 1), Color.SILVER_CHALICE);
        RenderUtil.hLine(graphics, (float)embed.getX(), (float)embed.getEndY(), (float)embed.getEndX(), Color.SILVER_CHALICE);
    }

    private void sliderBackground(SliderWidget slider, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.fill(graphics, (float)slider.getX(), (float)slider.getY(), (float)slider.getEndX(), (float)slider.getEndY(), Color.OLIVE_BLACK);
        RenderUtil.fill(graphics, (float)(slider.getX() + 2), (float)slider.getY() + 4.5f, (float)(slider.getEndX() - 2), (float)slider.getY() + 5.0f, Color.SILVER_CHALICE);
        RenderUtil.vLine(graphics, (float)(slider.getX() - 1), (float)(slider.getY() - 1), (float)slider.getEndY(), Color.SILVER_CHALICE);
        RenderUtil.vLine(graphics, (float)slider.getEndX(), (float)(slider.getY() - 1), (float)slider.getEndY(), Color.SILVER_CHALICE);
        RenderUtil.hLine(graphics, (float)slider.getX(), (float)(slider.getY() - 1), (float)slider.getEndX(), Color.SILVER_CHALICE);
    }

    private void sliderHandle(SliderWidget slider, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Color color = slider.isHoveredOrFocused() ? Color.MAYA_BLUE : Color.WHITE;
        int handleWidth = slider.getHandleWidth();
        int x0 = Mth.clamp((int)slider.getHandleX(), (int)(slider.getX() + 2), (int)(slider.getEndX() - 2 - handleWidth));
        int x1 = Mth.clamp((int)(slider.getHandleX() + handleWidth), (int)(slider.getX() + 2 + handleWidth), (int)(slider.getEndX() - 2));
        int y0 = slider.getY() + 1;
        int y1 = slider.getEndY() - 1;
        RenderUtil.fill(graphics, (float)x0, (float)y0, (float)x1, (float)y1, color);
        if (slider.isHoveredOrFocused()) {
            DrawText.begin(graphics, (Component)Lang.Slider.SCALE.get(String.format("%.0f%%", slider.getValue() * 100.0))).pos(slider.getX() + slider.getWidth() / 2, slider.getY() - GuiUtil.textHeight() - 1).center().draw();
        }
    }

    Optional<Pixel> getPixelAtMouse(double mouseX, double mouseY) {
        return this.pixels.stream().filter(pixel -> pixel.isMouseAt(mouseX, mouseY)).findFirst();
    }

    Optional<Pixel> getPixelAt(int x, int y) {
        return this.pixels.stream().filter(pixel -> pixel.isAt(x, y)).findFirst();
    }

    Optional<Pixel> getSelectedPixelAt(int x, int y) {
        return this.getPixelAt(x, y).stream().filter(Pixel::isSelected).findFirst();
    }

    Stream<Pixel> getSelectedPixels() {
        return this.pixels.stream().filter(Pixel::isSelected);
    }

    boolean isAnyPixelSelected() {
        return this.pixels.stream().anyMatch(Pixel::isSelected);
    }

    void movePixelsByMouse(double mouseX, double mouseY) {
        IntegerHolder offsetX = IntegerHolder.create(0);
        IntegerHolder offsetY = IntegerHolder.create(0);
        this.getPixelAtMouse(mouseX, mouseY).ifPresent(pixel -> CollectionUtil.first(this.moving).ifPresent(first -> {
            offsetX.set(pixel.x - first.moveX);
            offsetY.set(pixel.y - first.moveY);
        }));
        for (Pixel pixel2 : this.moving) {
            boolean isYOutOfBounds;
            int dx = pixel2.moveX + (Integer)offsetX.get();
            int dy = pixel2.moveY + (Integer)offsetY.get();
            boolean isXOutOfBounds = dx < 0 || dx >= 64;
            boolean bl = isYOutOfBounds = dy < 0 || dy >= 12;
            if (!isXOutOfBounds && !isYOutOfBounds) continue;
            return;
        }
        this.moving.forEach(pixel -> {
            pixel.moveX += ((Integer)offsetX.get()).intValue();
            pixel.moveY += ((Integer)offsetY.get()).intValue();
        });
    }

    void findMatchedPixels() {
        this.pixels.forEach(pixel -> {
            pixel.deselect();
            pixel.getData().ifPresent(block -> {
                boolean sound;
                boolean blockId = ItemUtil.getResourceKey(this.block).equals(block.getBlockId());
                boolean color = HexUtil.parseInt(block.getShadowColor()) == this.shadow.get();
                boolean bl = sound = block.hasSound() == ((Boolean)this.sound.get()).booleanValue();
                if (blockId && color && sound) {
                    pixel.select();
                }
            });
        });
    }

    void applySelectedPixels() {
        this.makeHistory();
        this.getSelectedPixels().forEach(Pixel::draw);
        this.editorScreen.replayAnimation(true);
    }

    public class Pixel {
        public static final int SIZE = 10;
        private final ButtonWidget button;
        private final int x;
        private final int y;
        private boolean selected;
        private final NullableHolder<FallingBlockData.Block> moveData;
        private boolean moving;
        private int moveX;
        private int moveY;

        public Pixel(int x, int y) {
            this.x = x;
            this.y = y;
            this.moveData = NullableHolder.empty();
            this.button = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().skipFocusOnClick()).noClickSound()).size(10)).onPress(this::onPress)).renderer(this::render)).build();
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void select() {
            this.selected = true;
        }

        public void deselect() {
            this.selected = false;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isAt(int x, int y) {
            return this.x == x && this.y == y;
        }

        public boolean isMouseAt(double mouseX, double mouseY) {
            return this.intersects(Rectangle.fromPoint((int)mouseX, (int)mouseY));
        }

        public boolean intersects(Rectangle rectangle) {
            return Rectangle.intersect(rectangle, this.button.getPositionRectangle());
        }

        public void prepareForMovement() {
            EditorWidgets.this.moving.add(this);
            this.moveData.set(this.getData().orElse(null));
            this.moveX = this.x;
            this.moveY = this.y;
            this.moving = true;
            this.erase();
        }

        public void applyChangeInMovement() {
            EditorWidgets.this.getPixelAt(this.moveX, this.moveY).ifPresent(pixel -> {
                pixel.selected = true;
                pixel.getData().ifPresentOrElse(block -> this.moveData.ifPresent(data -> {
                    block.setBlockId(data.getBlockId());
                    block.setShadowColor(data.getShadowColor());
                    block.setSound(data.hasSound());
                }), () -> this.moveData.ifPresent(data -> {
                    String blockId = data.getBlockId();
                    String shadow = data.getShadowColor();
                    boolean sound = data.hasSound();
                    EditorWidgets.this.blocks.get().add(new FallingBlockData.Block(this.moveX, this.moveY, blockId, shadow, sound));
                }));
            });
            this.moveData.clear();
            this.moving = false;
        }

        void draw() {
            String blockId = ItemUtil.getResourceKey(EditorWidgets.this.block);
            String shadow = HexUtil.parseString(EditorWidgets.this.shadow.getIntComponents());
            boolean sound = (Boolean)EditorWidgets.this.sound.get();
            EditorWidgets.this.blocks.get().stream().filter(block -> block.at(this.x, this.y)).findFirst().ifPresentOrElse(block -> {
                block.setBlockId(blockId);
                block.setShadowColor(shadow);
                block.setSound(sound);
            }, () -> EditorWidgets.this.blocks.get().add(new FallingBlockData.Block(this.x, this.y, blockId, shadow, sound)));
        }

        void pick() {
            Optional<FallingBlockData.Block> data = this.getData();
            if (data.isEmpty()) {
                return;
            }
            EditorWidgets.this.block = ItemUtil.getItem(data.get().getBlockId());
            EditorWidgets.this.sound.set(data.get().hasSound());
            EditorWidgets.this.shadow.set(HexUtil.parseInt(data.get().getShadowColor()));
            EditorWidgets.this.shadow.setAlpha(HexUtil.parseFloatRGBA(data.get().getShadowColor())[3]);
        }

        void erase() {
            EditorWidgets.this.blocks.get().removeIf(block -> block.at(this.x, this.y));
        }

        Optional<FallingBlockData.Block> getData() {
            return EditorWidgets.this.blocks.get().stream().filter(block -> block.at(this.x, this.y)).findFirst();
        }

        private void onPress() {
            CanvasTools tool = CanvasTools.get();
            if (CanvasTools.DRAW == tool || CanvasTools.ERASER == tool) {
                EditorWidgets.this.makeHistory();
            }
            switch (tool) {
                case DRAW: {
                    this.draw();
                    break;
                }
                case PICK: {
                    this.pick();
                    break;
                }
                case ERASER: {
                    this.erase();
                }
            }
            if (CanvasTools.DRAW == tool || CanvasTools.ERASER == tool) {
                EditorWidgets.this.editorScreen.replayAnimation(true);
            }
        }

        public Color getColor(int x, int y) {
            Color color;
            boolean isOdd = MathUtil.isOdd(x) && MathUtil.isOdd(y);
            boolean isEven = MathUtil.isEven(x) && MathUtil.isEven(y);
            boolean isFirst = isOdd || isEven;
            Color color2 = color = isFirst ? new Color(0xDDDDDD) : new Color(0x999999);
            if (this.selected) {
                Color color3 = color = isFirst ? Color.FRENCH_SKY_BLUE : Color.IRIS_BLUE;
            }
            if (this.button.isHoveredOrFocused()) {
                color = Color.LEMON_YELLOW;
            }
            return color.fromAlpha(0.2);
        }

        private void render(ButtonWidget base, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            FallingBlockData.Block data = this.moveData.orElse(this.getData().orElse(null));
            ButtonWidget active = !this.moving ? base : EditorWidgets.this.getPixelAt(this.moveX, this.moveY).map(Pixel::getButton).orElse(base);
            RenderUtil.fill(graphics, (float)base.getX(), (float)base.getY(), (float)base.getEndX(), (float)base.getEndY(), this.getColor(this.x, this.y));
            if (this.moving) {
                RenderUtil.fill(graphics, (float)active.getX(), (float)active.getY(), (float)active.getEndX(), (float)active.getEndY(), this.getColor(this.moveX, this.moveY));
            }
            if (data != null) {
                int[] rgba = HexUtil.parseRGBA(data.getShadowColor());
                Color shadow = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
                ItemStack itemStack = ItemUtil.getItemStack(data.getBlockId());
                Optional<ResourceLocation> notes = Icons.MUSIC_SINGLE.getSpriteLocation();
                graphics.pose().pushPose();
                graphics.pose().translate((float)active.getX() + 1.0f, (float)active.getY() + 0.5f, 0.0f);
                graphics.pose().scale(0.5f, 0.5f, 0.5f);
                RenderUtil.renderItem(graphics, itemStack, 0, 0);
                graphics.pose().popPose();
                RenderUtil.hLine(graphics, (float)active.getX(), (float)(active.getEndY() - 1), (float)active.getEndX(), shadow);
                if (data.hasSound() && notes.isPresent()) {
                    graphics.pose().pushPose();
                    graphics.pose().translate(0.0f, 0.0f, 20.0f);
                    RenderUtil.blitSprite(notes.get(), graphics, 0.5f, active.getX(), active.getY(), Icons.MUSIC_SINGLE.getWidth(), Icons.MUSIC_SINGLE.getHeight());
                    graphics.pose().popPose();
                }
            }
            if (this.selected) {
                this.drawSelectionBorder(active, graphics);
            }
            if (active.isFocused()) {
                RenderUtil.outline(graphics, (float)active.getX(), (float)active.getY(), (float)active.getWidth(), (float)active.getHeight(), Color.MAYA_BLUE);
            }
        }

        private void drawSelectionBorder(ButtonWidget button, GuiGraphics graphics) {
            Color color = Color.AZURE_WHITE;
            int startX = button.getX();
            int startY = button.getY();
            int endX = button.getEndX();
            int endY = button.getEndY();
            if (EditorWidgets.this.getSelectedPixelAt(this.x, this.y - 1).isEmpty()) {
                RenderUtil.hLine(graphics, (float)startX, (float)startY, (float)endX, color);
            }
            if (EditorWidgets.this.getSelectedPixelAt(this.x, this.y + 1).isEmpty()) {
                RenderUtil.hLine(graphics, (float)startX, (float)(endY - 1), (float)endX, color);
            }
            if (EditorWidgets.this.getSelectedPixelAt(this.x + 1, this.y).isEmpty()) {
                RenderUtil.vLine(graphics, (float)(endX - 1), (float)startY, (float)endY, color);
            }
            if (EditorWidgets.this.getSelectedPixelAt(this.x - 1, this.y).isEmpty()) {
                RenderUtil.vLine(graphics, (float)startX, (float)startY, (float)endY, color);
            }
            if (EditorWidgets.this.getSelectedPixelAt(this.x + 1, this.y - 1).isEmpty()) {
                RenderUtil.fill(graphics, (float)(endX - 1), (float)startY, (float)endX, (float)(startY + 1), color);
            }
            if (EditorWidgets.this.getSelectedPixelAt(this.x - 1, this.y - 1).isEmpty()) {
                RenderUtil.fill(graphics, (float)startX, (float)startY, (float)(startX + 1), (float)(startY + 1), color);
            }
            if (EditorWidgets.this.getSelectedPixelAt(this.x - 1, this.y + 1).isEmpty()) {
                RenderUtil.fill(graphics, (float)startX, (float)(endY - 1), (float)(startX + 1), (float)endY, color);
            }
            if (EditorWidgets.this.getSelectedPixelAt(this.x + 1, this.y + 1).isEmpty()) {
                RenderUtil.fill(graphics, (float)(endX - 1), (float)(endY - 1), (float)endX, (float)endY, color);
            }
        }

        public ButtonWidget getButton() {
            return this.button;
        }
    }
}

