/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockConfig;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.FallingBlockEditorScreen;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.embed.Embed;
import mod.adrenix.nostalgic.client.gui.widget.embed.EmbedBuilder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.Gradient;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.Holder;
import mod.adrenix.nostalgic.util.common.function.ForEachWithPrevious;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public abstract class EditorOverlay {
    private static final int PARAGRAPH_SPACING = GuiUtil.textHeight() + 2;
    private static final Overlay HELP_OVERLAY = Overlay.create(() -> Lang.Logo.Help.TITLE.get(new Object[0])).icon(Icons.SMALL_INFO).backgroundColor(new Color(1645364, 220)).resizeHeightUsingPercentage(0.65).resizeWidthUsingPercentage(0.75).build();
    private static final Embed HELP_CATEGORIES = ((EmbedBuilder)((EmbedBuilder)Embed.create().widthOfScreen(0.3f)).extendHeightToScreenEnd(0)).borderThickness(0).build(HELP_OVERLAY::addWidget);
    private static final SeparatorWidget HELP_SEPARATOR = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.AZURE_WHITE).width(1)).extendHeightToScreenEnd(0)).rightOf(HELP_CATEGORIES, 0)).build(HELP_OVERLAY::addWidget);

    private static void renderLeftTransparent(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Color fill;
        boolean isReading = button.maybeHas(HelpCategory.getFocused().orElse(null)).isPresent();
        Color line = button.isHoveredOrFocused() || isReading ? Color.LIGHT_BLUE : Color.TRANSPARENT;
        Color color = fill = button.isHoveredOrFocused() || isReading ? Color.AZURE_WHITE.fromAlpha(0.2) : Color.TRANSPARENT;
        if (isReading) {
            fill = button.isMouseOver(mouseX, mouseY) ? fill.brighten(0.2) : fill.brighten(0.1);
            line = button.isMouseOver(mouseX, mouseY) ? line.brighten(0.2) : line.brighten(0.1);
        }
        RenderUtil.fill(graphics, (float)button.getX(), (float)button.getY(), (float)button.getEndX(), (float)button.getEndY(), fill);
        RenderUtil.fill(graphics, (float)button.getX(), (float)button.getY(), (float)button.getX() + 1.5f, (float)button.getEndY(), line);
    }

    public static void howToUse() {
        HelpCategory.align();
        HelpCategory.stream().forEach(HelpCategory::makeInfoWidgets);
        if (HelpCategory.stream().map(HelpCategory::getSelector).noneMatch(Holder::get)) {
            HelpCategory.stream().findFirst().ifPresent(HelpCategory::focus);
        } else {
            HelpCategory.getFocused().ifPresent(HelpCategory::focus);
        }
        ((ArrayList)HELP_OVERLAY.getWidgets()).forEach(DynamicWidget::setUnfocused);
        HELP_OVERLAY.open();
    }

    public static void areYouSure(FallingBlockEditorScreen screen) {
        int padding = 2;
        Overlay overlay = Overlay.create((Component)Lang.Affirm.QUIT_TITLE.plainCopy(new Object[0])).icon(Icons.SMALL_WARNING).gradientBackground(Gradient.vertical(new Color(7819277, 220), new Color(2957061, 220))).resizeUsingPercentage(0.5).resizeHeightForWidgets().padding(padding).build();
        TextWidget message = ((TextBuilder)TextWidget.create(Lang.Affirm.QUIT_BODY).extendWidthToScreenEnd(0)).centerAligned().build(overlay::addWidget);
        SeparatorWidget separator = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.AZURE_WHITE).height(1)).extendWidthToScreenEnd(0)).below(message, padding)).build(overlay::addWidget);
        Grid grid = ((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)overlay, 2).below(separator, padding)).extendWidthToScreenEnd(0)).build(overlay::addWidget);
        ((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Logo.QUIT_DISCARD).icon(Icons.RED_TRASH_CAN)).onPress(() -> {
            overlay.close();
            Minecraft.getInstance().setScreen(screen.getParentScreen());
        })).build(grid::addCell);
        ((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Affirm.QUIT_CANCEL).icon(Icons.RIGHT_ARROW)).onPress(overlay::close)).build(grid::addCell).setFocused();
        overlay.open();
    }

    public static void couldNotReadConfig(Runnable onClose, boolean resetOffer) {
        int padding = 2;
        FlagHolder resetFlag = FlagHolder.off();
        Overlay overlay = Overlay.create(Lang.Logo.READ_ERROR).icon(Icons.SMALL_RED_WARNING).gradientBackground(Gradient.vertical(new Color(6499115, 220), new Color(0x281111, 220))).resizeUsingPercentage(0.5).resizeHeightForWidgets().padding(padding).onClose(() -> {
            if (!((Boolean)resetFlag.get()).booleanValue()) {
                return;
            }
            FallingBlockConfig.reset((Boolean)resetFlag.get(), "corrupted");
            onClose.run();
        }).build();
        TextWidget message = ((TextBuilder)TextWidget.create(Lang.Logo.READ_ERROR_INFO).extendWidthToScreenEnd(0)).centerAligned().build(overlay::addWidget);
        SeparatorWidget separator = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.AZURE_WHITE).height(1)).extendWidthToScreenEnd(0)).below(message, padding)).build(overlay::addWidget);
        if (resetOffer) {
            ButtonWidget checkbox = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.checkbox(Lang.EMPTY, resetFlag::get).skipFocusOnClick()).below(separator, padding * 2)).onPress(resetFlag::toggle)).build(overlay::addWidget);
            TextWidget reset = ((TextBuilder)((TextBuilder)TextWidget.create(Lang.Logo.RESET_CONFIG).extendWidthToScreenEnd(0)).rightOf(checkbox, 0)).build(overlay::addWidget);
            separator = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.AZURE_WHITE).height(1)).extendWidthToScreenEnd(0)).below(reset, padding * 2)).build(overlay::addWidget);
        }
        Grid grid = ((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)overlay, 2).below(separator, padding)).extendWidthToScreenEnd(0)).build(overlay::addWidget);
        ButtonTemplate.openFolder(PathUtil.getLogoPath()).build(grid::addCell);
        ((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.OKAY).icon(Icons.GREEN_CHECK)).onPress(overlay::close)).build(grid::addCell).setFocused();
        overlay.open();
    }

    public static void couldNotReadConfig() {
        EditorOverlay.couldNotReadConfig(() -> {}, false);
    }

    private static enum HelpCategory {
        TERMINOLOGY(Icons.BOOK_OPEN, Lang.Logo.Help.TERMINOLOGY, Lang.Logo.Help.TERMINOLOGY_INFO),
        TIPS_AND_HINTS(Icons.YELLOW_LIGHT, Lang.Logo.Help.TIPS_AND_HINTS, Lang.Logo.Help.TIPS_AND_HINTS_INFO),
        KEY_SHORTCUTS(Icons.LIGHTNING, Lang.Logo.Help.KEY_SHORTCUTS, Lang.Logo.Help.KEY_SHORTCUTS_INFO),
        CANVAS_TOOLS(Icons.PAINTBRUSH, Lang.Logo.Help.CANVAS_TOOLS, Lang.Logo.Help.CANVAS_TOOLS_INFO),
        PIXEL_SETTINGS(Icons.WRENCH, Lang.Logo.Help.PIXEL_SETTINGS, Lang.Logo.Help.PIXEL_SETTINGS_INFO),
        BATCH_EDITING(Icons.FILTER, Lang.Logo.Help.BATCH_EDITING, Lang.Logo.Help.BATCH_EDITING_INFO),
        FILE_OPTIONS(Icons.FOLDER, Lang.Logo.Help.FILE_OPTIONS, Lang.Logo.Help.FILE_OPTIONS_INFO),
        ACTION_HISTORY(Icons.CLIPBOARD, Lang.Logo.Help.ACTION_HISTORY, Lang.Logo.Help.ACTION_HISTORY_INFO),
        MOVE_TOOLBAR(Icons.UP_ARROW, Lang.Logo.Help.MOVE_TOOLBAR, Lang.Logo.Help.MOVE_TOOLBAR_INFO);

        final TextureIcon icon;
        final Translation title;
        final FlagHolder selector;
        final Supplier<ArrayList<Translation>> paragraphs;
        final ButtonWidget button;
        final Embed embed;

        private HelpCategory(TextureIcon icon, Translation title, Supplier<ArrayList<Translation>> paragraphs) {
            this.icon = icon;
            this.title = title;
            this.paragraphs = paragraphs;
            this.selector = FlagHolder.off();
            this.button = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(() -> this.title.get(new Object[0])).alignLeft(3)).attach(new Object[]{this})).icon(this.icon)).extendWidthToEnd(HELP_CATEGORIES, 1)).backgroundRenderer(EditorOverlay::renderLeftTransparent)).onPress(HelpCategory::select)).build(HELP_CATEGORIES::addWidget);
            this.embed = ((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)((EmbedBuilder)Embed.create().attach(new Object[]{this})).rightOf(HELP_SEPARATOR, 0)).extendWidthToScreenEnd(0)).extendHeightToScreenEnd(0)).borderThickness(0).padding(4, 4, 2, 4)).build(HELP_OVERLAY::addWidget);
            this.makeInfoWidgets();
            this.embed.setInvisible();
        }

        ButtonWidget getButton() {
            return this.button;
        }

        Embed getEmbed() {
            return this.embed;
        }

        FlagHolder getSelector() {
            return this.selector;
        }

        void makeInfoWidgets() {
            this.embed.removeAllWidgets();
            ArrayList<TextWidget> textWidgets = new ArrayList<TextWidget>();
            for (Translation paragraph : this.paragraphs.get()) {
                textWidgets.add(((TextBuilder)TextWidget.create(paragraph).extendWidthToEnd(this.embed, 0)).build(this.embed::addWidget));
            }
            ForEachWithPrevious.create(textWidgets).forEach((prev, next) -> ((TextBuilder)next.getBuilder()).below((DynamicWidget<?, ?>)prev, PARAGRAPH_SPACING)).run();
        }

        boolean isFocused() {
            return (Boolean)this.selector.get();
        }

        static Stream<HelpCategory> stream() {
            return Arrays.stream(HelpCategory.values());
        }

        static Optional<HelpCategory> getFocused() {
            return HelpCategory.stream().filter(HelpCategory::isFocused).findFirst();
        }

        static void select(ButtonWidget button) {
            HelpCategory.stream().map(HelpCategory::getSelector).forEach(FlagHolder::disable);
            HelpCategory.stream().map(HelpCategory::getButton).forEach(DynamicWidget::setUnfocused);
            HelpCategory.stream().map(HelpCategory::getEmbed).forEach(DynamicWidget::setInvisible);
            CollectionUtil.fromCast(button.getAttachments(), HelpCategory.class).findFirst().ifPresent(HelpCategory::focus);
        }

        static void focus(HelpCategory section) {
            section.getSelector().enable();
            section.getButton().setFocused();
            section.getEmbed().setVisible();
        }

        static void align() {
            ForEachWithPrevious.create(HelpCategory.stream().map(HelpCategory::getButton)).forEach((prev, next) -> ((ButtonBuilder)next.getBuilder()).below((DynamicWidget<?, ?>)prev, 0)).run();
        }
    }
}

