/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor;

import java.util.ArrayDeque;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockConfig;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockData;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor.FallingBlockEditorScreen;

public class EditorHistory {
    public static final int ACTION_CAPTURE_MAX = 50;
    public final ArrayDeque<FallingBlockData> undo = new ArrayDeque();
    public final ArrayDeque<FallingBlockData> redo = new ArrayDeque();
    protected final FallingBlockEditorScreen editorScreen;
    protected FallingBlockData firstPoint = FallingBlockConfig.getData();

    public EditorHistory(FallingBlockEditorScreen screen) {
        this.editorScreen = screen;
    }

    public boolean isNothingToUndo() {
        return this.undo.isEmpty();
    }

    public boolean isNothingToRedo() {
        return this.redo.isEmpty();
    }

    public void setFirstPointOnTimeline(FallingBlockData data) {
        this.firstPoint = data.copy();
    }

    public boolean isChangeInTimeline() {
        return this.undo.isEmpty() || FallingBlockConfig.isDataChanged(this.peekLastToUndo(), this.editorScreen.getManagedData());
    }

    public void capture() {
        this.redo.clear();
        this.addPointToUndo();
    }

    protected void addPointToUndo() {
        this.undo.add(this.editorScreen.getManagedData().copy());
        if (this.undo.size() > 50) {
            this.undo.pop();
        }
    }

    protected void addPointToRedo() {
        this.redo.add(this.editorScreen.getManagedData().copy());
        if (this.redo.size() > 50) {
            this.redo.pop();
        }
    }

    public void goBack() {
        if (this.undo.isEmpty()) {
            return;
        }
        this.addPointToRedo();
        FallingBlockData last = this.undo.pollLast();
        if (last != null) {
            this.editorScreen.setManagedData(last);
            this.editorScreen.replayAnimation(true);
        }
    }

    public void goForward() {
        if (this.redo.isEmpty()) {
            return;
        }
        this.addPointToUndo();
        FallingBlockData last = this.redo.pollLast();
        if (last != null) {
            this.editorScreen.setManagedData(last);
            this.editorScreen.replayAnimation(true);
        }
    }

    public FallingBlockData peekLastOrFirst() {
        FallingBlockData data = this.undo.peekLast();
        if (data != null) {
            return data;
        }
        return this.firstPoint;
    }

    public FallingBlockData peekLastToUndo() {
        FallingBlockData data = this.undo.peekLast();
        if (data != null) {
            return data;
        }
        return new FallingBlockData();
    }

    public FallingBlockData peekLastToRedo() {
        FallingBlockData data = this.redo.peekLast();
        if (data != null) {
            return data;
        }
        return new FallingBlockData();
    }
}

