/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.editor;

import mod.adrenix.nostalgic.util.common.array.CycleIndex;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.client.gui.screens.Screen;

public enum CanvasTools {
    DRAW(Icons.PAINTBRUSH, Lang.Logo.DRAW_TOOL_UNDERLINE, Lang.Logo.DRAW_TOOL, Lang.Logo.DRAW_TOOL_TOOLTIP, true),
    PICK(Icons.FILLED_COLOR_PICKER, Lang.Logo.PICK_TOOL_UNDERLINE, Lang.Logo.PICK_TOOL, Lang.Logo.PICK_TOOL_TOOLTIP, false),
    SELECT(Icons.SELECTOR, Lang.Logo.SELECT_TOOL_UNDERLINE, Lang.Logo.SELECT_TOOL, Lang.Logo.SELECT_TOOL_TOOLTIP, true),
    MOVEIT(Icons.MOVE, Lang.Logo.MOVEIT_TOOL_UNDERLINE, Lang.Logo.MOVEIT_TOOL, Lang.Logo.MOVEIT_TOOL_TOOLTIP, true),
    ERASER(Icons.ERASER, Lang.Logo.ERASER_TOOL_UNDERLINE, Lang.Logo.ERASER_TOOL, Lang.Logo.ERASER_TOOL_TOOLTIP, true);

    private static final CycleIndex CYCLE_INDEX;
    private final TextureIcon icon;
    private final Translation underline;
    private final Translation header;
    private final Translation tooltip;
    private final boolean draggable;

    private CanvasTools(TextureIcon icon, Translation underline, Translation header, Translation tooltip, boolean draggable) {
        this.icon = icon;
        this.underline = underline;
        this.header = header;
        this.tooltip = tooltip;
        this.draggable = draggable;
    }

    public TextureIcon icon() {
        return this.icon;
    }

    public Translation underline() {
        return this.underline;
    }

    public Translation header() {
        return this.header;
    }

    public Translation tooltip() {
        return this.tooltip;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public static boolean isMoveOrSelect(CanvasTools mode) {
        return SELECT == mode || MOVEIT == mode;
    }

    public static void set(int index) {
        CYCLE_INDEX.setStartIndex(index);
        CYCLE_INDEX.restart();
    }

    public static void set(CanvasTools mode) {
        for (int i = 0; i < CanvasTools.values().length; ++i) {
            if (mode != CanvasTools.values()[i]) continue;
            CanvasTools.set(i);
            return;
        }
    }

    public static CanvasTools get() {
        return CanvasTools.values()[CYCLE_INDEX.get()];
    }

    public static CanvasTools cycle() {
        if (Screen.hasShiftDown()) {
            CYCLE_INDEX.backward();
        } else {
            CYCLE_INDEX.forward();
        }
        return CanvasTools.values()[CYCLE_INDEX.get()];
    }

    public static void reset() {
        CYCLE_INDEX.setStartIndex(0);
        CYCLE_INDEX.restart();
    }

    static {
        CYCLE_INDEX = new CycleIndex(CanvasTools.values(), true);
    }
}

