/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config;

import java.util.ArrayList;
import mod.adrenix.nostalgic.util.common.math.Rectangle;

public class FallingBlockData {
    public float scale = 1.0f;
    public final ArrayList<Block> blocks = new ArrayList();

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void copyTo(FallingBlockData other) {
        other.scale = this.scale;
        other.blocks.clear();
        this.blocks.forEach(block -> other.blocks.add(block.copy()));
    }

    public FallingBlockData copy() {
        FallingBlockData data = new FallingBlockData();
        data.scale = this.scale;
        this.blocks.forEach(block -> data.blocks.add(block.copy()));
        return data;
    }

    public boolean areBlocksDifferent(FallingBlockData other) {
        if (this.blocks.isEmpty() && other.blocks.isEmpty()) {
            return false;
        }
        if (this.blocks.size() != other.blocks.size()) {
            return true;
        }
        Rectangle border = Rectangle.fromCollection(this.blocks, Block::getX, Block::getY);
        for (int x = border.startX(); x < border.endX(); ++x) {
            for (int y = border.startY(); y < border.endY(); ++y) {
                int relX = x;
                int relY = y;
                Block first = this.blocks.stream().filter(block -> block.at(relX, relY)).findFirst().orElse(Block.EMPTY);
                Block second = other.blocks.stream().filter(block -> block.at(relX, relY)).findFirst().orElse(Block.EMPTY);
                if (first == Block.EMPTY && second == Block.EMPTY || first.equals(second)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof FallingBlockData) {
            FallingBlockData data = (FallingBlockData)object;
            boolean sameBlocks = !this.areBlocksDifferent(data);
            boolean sameScale = Float.valueOf(this.scale).equals(Float.valueOf(data.scale));
            return sameBlocks && sameScale;
        }
        return false;
    }

    public static class Block {
        static final Block EMPTY = new Block(-1, -1, "minecraft:air", "#00000000", false);
        int x;
        int y;
        String blockId;
        String shadowColor;
        boolean sound;

        public Block() {
        }

        public Block(int x, int y, String blockId, String shadowColor, boolean sound) {
            this.x = x;
            this.y = y;
            this.blockId = blockId;
            this.shadowColor = shadowColor;
            this.sound = sound;
        }

        public void trimX(int by) {
            this.x -= by;
        }

        public void trimY(int by) {
            this.y -= by;
        }

        public int getX() {
            return Math.abs(this.x);
        }

        public int getY() {
            return Math.abs(this.y);
        }

        public boolean at(int x, int y) {
            return this.x == x && this.y == y;
        }

        public boolean hasSound() {
            return this.sound;
        }

        public void setSound(boolean sound) {
            this.sound = sound;
        }

        public String getShadowColor() {
            return this.shadowColor;
        }

        public void setShadowColor(String color) {
            this.shadowColor = color;
        }

        public String getBlockId() {
            return this.blockId;
        }

        public void setBlockId(String blockId) {
            this.blockId = blockId;
        }

        public Block copy() {
            Block block = new Block();
            block.x = this.x;
            block.y = this.y;
            block.blockId = this.blockId;
            block.shadowColor = this.shadowColor;
            block.sound = this.sound;
            return block;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Block)) {
                return false;
            }
            boolean sameX = ((Block)object).getX() == this.x;
            boolean sameY = ((Block)object).getY() == this.y;
            boolean sameSound = ((Block)object).hasSound() == this.sound;
            boolean sameColor = ((Block)object).getShadowColor().equals(this.shadowColor);
            boolean sameBlock = ((Block)object).getBlockId().equals(this.blockId);
            return sameX && sameY && sameSound && sameColor && sameBlock;
        }
    }
}

