/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockData;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import org.jetbrains.annotations.Nullable;

public abstract class FallingBlockConfig {
    public static final int MAX_WIDTH = 64;
    public static final int MAX_HEIGHT = 12;
    public static final String FILENAME = "falling_blocks.json";
    public static final String COPY_NAME = "falling_blocks_copy.json";
    public static final FlagHolder LOGO_CHANGED = FlagHolder.off();
    public static final NullableHolder<FallingBlockData> INSTANCE = NullableHolder.empty();

    public static void init() {
        CandyTweak.OLD_ALPHA_LOGO.whenChanged(LOGO_CHANGED::enable);
        CandyTweak.USE_CUSTOM_FALLING_LOGO.whenChanged(LOGO_CHANGED::enable);
    }

    public static boolean isBlockOutOfBounds(FallingBlockData.Block block) {
        return block.x < 0 || block.x > 64 || block.y < 0 || block.y > 12;
    }

    public static void upload(File config, FallingBlockData receiver) throws JsonIOException, JsonSyntaxException {
        try (FileReader reader = new FileReader(config);){
            FallingBlockData data = (FallingBlockData)new Gson().fromJson((Reader)reader, FallingBlockData.class);
            if (data != null) {
                data.blocks.removeIf(FallingBlockConfig::isBlockOutOfBounds);
                data.copyTo(receiver);
            }
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("[Falling Blocks] An error occurred when trying to read uploaded config file\n%s", exception);
        }
    }

    public static boolean read() {
        Comparable<Path> config;
        boolean hasException = false;
        try {
            Files.createDirectories(PathUtil.getLogoPath(), new FileAttribute[0]);
            config = PathUtil.getLogoPath().resolve(FILENAME);
            if (!Files.exists(config, new LinkOption[0])) {
                Files.createFile(config, new FileAttribute[0]);
            }
            NostalgicTweaks.LOGGER.debug("[Falling Blocks] Successfully created or read config file");
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("[Falling Blocks] An error occurred when trying to create config file\n%s", exception);
            hasException = true;
        }
        try {
            config = PathUtil.getLogoPath().resolve(FILENAME).toFile();
            try (FileReader reader = new FileReader((File)config);){
                INSTANCE.set((FallingBlockData)new Gson().fromJson((Reader)reader, FallingBlockData.class));
                if (INSTANCE.isPresent()) {
                    FallingBlockConfig.INSTANCE.getOrThrow().blocks.removeIf(FallingBlockConfig::isBlockOutOfBounds);
                } else {
                    INSTANCE.set(new FallingBlockData());
                }
            }
            catch (JsonIOException | JsonSyntaxException | IOException exception) {
                if (INSTANCE.isEmpty()) {
                    INSTANCE.set(new FallingBlockData());
                }
                hasException = true;
                NostalgicTweaks.LOGGER.error("[Falling Blocks] An error occurred when trying to read config file\n%s", exception);
            }
        }
        catch (UnsupportedOperationException | InvalidPathException exception) {
            NostalgicTweaks.LOGGER.error("[Falling Blocks] An error occurred when trying to get config file\n%s", exception);
            hasException = true;
        }
        return !hasException;
    }

    public static void write(FallingBlockData data, File file) {
        try {
            try (FileWriter writer = new FileWriter(file);){
                new GsonBuilder().setPrettyPrinting().create().toJson((Object)data, (Appendable)writer);
            }
            catch (JsonIOException | IOException exception) {
                NostalgicTweaks.LOGGER.error("[Falling Blocks] An error occurred when trying to write file to disk\n%s", exception);
            }
        }
        catch (UnsupportedOperationException | InvalidPathException exception) {
            NostalgicTweaks.LOGGER.error("[Falling Blocks] An error occurred when trying to read file for writing\n%s", exception);
        }
    }

    public static void apply(FallingBlockData data) {
        INSTANCE.ifPresent(cache -> {
            cache.scale = data.scale;
            cache.blocks.clear();
            cache.blocks.addAll(data.blocks);
        });
    }

    public static void save() {
        if (INSTANCE.isEmpty()) {
            NostalgicTweaks.LOGGER.warn("[Falling Blocks] Tried writing empty block data to disk. This shouldn't happen!");
            return;
        }
        try {
            FallingBlockConfig.write(INSTANCE.getOrThrow(), PathUtil.getLogoPath().resolve(FILENAME).toFile());
            LOGO_CHANGED.enable();
        }
        catch (UnsupportedOperationException | InvalidPathException exception) {
            NostalgicTweaks.LOGGER.error("[Falling Blocks] An error occurred when trying to save config file\n%s", exception);
        }
    }

    public static boolean backup(String prefixTimestamp) {
        String filename = FILENAME.replace(".json", "");
        String backup = String.format("%s_%s_%d.json", filename, prefixTimestamp, Instant.now().toEpochMilli());
        Path source = PathUtil.getLogoPath().resolve(FILENAME);
        Path target = PathUtil.getLogoPath().resolve(backup);
        try {
            Path copy = Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            NostalgicTweaks.LOGGER.info("[Falling Block] Made backup of config file at %s", copy.toString());
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("[Falling Block] (I/O) Error: Could not create backup of config. Aborting reset!\n%s", exception);
            return false;
        }
        return true;
    }

    public static void reset(boolean withBackup, @Nullable String prefixTimestamp) {
        if (withBackup) {
            String prefix;
            String string = prefix = prefixTimestamp == null ? "backup" : prefixTimestamp;
            if (!FallingBlockConfig.backup(prefix)) {
                return;
            }
        }
        FallingBlockConfig.setBlockDataToDefault();
        FallingBlockConfig.save();
    }

    public static void setBlockDataToDefault() {
        FallingBlockData data = new FallingBlockData();
        ArrayList<List<Integer>> rows = new ArrayList<List<Integer>>();
        rows.add(List.of(0, 4, 6, 8, 12, 14, 15, 16, 18, 19, 20, 22, 23, 24, 26, 27, 28, 30, 31, 32, 34, 35, 36));
        rows.add(List.of(0, 1, 3, 4, 6, 8, 9, 12, 14, 18, 22, 24, 26, 28, 30, 35));
        rows.add(List.of(0, 2, 4, 6, 8, 10, 12, 14, 15, 18, 22, 23, 26, 28, 27, 30, 31, 35));
        rows.add(List.of(0, 4, 6, 8, 11, 12, 14, 18, 22, 24, 26, 28, 30, 35));
        rows.add(List.of(0, 4, 6, 8, 12, 14, 15, 16, 18, 19, 20, 22, 24, 26, 28, 30, 35));
        for (int y = 0; y < rows.size(); ++y) {
            Iterator iterator = ((List)rows.get(y)).iterator();
            while (iterator.hasNext()) {
                int x = (Integer)iterator.next();
                data.blocks.add(new FallingBlockData.Block(x, y, "minecraft:stone", "#000000FF", false));
            }
        }
        INSTANCE.set(data);
    }

    public static FallingBlockData getData() {
        if (FallingBlockConfig.isNotAvailable()) {
            if (FallingBlockConfig.read() && INSTANCE.isPresent()) {
                return INSTANCE.getOrThrow();
            }
            return new FallingBlockData();
        }
        return INSTANCE.getOrThrow();
    }

    public static boolean isDataChanged(FallingBlockData initial, FallingBlockData maybeChanged) {
        return !initial.equals(maybeChanged);
    }

    public static boolean isNotAvailable() {
        return INSTANCE.isEmpty();
    }

    public static boolean hasNoBlocks() {
        if (INSTANCE.isEmpty()) {
            return true;
        }
        return FallingBlockConfig.INSTANCE.getOrThrow().blocks.isEmpty();
    }
}

