/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockData;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.text.FallingBlockText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.MatrixUtil;
import mod.adrenix.nostalgic.util.client.timer.PartialTick;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import mod.adrenix.nostalgic.util.common.data.NullableAction;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.math.Rectangle;
import mod.adrenix.nostalgic.util.common.world.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;

public class FallingBlockRenderer {
    private static final RandomSource RANDOM_SOURCE = RandomSource.create();
    private final FallingEffect[][] logoEffects;
    private final List<String> logo;
    private final int height;
    private final int width;
    private final float scaling;
    private final boolean immediate;

    public FallingBlockRenderer() {
        this.logo = FallingBlockText.getInstance().logo();
        this.width = FallingBlockText.getInstance().longestLine();
        this.height = FallingBlockText.getInstance().size();
        this.scaling = 1.0f;
        this.immediate = false;
        this.logoEffects = new FallingEffect[this.width][this.height];
        for (int x = 0; x < this.logoEffects.length; ++x) {
            for (int y = 0; y < this.logoEffects[x].length; ++y) {
                this.logoEffects[x][y] = new FallingEffect(this, x, y, false, "#000000FF", Blocks.STONE.defaultBlockState());
            }
        }
    }

    public FallingBlockRenderer(FallingBlockData data, boolean immediate) {
        this.logo = new ArrayList<String>();
        this.scaling = data.scale;
        this.immediate = immediate;
        Rectangle border = Rectangle.fromCollection(data.blocks, FallingBlockData.Block::getX, FallingBlockData.Block::getY);
        this.width = border.getWidth() + 1;
        this.height = border.getHeight() + 1;
        ArrayList trimmed = new ArrayList();
        data.blocks.forEach(block -> {
            FallingBlockData.Block copy = block.copy();
            copy.trimX(border.startX());
            copy.trimY(border.startY());
            trimmed.add(copy);
        });
        for (int y = 0; y < this.height; ++y) {
            StringBuilder lineBuilder = new StringBuilder();
            int x = 0;
            while (x < this.width) {
                int relX = x++;
                int relY = y;
                trimmed.stream().filter(block -> block.at(relX, relY)).findFirst().ifPresentOrElse(block -> lineBuilder.append("#"), () -> lineBuilder.append(" "));
            }
            this.logo.add(lineBuilder.toString());
        }
        this.logoEffects = new FallingEffect[this.width][this.height];
        for (int x = 0; x < this.logoEffects.length; ++x) {
            int y = 0;
            while (y < this.logoEffects[x].length) {
                int relX = x;
                int relY = y++;
                trimmed.stream().filter(block -> block.at(relX, relY)).findFirst().ifPresentOrElse(block -> {
                    boolean hasSound = block.hasSound();
                    String shadowColor = block.getShadowColor();
                    BlockState blockState = BlockUtil.getBlock(block.getBlockId()).defaultBlockState();
                    this.logoEffects[relX][relY] = new FallingEffect(this, relX, relY, hasSound, shadowColor, blockState);
                }, () -> {
                    BlockState blockState = Blocks.AIR.defaultBlockState();
                    this.logoEffects[relX][relY] = new FallingEffect(this, relX, relY, false, "#000000FF", blockState);
                });
            }
        }
    }

    public FallingBlockRenderer(FallingBlockData data) {
        this(data, false);
    }

    public boolean isFinished() {
        FallingEffect[][] fallingEffectArray = this.logoEffects;
        int n = fallingEffectArray.length;
        for (int i = 0; i < n; ++i) {
            FallingEffect[] logoEffect;
            for (FallingEffect logoEffectRandomizer : logoEffect = fallingEffectArray[i]) {
                if (logoEffectRandomizer.hasFallen()) continue;
                return false;
            }
        }
        return true;
    }

    public void render() {
        this.render(0.0f);
    }

    public void render(float yOffset) {
        if (this.logo.isEmpty()) {
            return;
        }
        FallingEffect[][] fallingEffectArray = this.logoEffects;
        int n = fallingEffectArray.length;
        for (int i = 0; i < n; ++i) {
            FallingEffect[] logoEffect;
            for (FallingEffect logoEffectRandomizer : logoEffect = fallingEffectArray[i]) {
                logoEffectRandomizer.update();
            }
        }
        Window window = GuiUtil.getWindow();
        int scaleHeight = (int)(120.0 * window.getGuiScale());
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().perspective(70.341f, (float)window.getWidth() / (float)scaleHeight, 0.05f, 100.0f), (VertexSorting)VertexSorting.DISTANCE_TO_ORIGIN);
        RenderSystem.viewport((int)0, (int)(window.getHeight() - scaleHeight), (int)window.getWidth(), (int)scaleHeight);
        PoseStack poseStack = new PoseStack();
        Tesselator tesselator = Tesselator.getInstance();
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        NullableHolder builder = NullableHolder.empty();
        float zOffset = MatrixUtil.getZ((Matrix4f)modelViewStack);
        modelViewStack.pushMatrix();
        modelViewStack.translate(-0.05f, 0.78f + yOffset, -1.0f * zOffset - 10.0f);
        modelViewStack.scale(1.32f * this.scaling, 1.32f * this.scaling, 1.32f * this.scaling);
        poseStack.mulPose((Matrix4f)modelViewStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)true);
        Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.7f, 1.0f, 0.7f).normalize();
        Vector3f DIFFUSE_LIGHT_1 = new Vector3f(-1.0f, 0.6f, 1.0f).normalize();
        RenderSystem.setShaderLights((Vector3f)DIFFUSE_LIGHT_0, (Vector3f)DIFFUSE_LIGHT_1);
        for (int pass = 0; pass < 2; ++pass) {
            poseStack.pushPose();
            if (pass == 0) {
                RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                poseStack.translate(0.0f, -0.4f, 0.0f);
                poseStack.scale(0.98f, 1.0f, 1.0f);
                builder.set(tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR));
            }
            if (pass == 1) {
                builder.ifPresent(buffer -> NullableAction.attempt(buffer.build(), BufferUploader::drawWithShader));
                RenderSystem.disableBlend();
                RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
            }
            poseStack.scale(-1.0f, 1.0f, -1.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.scale(0.89f, 1.0f, 0.4f);
            poseStack.translate((float)(-this.width) * 0.5f, (float)this.height * 0.5f, 0.0f);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.logo.get(y).length(); ++x) {
                    if (this.logo.get(y).charAt(x) == ' ') continue;
                    poseStack.pushPose();
                    FallingEffect effect = this.logoEffects[x][y];
                    float z = (float)effect.pos;
                    float scale = 1.0f;
                    float alpha = 1.0f;
                    if (pass == 0) {
                        scale = z * 0.04f + 1.0f;
                        alpha = Mth.clamp((float)(1.0f / scale), (float)0.0f, (float)0.7f);
                        z = 0.0f;
                    }
                    poseStack.translate((float)(x + 1), (float)(-y - 1), z + 1.0f);
                    poseStack.scale(-scale, scale, -scale);
                    this.renderBlock(effect, (BufferBuilder)builder.getOrThrow(), poseStack, pass, alpha);
                    poseStack.popPose();
                }
            }
            if (pass == 1) {
                Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
            }
            poseStack.popPose();
        }
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.viewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
        poseStack.setIdentity();
        poseStack.translate(0.0f, 0.0f, zOffset);
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableCull();
        Lighting.setupFor3DItems();
    }

    private void renderBlock(FallingEffect effect, BufferBuilder builder, PoseStack poseStack, int pass, float alpha) {
        if (pass == 0) {
            FallingBlockRenderer.renderShadow(effect, builder, poseStack, alpha);
            return;
        }
        if (effect.blockState.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        RandomSource randomSource = RandomSource.create();
        BakedModel bakedModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(effect.blockState);
        RenderType renderType = ItemBlockRenderTypes.getRenderType((BlockState)effect.blockState, (boolean)false);
        VertexConsumer vertexConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(renderType);
        int color = Minecraft.getInstance().getBlockColors().getColor(effect.blockState, null, null, 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        PoseStack.Pose pose = poseStack.last();
        for (Direction direction : Direction.values()) {
            randomSource.setSeed(42L);
            FallingBlockRenderer.renderQuads(pose, vertexConsumer, red, green, blue, bakedModel.getQuads(effect.blockState, direction, randomSource));
        }
        randomSource.setSeed(42L);
        FallingBlockRenderer.renderQuads(pose, vertexConsumer, red, green, blue, bakedModel.getQuads(effect.blockState, null, randomSource));
    }

    private static void renderQuads(PoseStack.Pose pose, VertexConsumer consumer, float red, float green, float blue, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (quad.isTinted()) {
                r = Mth.clamp((float)red, (float)0.0f, (float)1.0f);
                g = Mth.clamp((float)green, (float)0.0f, (float)1.0f);
                b = Mth.clamp((float)blue, (float)0.0f, (float)1.0f);
            }
            consumer.putBulkData(pose, quad, r, g, b, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
    }

    private static void renderShadow(FallingEffect effect, BufferBuilder builder, PoseStack poseStack, float alpha) {
        if (effect.alpha == 0.0f) {
            return;
        }
        int color = new Color(effect.red, effect.green, effect.blue, effect.alpha * alpha).get();
        Matrix4f matrix = poseStack.last().pose();
        builder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 0.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 0.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 1.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 1.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 0.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 0.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 1.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 1.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 1.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 0.0f, 0.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 0.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 1.0f, 0.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 1.0f, 1.0f).setColor(color);
        builder.addVertex(matrix, 1.0f, 0.0f, 1.0f).setColor(color);
    }

    private class FallingEffect {
        public double prevPos;
        public double pos;
        public double speed;
        public final boolean sound;
        public final float red;
        public final float green;
        public final float blue;
        public final float alpha;
        public final BlockState blockState;

        public FallingEffect(FallingBlockRenderer fallingBlockRenderer, int x, int y, boolean sound, String shadowColor, BlockState blockState) {
            this.prevPos = this.pos = 10.0 + (double)y + RANDOM_SOURCE.nextDouble() * 32.0 + (double)x;
            this.sound = sound;
            this.blockState = blockState;
            float[] rgba = HexUtil.parseFloatRGBA(shadowColor);
            this.red = rgba[0];
            this.green = rgba[1];
            this.blue = rgba[2];
            this.alpha = rgba[3];
            if (fallingBlockRenderer.immediate) {
                this.pos = 0.0;
                this.prevPos = 0.0;
            }
        }

        public void update() {
            this.prevPos = this.pos;
            if (this.pos > 0.0) {
                this.speed -= 0.4;
            }
            this.pos += this.speed * (double)PartialTick.realtime();
            this.speed *= 0.9;
            if (this.pos < 0.0) {
                this.pos = 0.0;
                this.speed = 0.0;
                if (this.prevPos > 0.0 && this.sound) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.blockState.getSoundType().getPlaceSound(), (float)1.0f, (float)0.2f));
                }
            }
        }

        public boolean hasFallen() {
            return this.pos <= 0.0 && this.speed <= 0.0;
        }
    }
}

