/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title;

import mod.adrenix.nostalgic.client.gui.screen.WidgetManager;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.NostalgicTitleScreen;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.TitleLayout;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.LocateResource;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.PackRepository;

class TitleWidgets
implements WidgetManager {
    static final int WIDGET_MARGIN = 4;
    static final int LARGE_MARGIN = 28;
    static final int LARGE_BUTTON = 200;
    static final int SMALL_BUTTON = 98;
    private final NostalgicTitleScreen titleScreen;
    private final Minecraft minecraft;

    TitleWidgets(NostalgicTitleScreen titleScreen) {
        this.titleScreen = titleScreen;
        this.minecraft = Minecraft.getInstance();
    }

    @Override
    public void init() {
        if (this.titleScreen.getLayout() != TitleLayout.MODERN) {
            switch (this.titleScreen.getLayout()) {
                case ALPHA: {
                    this.setAlphaLayout();
                    break;
                }
                case BETA: {
                    this.setBetaLayout();
                    break;
                }
                default: {
                    this.setReleaseLayout();
                }
            }
        }
        ((BlankBuilder)((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().posY(16)).widthOfScreen(0.75f)).centerInScreenX()).noClickSound().height(this.getY() - 24)).onPress(this.titleScreen::switchLogo).build(this.titleScreen::addWidget);
    }

    private boolean hasModsButton() {
        return (Boolean)CandyTweak.INCLUDE_MODS_ON_TITLE.get() != false && GuiUtil.modListScreen != null;
    }

    private int getX() {
        return this.titleScreen.width / 2 - 100;
    }

    private int getY() {
        return this.titleScreen.height / 4 + 48 - (this.hasModsButton() ? 12 : 0);
    }

    private void gotoSelectWorld() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new SelectWorldScreen((Screen)this.titleScreen));
        }
    }

    private void gotoMultiplayer() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new JoinMultiplayerScreen((Screen)this.titleScreen));
        }
    }

    private void gotoOptions() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new OptionsScreen((Screen)this.titleScreen, this.minecraft.options));
        }
    }

    private void gotoMods() {
        if (this.minecraft != null && GuiUtil.modListScreen != null) {
            this.minecraft.setScreen(GuiUtil.modListScreen.apply((Screen)this.titleScreen));
        }
    }

    private void updatePackList(PackRepository packRepository) {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.options.updateResourcePacks(packRepository);
        this.minecraft.setScreen((Screen)this.titleScreen);
    }

    private void gotoResourcePacks() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new PackSelectionScreen(this.minecraft.getResourcePackRepository(), this::updatePackList, this.minecraft.getResourcePackDirectory(), (Component)Lang.Vanilla.RESOURCE_PACK_TITLE.get(new Object[0])));
        }
    }

    private void gotoLanguage() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new LanguageSelectScreen((Screen)this.titleScreen, this.minecraft.options, this.minecraft.getLanguageManager()));
        }
    }

    private void setAlphaLayout() {
        ButtonWidget singleplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_SINGLEPLAYER).pos(this.getX(), this.getY())).width(200)).onPress(this::gotoSelectWorld)).build(this.titleScreen::addWidget);
        ButtonWidget multiplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_MULTIPLAYER).posX(this.getX())).below(singleplayer, 4)).width(200)).onPress(this::gotoMultiplayer)).build(this.titleScreen::addWidget);
        ButtonWidget mods = null;
        if (this.hasModsButton()) {
            mods = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).posX(this.getX())).below(multiplayer, 4)).width(200)).onPress(this::gotoMods)).build(this.titleScreen::addWidget);
        }
        ButtonWidget tutorial = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create((Component)Lang.Title.TUTORIAL.withStyle(ChatFormatting.GRAY)).disableIf(BooleanSupplier.ALWAYS)).posX(this.getX())).below(mods != null ? mods : multiplayer, 4)).width(200)).build(this.titleScreen::addWidget);
        boolean canStop = (Boolean)CandyTweak.ADD_QUIT_BUTTON.get();
        ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).posX(this.getX())).below(tutorial, 16)).width(canStop ? 98 : 200)).onPress(this::gotoOptions)).build(this.titleScreen::addWidget);
        if (canStop) {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_QUIT).rightOf(options, 4)).width(98)).onPress(() -> ((Minecraft)this.minecraft).stop())).build(this.titleScreen::addWidget);
        }
    }

    private void setBetaLayout() {
        ButtonWidget singleplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_SINGLEPLAYER).pos(this.getX(), this.getY())).width(200)).onPress(this::gotoSelectWorld)).build(this.titleScreen::addWidget);
        ButtonWidget multiplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_MULTIPLAYER).posX(this.getX())).below(singleplayer, 4)).width(200)).onPress(this::gotoMultiplayer)).build(this.titleScreen::addWidget);
        ButtonWidget mods = null;
        if (this.hasModsButton()) {
            mods = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).posX(this.getX())).below(multiplayer, 4)).width(200)).onPress(this::gotoMods)).build(this.titleScreen::addWidget);
        }
        ButtonWidget packs = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(this.hasModsButton() ? Lang.Title.TEXTURE_PACK : Lang.Title.MODS_TEXTURE).posX(this.getX())).below(mods != null ? mods : multiplayer, 4)).width(200)).onPress(this::gotoResourcePacks)).build(this.titleScreen::addWidget);
        boolean canStop = (Boolean)CandyTweak.ADD_QUIT_BUTTON.get();
        ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).posX(this.getX())).below(packs, canStop ? 16 : 4)).width(canStop ? 98 : 200)).onPress(this::gotoOptions)).build(this.titleScreen::addWidget);
        if (canStop) {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_QUIT).rightOf(options, 4)).width(98)).onPress(() -> ((Minecraft)this.minecraft).stop())).build(this.titleScreen::addWidget);
        }
    }

    private void setReleaseLayout() {
        if (this.minecraft == null) {
            return;
        }
        ButtonWidget singleplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_SINGLEPLAYER).pos(this.getX(), this.getY())).width(200)).onPress(this::gotoSelectWorld)).build(this.titleScreen::addWidget);
        ButtonWidget multiplayer = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_MULTIPLAYER).posX(this.getX())).below(singleplayer, 4)).width(200)).onPress(this::gotoMultiplayer)).build(this.titleScreen::addWidget);
        ButtonWidget mods = null;
        ButtonWidget packs = null;
        if (this.hasModsButton()) {
            mods = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.MODS).posX(this.getX())).below(multiplayer, 4)).width(200)).onPress(this::gotoMods)).build(this.titleScreen::addWidget);
        }
        if (this.titleScreen.getLayout() == TitleLayout.RELEASE_TEXTURE_PACK) {
            packs = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Title.TEXTURE_PACK).posX(this.getX())).below(mods != null ? mods : multiplayer, 4)).width(200)).onPress(this::gotoResourcePacks)).build(this.titleScreen::addWidget);
        }
        ButtonWidget options = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_OPTIONS).below(packs != null ? packs : (mods != null ? mods : multiplayer), packs == null && mods == null ? 40 : 16)).width(98)).posX(this.getX())).onPress(this::gotoOptions)).build(this.titleScreen::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Vanilla.MENU_QUIT).rightOf(options, 4)).width(98)).onPress(() -> ((Minecraft)this.minecraft).stop())).build(this.titleScreen::addWidget);
        if (!((Boolean)CandyTweak.REMOVE_TITLE_LANGUAGE_BUTTON.get()).booleanValue()) {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().leftOf(options, 4)).icon(TextureIcon.fromSprite(LocateResource.game("icon/language"), 15))).iconCenterOffset(-1)).onPress(this::gotoLanguage)).build(this.titleScreen::addWidget);
        }
    }
}

