/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.title;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.screen.DynamicScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.TitleWidgets;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.FallingBlockRenderer;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.config.FallingBlockConfig;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.logo.text.FallingBlockText;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.mixin.access.TitleScreenAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.TitleLayout;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.timer.PartialTick;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class NostalgicTitleScreen
extends TitleScreen
implements DynamicScreen<NostalgicTitleScreen> {
    private static final FlagHolder TOGGLE_LOGO = FlagHolder.off();
    private FallingBlockRenderer blockLogo;
    private final LogoRenderer imageLogo;
    private final UniqueArrayList<DynamicWidget<?, ?>> empty = new UniqueArrayList();
    private final UniqueArrayList<DynamicWidget<?, ?>> widgets = new UniqueArrayList();
    private final TitleWidgets titleWidgets = new TitleWidgets(this);
    private final TitleScreenAccess titleAccess;
    private boolean isLayoutSet;

    public NostalgicTitleScreen() {
        this.blockLogo = new FallingBlockRenderer();
        this.imageLogo = new LogoRenderer(false);
        this.titleAccess = (TitleScreenAccess)((Object)this);
        if (((Boolean)CandyTweak.USE_CUSTOM_FALLING_LOGO.get()).booleanValue()) {
            if (FallingBlockConfig.read()) {
                NostalgicTweaks.LOGGER.debug("[Falling Blocks] Successfully read config into title screen");
            } else {
                NostalgicTweaks.LOGGER.warn("[Falling Blocks] The falling blocks config is corrupt!");
            }
            if (FallingBlockConfig.hasNoBlocks()) {
                FallingBlockConfig.setBlockDataToDefault();
                NostalgicTweaks.LOGGER.warn("[Falling Blocks] The falling blocks config is empty! Showing default logo.");
            }
            this.blockLogo = new FallingBlockRenderer(FallingBlockConfig.getData());
        }
    }

    public TitleLayout getLayout() {
        return (TitleLayout)CandyTweak.TITLE_BUTTON_LAYOUT.get();
    }

    public void resetBlockLogo() {
        if (((Boolean)CandyTweak.USE_CUSTOM_FALLING_LOGO.get()).booleanValue()) {
            if (FallingBlockConfig.hasNoBlocks()) {
                FallingBlockConfig.setBlockDataToDefault();
            }
            this.blockLogo = new FallingBlockRenderer(FallingBlockConfig.getData());
        } else {
            this.blockLogo = new FallingBlockRenderer();
        }
    }

    public void switchLogo() {
        if (!((Boolean)CandyTweak.CLICK_ON_LOGO_TOGGLE.get()).booleanValue()) {
            return;
        }
        TOGGLE_LOGO.toggle();
        this.resetBlockLogo();
    }

    protected void init() {
        super.init();
        if (this.getLayout() != TitleLayout.MODERN) {
            this.clearWidgets();
        }
        this.titleWidgets.init();
        for (Renderable widget : this.renderables) {
            SpriteIconButton iconButton;
            SpriteIconButton iconButton2;
            if (widget instanceof SpriteIconButton && (iconButton2 = (SpriteIconButton)widget).getX() == this.width / 2 - 124) {
                iconButton2.visible = (Boolean)CandyTweak.REMOVE_TITLE_LANGUAGE_BUTTON.get() == false;
                continue;
            }
            if (widget instanceof SpriteIconButton && (iconButton = (SpriteIconButton)widget).getX() == this.width / 2 + 104) {
                iconButton.visible = (Boolean)CandyTweak.REMOVE_TITLE_ACCESSIBILITY_BUTTON.get() == false;
                continue;
            }
            if (!(widget instanceof Button)) continue;
            Button button = (Button)widget;
            boolean isRealms = button.getMessage().getString().equals(Lang.Vanilla.MENU_ONLINE.getString(new Object[0]));
            boolean isRemovable = (Boolean)CandyTweak.REMOVE_TITLE_REALMS_BUTTON.get();
            button.visible = !isRealms || !isRemovable;
        }
    }

    @Override
    public NostalgicTitleScreen self() {
        return this;
    }

    @Override
    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets() {
        return this.widgets;
    }

    @Override
    @Nullable
    public Screen getParentScreen() {
        return null;
    }

    public List<? extends GuiEventListener> children() {
        return this.getLayout() == TitleLayout.MODERN ? this.children : this.empty;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft == null) {
            return false;
        }
        if (keyCode == 77) {
            this.minecraft.setScreen((Screen)new NostalgicTitleScreen());
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.getLayout() != TitleLayout.MODERN && !this.isLayoutSet) {
            if (((Boolean)CandyTweak.REMOVE_EXTRA_TITLE_BUTTONS.get()).booleanValue()) {
                this.clearWidgets();
                this.init();
            }
            this.isLayoutSet = true;
        }
        if (((Boolean)CandyTweak.OLD_TITLE_BACKGROUND.get()).booleanValue()) {
            if (((Boolean)CandyTweak.OLD_DIRT_SCREEN_BACKGROUND.get()).booleanValue()) {
                this.renderMenuBackground(graphics);
            } else {
                GuiUtil.renderDirtBackground(graphics);
            }
        } else {
            this.renderPanorama(graphics, PartialTick.realtime());
        }
        if (this.minecraft == null || this.minecraft.getOverlay() != null) {
            return;
        }
        if (FallingBlockConfig.LOGO_CHANGED.ifEnabledThenDisable() || FallingBlockText.LOGO_CHANGED.ifEnabledThenDisable()) {
            this.resetBlockLogo();
        }
        if (((Boolean)CandyTweak.OLD_ALPHA_LOGO.get()).booleanValue()) {
            if (((Boolean)TOGGLE_LOGO.get()).booleanValue()) {
                this.imageLogo.renderLogo(graphics, this.width, 1.0f);
            } else {
                this.blockLogo.render();
            }
        } else if (((Boolean)TOGGLE_LOGO.get()).booleanValue()) {
            this.blockLogo.render();
        } else {
            this.imageLogo.renderLogo(graphics, this.width, 1.0f);
        }
        if (this.titleAccess.nt$getSplash() != null) {
            graphics.pose().pushPose();
            graphics.pose().translate((float)((Integer)CandyTweak.SPLASH_OFFSET_X.get()).intValue(), (float)((Integer)CandyTweak.SPLASH_OFFSET_Y.get()).intValue(), 0.0f);
            this.titleAccess.nt$getSplash().render(graphics, this.width, this.font, 0xFFFF00);
            graphics.pose().popPose();
        }
        MutableComponent copyright = switch (this.getLayout()) {
            case TitleLayout.ALPHA -> Lang.Title.COPYRIGHT_ALPHA.get(new Object[0]);
            case TitleLayout.BETA -> Lang.Title.COPYRIGHT_BETA.get(new Object[0]);
            default -> Component.translatable((String)"title.credits");
        };
        Object minecraft = CandyTweak.TITLE_VERSION_TEXT.parse(GameUtil.getVersion());
        if (Minecraft.checkModStatus().shouldReportAsModified() && !((Boolean)CandyTweak.REMOVE_TITLE_MOD_LOADER_TEXT.get()).booleanValue()) {
            minecraft = (String)minecraft + "/" + this.minecraft.getVersionType() + Lang.Vanilla.MENU_MODDED.getString(new Object[0]);
        }
        int versionColor = (Boolean)CandyTweak.OLD_TITLE_BACKGROUND.get() != false && !((String)minecraft).contains("\u00a7") ? 0x505050 : 0xFFFFFF;
        int height = (Boolean)CandyTweak.TITLE_BOTTOM_LEFT_TEXT.get() != false ? this.height - 10 : 2;
        graphics.drawString(this.font, (String)minecraft, 2, height, versionColor);
        graphics.drawString(this.font, (Component)copyright, this.width - this.font.width((FormattedText)copyright) - 2, this.height - 10, 0xFFFFFF);
        if (((Boolean)CandyTweak.TITLE_TOP_RIGHT_DEBUG_TEXT.get()).booleanValue()) {
            long max = Runtime.getRuntime().maxMemory();
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long used = total - free;
            String memory = String.format("Free memory: %s%% of %sMB", used * 100L / max, MathUtil.bytesToMegabytes(max));
            String allocated = String.format("Allocated memory: %s%% (%sMB)", total * 100L / max, MathUtil.bytesToMegabytes(total));
            int memX = this.width - this.font.width(memory) - 2;
            int allX = this.width - this.font.width(allocated) - 2;
            graphics.drawString(this.font, memory, memX, 2, 0x808080);
            graphics.drawString(this.font, allocated, allX, GuiUtil.textHeight() + 3, 0x808080);
        }
        if (this.getLayout() != TitleLayout.MODERN) {
            DynamicWidget.render(this.widgets, graphics, mouseX, mouseY, partialTick);
        } else {
            this.renderables.forEach(renderable -> renderable.render(graphics, mouseX, mouseY, partialTick));
        }
        RenderSystem.enableDepthTest();
        if (this.titleAccess.nt$getRealmsNotificationsEnabled() && this.getLayout() == TitleLayout.MODERN) {
            this.titleAccess.nt$getRealmsNotificationsScreen().render(graphics, mouseX, mouseY, partialTick);
        }
    }
}

