/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.progress;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.progress.StoringChunkProgressListener;

public abstract class ProgressRenderer {
    public static void drawHeaderText(GuiGraphics graphics, Component header, int width) {
        graphics.drawCenteredString(GuiUtil.font(), header, width / 2, GuiUtil.getGuiHeight() / 2 - 4 - 16, 0xFFFFFF);
    }

    public static void drawStageText(GuiGraphics graphics, Component stage, int width) {
        graphics.drawCenteredString(GuiUtil.font(), stage, width / 2, GuiUtil.getGuiHeight() / 2 - 4 + 8, 0xFFFFFF);
    }

    public static void renderProgressWithChunks(StoringChunkProgressListener progressListener) {
        ProgressRenderer.render(progressListener.getProgress());
    }

    public static void renderProgressWithInt(int progress) {
        ProgressRenderer.render(progress);
    }

    private static void render(int progress) {
        Window window = GuiUtil.getWindow();
        int xOffset = 100;
        int yOffset = 2;
        int xStart = window.getGuiScaledWidth() / 2 - xOffset / 2;
        int yStart = window.getGuiScaledHeight() / 2 + 16;
        if (progress >= xOffset) {
            progress = xOffset;
        }
        BufferBuilder builder = RenderUtil.getAndBeginFill();
        Color background = new Color(128, 128, 128);
        Color foreground = new Color(128, 255, 128);
        RenderUtil.fill((VertexConsumer)builder, (float)xStart, (float)yStart, (float)(xStart + xOffset), (float)(yStart + yOffset), background.get());
        RenderUtil.fill((VertexConsumer)builder, (float)xStart, (float)yStart, (float)(xStart + progress), (float)(yStart + yOffset), foreground.get());
        RenderUtil.endFill(builder);
    }
}

