/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.vanilla.progress;

import mod.adrenix.nostalgic.client.gui.screen.vanilla.progress.ProgressRenderer;
import mod.adrenix.nostalgic.mixin.access.ProgressScreenAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NostalgicProgressScreen
extends ProgressScreen
implements ProgressListener {
    public static final NullableHolder<ResourceKey<Level>> PREVIOUS_DIMENSION = NullableHolder.empty();
    public static final NullableHolder<ResourceKey<Level>> CURRENT_DIMENSION = NullableHolder.empty();
    @Nullable
    private Component header;
    @Nullable
    private Component stage;
    private int progress = -1;
    private boolean stop = false;
    private final ProgressScreenAccess progressScreen;

    public NostalgicProgressScreen(ProgressScreen progressScreen) {
        super(((ProgressScreenAccess)progressScreen).nt$clearScreenAfterStop());
        this.progressScreen = (ProgressScreenAccess)progressScreen;
    }

    public void setHeader(@Nullable Component header) {
        this.header = header;
    }

    public void setStage(@Nullable Component stage) {
        this.stage = stage;
    }

    public boolean hasStage() {
        return this.stage != null;
    }

    private void setHeaderAndStage() {
        boolean isChangingLevel;
        if (this.minecraft == null) {
            return;
        }
        if (this.header != null && this.header.getString().equals(Lang.Vanilla.SAVE_LEVEL.getString(new Object[0]))) {
            this.setHeader(null);
            this.setStage((Component)Lang.Level.SAVING.get(new Object[0]));
        }
        ResourceKey<Level> currentDimension = CURRENT_DIMENSION.get();
        ResourceKey<Level> previousDimension = PREVIOUS_DIMENSION.get();
        boolean isTextNeeded = this.header == null && this.stage == null;
        boolean isMultiplayer = this.minecraft.getConnection() != null;
        boolean isConnectedLevel = this.minecraft.level != null && isMultiplayer;
        boolean bl = isChangingLevel = this.minecraft.player != null && currentDimension != null && previousDimension != null;
        if (isTextNeeded && (!isMultiplayer || isConnectedLevel) && isChangingLevel) {
            if (currentDimension == Level.NETHER) {
                this.setHeader((Component)Lang.Level.ENTER_NETHER.get(new Object[0]));
                this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
            } else if (currentDimension == Level.END) {
                this.setHeader((Component)Lang.Level.ENTER_END.get(new Object[0]));
                this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
            } else if (currentDimension == Level.OVERWORLD) {
                if (previousDimension == Level.NETHER) {
                    this.setHeader((Component)Lang.Level.LEAVING_NETHER.get(new Object[0]));
                    this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
                } else if (previousDimension == Level.END) {
                    this.setHeader((Component)Lang.Level.LEAVING_END.get(new Object[0]));
                    this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
                }
            }
            if (this.stage == null) {
                this.setHeader((Component)Lang.Level.LOADING.get(new Object[0]));
                this.setStage((Component)Lang.Level.BUILDING.get(new Object[0]));
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void stop() {
        this.stop = true;
    }

    public void removed() {
        this.stop();
    }

    public void tick() {
        if (this.progress < 100) {
            ++this.progress;
        }
        super.tick();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft == null) {
            return;
        }
        if (this.stop || this.progressScreen.nt$stop()) {
            if (this.progressScreen.nt$clearScreenAfterStop()) {
                this.minecraft.setScreen(null);
            }
            return;
        }
        this.setHeaderAndStage();
        if (this.header == null && this.stage == null) {
            return;
        }
        if (((Boolean)CandyTweak.OLD_DIRT_SCREEN_BACKGROUND.get()).booleanValue()) {
            GuiUtil.renderDirtBackground(graphics);
        } else {
            this.renderPanorama(graphics, partialTick);
            this.renderBlurredBackground(partialTick);
            this.renderMenuBackground(graphics);
        }
        ProgressRenderer.renderProgressWithInt(this.progress);
        if (this.header != null) {
            ProgressRenderer.drawHeaderText(graphics, this.header, this.width);
        }
        if (this.stage != null) {
            ProgressRenderer.drawStageText(graphics, this.stage, this.width);
        }
    }

    public void progressStartNoAbort(Component component) {
        this.progressStart(component);
    }

    public void progressStart(Component header) {
        this.setHeader(header);
        this.progressStage((Component)Component.translatable((String)"menu.working"));
    }

    public void progressStage(Component stage) {
        this.setStage(stage);
        this.progressStagePercentage(0);
    }

    public void progressStagePercentage(int progress) {
        this.progress = progress;
    }
}

