/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter;

import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.GearSpinner;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.GithubJson;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.PlayerText;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.SupporterOverlay;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.Row;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.gui.LinkUtil;
import mod.adrenix.nostalgic.util.client.renderer.InternetTexture;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.CycleIndex;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.Holder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.function.FloatSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

class SupporterRow {
    private final LinkedHashSet<DynamicWidget<?, ?>> widgets;
    private final GithubJson.Supporter supporter;
    private final Row row;
    private final RowList rowList;
    private final Overlay overlay;
    private final IconWidget face;
    private final PlayerText text;
    private final String name;

    SupporterRow(SupporterOverlay overlay, String name, GithubJson.Supporter supporter) {
        this.name = name;
        this.supporter = supporter;
        this.overlay = overlay.overlay;
        this.rowList = overlay.rowList;
        this.row = (Row)Row.create(overlay.rowList).build();
        this.widgets = new LinkedHashSet();
        this.face = (IconWidget)((IconFactory)IconWidget.create(this::getFaceIcon).size(8)).emptySize(8).build(List.of(this.row::addWidget, this.widgets::add));
        this.text = new PlayerText(Holder.create(this.face), NullableHolder.empty(), NullableHolder.empty());
        this.setPlayerName();
        this.setBackground();
        if (this.supporter.member) {
            ((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconWidget.create(Icons.KOFI).size(GuiUtil.textHeight())).tooltip(Lang.Home.KOFI_MEMBER, 45, 500L, TimeUnit.MILLISECONDS)).alignVerticalTo(this.face, -1)).rightOf(this.text.last().orElse(this.text.name().get()), 4)).build(this.row::addWidget);
        }
        if (this.supporter.description != null) {
            ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(this.supporter.description).extendWidthToEnd(this.row, 0)).alignFlushTo(this.text.first().orElse(this.text.name().get()))).below(this.text.first().orElse(this.text.name().get()), 2)).build(List.of(this.row::addWidget, this.widgets::add));
        }
        if (this.supporter.twitter != null) {
            this.makeLink(this.supporter.twitter, Icons.TWITTER);
        }
        if (this.supporter.youtube != null) {
            this.makeLink(this.supporter.youtube, Icons.YOUTUBE);
        }
        if (this.supporter.twitch != null) {
            this.makeLink(this.supporter.twitch, Icons.TWITCH);
        }
        for (String link : this.supporter.links) {
            this.makeLink(link, Icons.CIRCLE_EARTH);
        }
        this.rowList.addBottomRow(this.row);
    }

    private void makeLink(String link, TextureIcon texture) {
        IconWidget icon = (IconWidget)((IconFactory)((IconFactory)((IconFactory)IconWidget.create(texture).size(GuiUtil.textHeight())).alignFlushTo(this.text.first().orElse(this.text.name().get()))).belowAll(this.widgets, 2)).build(List.of(this.row::addWidget, this.widgets::add));
        ((TextBuilder)((TextBuilder)TextWidget.create(link).rightOf(icon, 4)).alignVerticalTo(icon)).onPress(LinkUtil.onPress(link), Color.FRENCH_SKY_BLUE).useTextWidth(this.rowList::getRowEndX).build(List.of(this.row::addWidget, this.widgets::add));
    }

    private TextureIcon getFaceIcon() {
        if (SupporterOverlay.FACES.containsKey(this.name)) {
            TextureIcon textureIcon;
            block9: {
                InternetTexture face = SupporterOverlay.FACES.get(this.name).texture();
                try {
                    textureIcon = face.getTextureLocation().map(TextureIcon::fromTexture).orElse(Icons.STEVE);
                    if (face == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (face != null) {
                            try {
                                face.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        NostalgicTweaks.LOGGER.error("[Internet Texture] Could not retrieve texture\n%s", exception);
                    }
                }
                face.close();
            }
            return textureIcon;
        }
        return Icons.STEVE;
    }

    private void setPlayerName() {
        switch (this.name) {
            case "Adrenix": {
                this.setTextAdrenix();
                break;
            }
            case "PoeticRainbow": {
                this.setTextPoeticRainbow();
                break;
            }
            case "Captain_3": {
                this.setTextCaptain3();
                break;
            }
            default: {
                ((TextBuilder)((TextBuilder)TextWidget.create((Component)new Color(this.supporter.color).apply(this.name)).useTextWidth().rightOf(this.face, 4)).alignVerticalTo(this.face)).build(List.of(this.row::addWidget, this.text.name()::set));
            }
        }
    }

    private void setTextAdrenix() {
        Animation animation = Animate.linear(2L, TimeUnit.SECONDS);
        IntSupplier color = () -> {
            animation.playOrRewind();
            return Color.HSBtoRGB(360.0f, 1.0f, Mth.lerp((float)((float)animation.getValue()), (float)0.4f, (float)1.0f));
        };
        TextWidget text = (TextWidget)((TextBuilder)((TextBuilder)TextWidget.create(this.name).useTextWidth().rightOf(this.face, 4)).alignVerticalTo(this.face)).color(color).build(List.of(this.row::addWidget, this.text.name()::set));
        ((BlankBuilder)((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().size(10, 9)).rightOf(text, 2)).alignVerticalTo(text)).tooltip(Lang.Home.MOD_CREATOR, 45, 500L, TimeUnit.MILLISECONDS)).renderer((widget, graphics, mouseX, mouseY, partialTick) -> {
            GearSpinner.getInstance().render(graphics, 0.019f, widget.getX(), widget.getY() - 1);
            String splash = "N.T";
            float scale = 1.8f - Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            scale = scale * 4.0f / (float)GuiUtil.font().width(splash);
            graphics.pose().pushPose();
            graphics.pose().translate((float)(widget.getX() + 3), (float)(widget.getY() + 5), 0.0f);
            graphics.pose().mulPose(Axis.ZP.rotationDegrees(-20.0f));
            graphics.pose().scale(scale, scale, scale);
            DrawText.begin(graphics, splash).color(Color.YELLOW).draw();
            graphics.pose().popPose();
        }).build(this.row::addWidget);
        this.overlay.runOnClose(animation::stop);
    }

    private void setTextPoeticRainbow() {
        Animation animation = Animate.linear(2L, TimeUnit.SECONDS);
        CollectionUtil.forLoop(Arrays.stream(this.name.split("")), (letter, index) -> {
            float offset = (float)index.intValue() / (float)this.name.length();
            TextWidget widget = (TextWidget)((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(letter).rightOf((DynamicWidget)this.text.last().orElse(this.face), this.text.last().isEmpty() ? 4 : 0)).alignVerticalTo(this.face)).width(GuiUtil.font().width(letter))).color(() -> {
                if (animation.isFinished()) {
                    animation.reset();
                    animation.tick();
                }
                animation.play();
                float degrees = 360.0f * (1.0f - (float)animation.getValue() + offset);
                float hsb = MathUtil.normalizeInRange(degrees, 0.0f, 360.0f);
                return Color.HSBtoRGB(hsb / 360.0f, 1.0f, 1.0f);
            }).build(List.of(this.row::addWidget, this.text.last()::set));
            if (index == 0) {
                this.text.first().set(widget);
            }
        });
        this.overlay.runOnClose(animation::stop);
    }

    private void setTextCaptain3() {
        Animation animation = Animate.linear(100L, TimeUnit.MILLISECONDS);
        CycleIndex cycleIndex = new CycleIndex(this.name.split(""), true);
        CollectionUtil.forLoop(Arrays.stream(this.name.split("")), (letter, index) -> {
            TextWidget widget = (TextWidget)((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create((Component)new Color(this.supporter.color).apply((String)letter)).rightOf((DynamicWidget)this.text.last().orElse(this.face), this.text.last().isEmpty() ? 4 : 0)).alignVerticalTo(this.face)).width(GuiUtil.font().width(letter))).posY(() -> {
                if (animation.isFinished()) {
                    animation.reset();
                    cycleIndex.cycle();
                }
                animation.play();
                return this.face.getY() + (cycleIndex.get() == index.intValue() ? -1 : 0);
            })).build(List.of(this.row::addWidget, this.text.last()::set));
            if (index == 0) {
                this.text.first().set(widget);
            }
        });
        this.overlay.runOnClose(animation::stop);
    }

    private void setBackground() {
        switch (this.name) {
            case "Adrenix": {
                this.setBackgroundAdrenix();
                break;
            }
            case "SalC1": {
                this.setBackgroundSalC1();
            }
        }
    }

    private void setBackgroundAdrenix() {
        int posX = -4;
        int offset = 4;
        int minRand = 8;
        int maxRand = 18;
        for (int i = 0; i < 6; ++i) {
            Animation animation = Animate.easeInOutCircular(MathUtil.randomInt(8, 18), TimeUnit.SECONDS);
            FloatSupplier random = () -> (float)MathUtil.randomInt(0, 100) / 100.0f;
            Holder<Float> randX = Holder.create(Float.valueOf(random.getAsFloat()));
            Holder<Float> randY = Holder.create(Float.valueOf(random.getAsFloat()));
            IntSupplier posY = () -> (int)(((Float)randY.get()).floatValue() * (float)this.row.getHeight()) + this.face.getY() - 2;
            ((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().size(3, 1)).posX(-4)).posY(posY)).renderer((widget, graphics, mouseX, mouseY, partialTick) -> {
                if (animation.isFinished()) {
                    animation.reset();
                }
                animation.play();
                int x = (int)Mth.lerp((double)animation.getValue(), (double)-4.0, (double)(this.rowList.getRowEndX() + 4));
                int y = posY.getAsInt();
                widget.pos(x, y);
                if (widget.getX() >= this.rowList.getRowEndX() + 4) {
                    randX.set(Float.valueOf(random.getAsFloat()));
                    randY.set(Float.valueOf(random.getAsFloat()));
                    widget.pos(-4, posY.getAsInt());
                    animation.setDuration(MathUtil.randomInt(8, 18), TimeUnit.SECONDS);
                    animation.stop();
                    return;
                }
                int x0 = widget.getX();
                int y0 = widget.getY();
                int x1 = widget.getEndX();
                int y1 = widget.getEndY();
                RenderUtil.fill(graphics, (float)x0, (float)y0, (float)(x1 + 2), (float)y1, Color.RED.fromAlpha(0.3f));
            }).build(this.row::addWidget);
            this.overlay.runOnClose(animation::stop);
        }
    }

    private void setBackgroundSalC1() {
        Animation animation = Animate.linear(2L, TimeUnit.SECONDS);
        for (int i = 0; i < 24; ++i) {
            FloatSupplier random = () -> (float)MathUtil.randomInt(0, 100) / 100.0f;
            Holder<Float> randX = Holder.create(Float.valueOf(random.getAsFloat()));
            Holder<Float> randY = Holder.create(Float.valueOf(random.getAsFloat()));
            IntSupplier posX = () -> (int)(((Float)randX.get()).floatValue() * (float)this.rowList.getRowWidth()) + this.face.getX() - 4;
            IntSupplier posY = () -> (int)(((Float)randY.get()).floatValue() * (float)this.row.getHeight()) + this.face.getY() - 2;
            ((BlankBuilder)((BlankBuilder)BlankWidget.create().size(1)).pos(posX, posY)).renderer((widget, graphics, mouseX, mouseY, partialTick) -> {
                if (animation.isFinished()) {
                    if (animation.wentBackward()) {
                        animation.play();
                    }
                    if (animation.wentForward()) {
                        animation.rewind();
                    }
                }
                if (animation.getValue() == 1.0) {
                    randX.set(Float.valueOf(random.getAsFloat()));
                    randY.set(Float.valueOf(random.getAsFloat()));
                    widget.pos(posX.getAsInt(), posY.getAsInt());
                }
                int x0 = widget.getX();
                int y0 = widget.getY();
                int x1 = widget.getEndX();
                int y1 = widget.getEndY();
                RenderUtil.fill(graphics, (float)x0, (float)y0, (float)x1, (float)y1, Color.WHITE.fromAlpha(1.0f - (float)animation.getValue()));
            }).build(this.row::addWidget);
        }
        this.overlay.runOnClose(animation::stop);
    }
}

