/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.home.overlay;

import dev.architectury.platform.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageOverlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.info.MessageType;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;

public abstract class SodiumOverlay {
    public static final FlagHolder OPENED = FlagHolder.off();
    public static final String CLOUDS_MIXIN_PROPERTY = "mixin.features.render.world.clouds=false";

    public static Overlay open() {
        Overlay overlay = SodiumOverlay.getOverlay();
        OPENED.enable();
        overlay.runOnClose(OPENED::disable);
        return overlay.open();
    }

    private static Overlay getOverlay() {
        int padding = 2;
        Overlay overlay = Overlay.create(Lang.Home.SODIUM_TITLE).icon(Icons.SODIUM).padding(padding).resizeWidthUsingPercentage(0.65).resizeHeightUsingPercentage(0.8).resizeHeightForWidgets().build();
        Group clouds = ((GroupBuilder)Group.create(overlay).icon(Icons.SKY).title(Lang.Home.SODIUM_CLOUDS_TITLE).border(Color.LIGHT_BLUE).extendWidthToScreenEnd(0)).build(overlay::addWidget);
        TextWidget cloudsInfo = ((TextBuilder)TextWidget.create(Lang.Home.SODIUM_CLOUDS_INFO).width(clouds::getInsideWidth)).build(clouds::addWidget);
        TextWidget cloudsOverride = ((TextBuilder)((TextBuilder)TextWidget.create(Lang.Home.SODIUM_CLOUDS_OVERRIDE).below(cloudsInfo, padding * 3)).width(clouds::getInsideWidth)).build(clouds::addWidget);
        TextWidget cloudsRestart = ((TextBuilder)((TextBuilder)TextWidget.create(Lang.Home.SODIUM_CLOUDS_RESTART).below(cloudsOverride, padding * 3)).width(clouds::getInsideWidth)).build(clouds::addWidget);
        SeparatorWidget separateTextAndButtons = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(clouds.getColor()).height(1)).below(cloudsRestart, padding * 2)).width(clouds::getInsideWidth)).build(clouds::addWidget);
        Grid cloudButtons = ((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)clouds, 2).columnSpacing(1).extendWidthToEnd(clouds, clouds.getInsidePaddingX())).below(separateTextAndButtons, padding * 2)).build(clouds::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Home.SODIUM_OPEN_PROPERTIES).icon(Icons.FOLDER)).tooltip(Lang.Home.SODIUM_OPEN_PROPERTIES, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.SODIUM_PROPERTIES, 35)).onPress(SodiumOverlay::openSodiumMixinConfig)).build(cloudButtons::addCell);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Home.SODIUM_COPY_CLOUDS).icon(Icons.CLIPBOARD)).tooltip(Lang.Home.SODIUM_COPY_CLOUDS, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.SODIUM_COPY_PROPERTY, 35)).onPress(() -> Minecraft.getInstance().keyboardHandler.setClipboard(CLOUDS_MIXIN_PROPERTY))).build(cloudButtons::addCell);
        return overlay;
    }

    private static void openSodiumMixinConfig() {
        Path properties = Platform.getConfigFolder().resolve("sodium-mixins.properties");
        if (Files.exists(properties, new LinkOption[0])) {
            Util.getPlatform().openPath(properties);
        } else {
            MessageOverlay.create(MessageType.ERROR, Lang.Home.SODIUM_MISSING_FILE_HEADER, Lang.Home.SODIUM_MISSING_FILE_BODY).addButton(ButtonTemplate.openFolder(Platform.getConfigFolder())).setResizePercentage(0.7).build().open();
        }
    }
}

