/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.home.overlay;

import java.util.function.Consumer;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.state.SwitchGroup;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.network.ModConnection;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.Holder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.text.TextUtil;

public class DebugOverlay {
    private final Overlay overlay;

    public DebugOverlay() {
        int padding = 2;
        this.overlay = Overlay.create(Lang.Home.DEBUG).icon(Icons.BUG).padding(padding).resizeUsingPercentage(0.6).build();
        Group toggle = ((GroupBuilder)Group.create(this.overlay).title(Lang.Text.TOGGLE).icon(Icons.BUG).extendWidthToScreenEnd(0)).border(Color.ALERT_RED).build(this.overlay::addWidget);
        Translation debugHead = Lang.Manage.OPERATIONS_DEBUG;
        Translation debugInfo = Lang.Home.DEBUG_SWITCH;
        SwitchGroup.Widgets debugSwitch = SwitchGroup.create((WidgetHolder)toggle, debugHead, debugInfo, NostalgicTweaks::isDebugging, NostalgicTweaks.LOGGER::setDebug).getWidgets();
        ((TextBuilder)debugSwitch.header().getBuilder()).extendWidthToEnd(toggle, toggle.getInsidePaddingX());
        ((TextBuilder)debugSwitch.description().getBuilder()).extendWidthToEnd(toggle, toggle.getInsidePaddingX());
        debugSwitch.subscribeTo(toggle);
        SeparatorWidget toggleSeparator = ((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(toggle.getColor()).below(debugSwitch.description(), padding * 2)).width(toggle::getInsideWidth)).build(toggle::addWidget);
        Translation fpsHead = Lang.Home.FPS_SWITCH;
        Translation fpsInfo = Lang.Home.FPS_INFO;
        SwitchGroup.Widgets fpsSwitch = SwitchGroup.create((WidgetHolder)toggle, fpsHead, fpsInfo, GuiUtil::isShowingFps, GuiUtil::setShowFps).getWidgets();
        ((ButtonBuilder)fpsSwitch.toggle().getBuilder()).below(toggleSeparator, padding * 2);
        ((TextBuilder)fpsSwitch.header().getBuilder()).extendWidthToEnd(toggle, toggle.getInsidePaddingX());
        ((TextBuilder)fpsSwitch.description().getBuilder()).extendWidthToEnd(toggle, toggle.getInsidePaddingX());
        fpsSwitch.subscribeTo(toggle);
        ModConnection connection = NostalgicTweaks.getConnection().orElseGet(ModConnection::disconnected);
        Group details = ((GroupBuilder)((GroupBuilder)Group.create(this.overlay).title(Lang.Home.DEBUG_INFO).icon(Icons.CLIPBOARD).extendWidthToScreenEnd(0)).below(toggle, padding)).border(Color.DEER_BROWN).build(this.overlay::addWidget);
        TextWidget shortcut = ((TextBuilder)TextWidget.create(Lang.Home.DEBUG_SHORTCUT).width(details::getInsideWidth)).build(details::addWidget);
        Holder<TextWidget> text = Holder.create(shortcut);
        NullableHolder<TextWidget> separator = NullableHolder.create(((TextBuilder)((TextBuilder)TextWidget.create("Mod Loader").centerAligned().color(Color.NOSTALGIC_GRAY).separator(details.getColor()).below(shortcut, padding * 2)).width(details::getInsideWidth)).build(details::addWidget));
        Consumer<String> debug = output -> {
            DynamicWidget below = separator.orElse((TextWidget)((DynamicWidget)text.get()));
            text.set(((TextBuilder)((TextBuilder)TextWidget.create(output).below(below, separator.isPresent() ? padding * 2 : padding)).width(details::getInsideWidth)).build(details::addWidget));
            separator.set(null);
        };
        Consumer<String> separate = title -> separator.set(((TextBuilder)((TextBuilder)TextWidget.create(title).centerAligned().color(Color.NOSTALGIC_GRAY).separator(details.getColor()).below((DynamicWidget)text.get(), padding * 2)).width(details::getInsideWidth)).build(details::addWidget));
        debug.accept(String.format("Loader: \u00a7d%s", NostalgicTweaks.getLoader()));
        debug.accept(String.format("Version: \u00a7e%s", NostalgicTweaks.getShortVersion()));
        debug.accept(String.format("Protocol: \u00a7b%s", "3.1"));
        separate.accept("Network");
        debug.accept(this.getColored("Singleplayer: %s", NetUtil.isSingleplayer()));
        debug.accept(this.getColored("Multiplayer: %s", NetUtil.isMultiplayer()));
        debug.accept(this.getColored("Connected: %s", NetUtil.isConnected()));
        debug.accept(this.getColored("Operator: %s", NetUtil.isPlayerOp()));
        debug.accept(this.getColored("Verified: %s", NostalgicTweaks.isNetworkVerified()));
        debug.accept(this.getColored("Local Host: %s", NetUtil.isLocalHost()));
        separate.accept("Server");
        debug.accept(String.format("Server Protocol: \u00a7b%s", connection.getProtocol()));
        debug.accept(String.format("Server Version: \u00a7e%s", connection.getVersion()));
        debug.accept(String.format("Server Loader: \u00a7d%s", connection.getLoader()));
        debug.accept(this.getColored("Connected: %s", NostalgicTweaks.getConnection().isPresent()));
        separate.accept("Mod Tracker");
        for (ModTracker tracker : ModTracker.values()) {
            debug.accept(this.getColored(TextUtil.toTitleCase(tracker.toString() + ": %s"), tracker.isInstalled()));
        }
    }

    public void open() {
        this.overlay.open();
    }

    private String getColored(String format, Object value) {
        String colored = String.format("\u00a7f%s", value);
        if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            colored = String.format("%s%s", flag != false ? "\u00a72" : "\u00a74", value);
        }
        return String.format(format, colored);
    }
}

