/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.home;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.screen.WidgetManager;
import mod.adrenix.nostalgic.client.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.gui.screen.home.HomeScreen;
import mod.adrenix.nostalgic.client.gui.screen.home.Panorama;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.DebugOverlay;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.SetupOverlay;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.SodiumOverlay;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.SupporterOverlay;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.warning.WarningBanner;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.warning.WarningOverlay;
import mod.adrenix.nostalgic.client.gui.screen.packs.PacksListScreen;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.gui.LinkUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderPass;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.timer.FlagTimer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class HomeWidgets
implements WidgetManager {
    private final HomeScreen homeScreen;
    private final IconFactory heartOutline;
    private final FlagTimer flashTimer;

    HomeWidgets(HomeScreen homeScreen) {
        this.homeScreen = homeScreen;
        this.flashTimer = FlagTimer.create(1L, TimeUnit.SECONDS).build();
        this.heartOutline = (IconFactory)((IconFactory)((IconFactory)IconWidget.create(Icons.HEART_OUTLINE).cannotFocus()).renderWhen(RenderPass.LAST)).size(12);
    }

    @Override
    public void init() {
        int sectionMargin = 0;
        int sectionOffset = 6;
        ButtonWidget config = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Enum.SCREEN_CONFIG).icon(Icons.MECHANICAL_TOOLS)).useTextWidth()).alignLeft(sectionOffset)).onPress(() -> Minecraft.getInstance().setScreen((Screen)new ConfigScreen(this.homeScreen)))).backgroundRenderer(this::renderLeftTransparent)).build(this.homeScreen::addWidget);
        ButtonWidget presets = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Enum.SCREEN_PACKS).icon(Icons.ZIP_FILE)).alignFlushTo(config)).below(config, sectionMargin)).useTextWidth()).alignLeft(sectionOffset)).onPress(() -> Minecraft.getInstance().setScreen((Screen)new PacksListScreen(this.homeScreen)))).backgroundRenderer(this::renderLeftTransparent)).build(this.homeScreen::addWidget);
        ButtonWidget discord = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Home.DISCORD).icon(Icons.DISCORD)).alignFlushTo(presets)).below(presets, sectionMargin)).useTextWidth()).alignLeft(sectionOffset)).onPress(LinkUtil.onPress("https://discord.gg/Un7b9AWSsu"))).backgroundRenderer(this::renderLeftTransparent)).build(this.homeScreen::addWidget);
        ButtonWidget kofi = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Home.KOFI).icon(Icons.KOFI)).alignFlushTo(discord)).below(discord, sectionMargin)).useTextWidth()).alignLeft(sectionOffset)).onPress(LinkUtil.onPress("https://ko-fi.com/adrenix"))).backgroundRenderer(this::renderLeftTransparent)).build(this.homeScreen::addWidget);
        ButtonWidget golden = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Home.GOLDEN_DAYS).icon(Icons.GOLDEN_DAYS)).alignFlushTo(kofi)).below(kofi, sectionMargin)).useTextWidth()).alignLeft(sectionOffset)).onPress(LinkUtil.onPress("https://github.com/PoeticRainbow/golden-days/releases"))).backgroundRenderer(this::renderLeftTransparent)).build(this.homeScreen::addWidget);
        SeparatorWidget separator = ((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(Color.WHITE).height(1)).below(golden, 2)).build(this.homeScreen::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Affirm.QUIT_CANCEL).icon(Icons.GO_BACK)).alignFlushTo(golden)).below(separator, 1)).useTextWidth()).alignLeft(sectionOffset)).onPress(this.homeScreen::onClose)).backgroundRenderer(this::renderLeftTransparent)).build(this.homeScreen::addWidget);
        List extended = this.homeScreen.getWidgets().stream().toList();
        this.homeScreen.getWidgets().stream().map(DynamicWidget::getBuilder).forEach(builder -> {
            if (builder instanceof LayoutBuilder) {
                LayoutBuilder layout = (LayoutBuilder)((Object)builder);
                layout.extendWidthToLargest(extended);
            }
        });
        ((ButtonBuilder)config.getBuilder()).posY(() -> {
            int spacing = (extended.size() - 1) * (20 + sectionMargin);
            return Math.round(MathUtil.center(spacing - sectionMargin, GuiUtil.getGuiHeight()));
        });
        IconWidget panoramaLast = ((IconFactory)((IconFactory)((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.button(Icons.SMALL_REWIND, Icons.SMALL_REWIND_HOVER, Icons.SMALL_REWIND_OFF).posX(38)).fromScreenEndY(3)).cannotFocus()).tooltip(Lang.Home.PREV_PANORAMA, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Home.PREV_PANORAMA_INFO, 35)).visibleIf(() -> Minecraft.getInstance().level == null)).onPress(Panorama::backward).build(this.homeScreen::addWidget);
        Supplier<TextureIcon> cycleIcon = () -> this.getPlayOrPause(Icons.SMALL_PLAY, Icons.SMALL_PAUSE);
        Supplier<TextureIcon> cycleHover = () -> this.getPlayOrPause(Icons.SMALL_PLAY_HOVER, Icons.SMALL_PAUSE_HOVER);
        Supplier<TextureIcon> cyclePressed = () -> this.getPlayOrPause(Icons.SMALL_PLAY_OFF, Icons.SMALL_PAUSE_OFF);
        IconWidget panoramaCycle = ((IconFactory)((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.button(cycleIcon, cycleHover, cyclePressed).cannotFocus()).rightOf(panoramaLast, 1)).tooltip(Lang.Home.CYCLE_PANORAMA, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Home.CYCLE_PANORAMA_INFO, 35)).visibleIf(() -> Minecraft.getInstance().level == null)).onPress(() -> {
            if (Panorama.isPaused()) {
                Panorama.unpause();
            } else {
                Panorama.pause();
            }
        }).build(this.homeScreen::addWidget);
        ((IconFactory)((IconFactory)((IconFactory)((IconFactory)((IconFactory)IconTemplate.button(Icons.SMALL_NEXT, Icons.SMALL_NEXT_HOVER, Icons.SMALL_NEXT_OFF).cannotFocus()).rightOf(panoramaCycle, 1)).tooltip(Lang.Home.NEXT_PANORAMA, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Home.NEXT_PANORAMA_INFO, 35)).visibleIf(() -> Minecraft.getInstance().level == null)).onPress(Panorama::forward).build(this.homeScreen::addWidget);
        IntegerHolder tabOrder = IntegerHolder.create(4);
        if (ModTracker.SODIUM.isInstalled()) {
            tabOrder.getAndIncrement();
        }
        if (WarningOverlay.isActive()) {
            tabOrder.getAndIncrement();
        }
        ButtonWidget debug = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(Icons.BUG)).tooltip(Lang.Home.DEBUG, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.HOME_DEBUG, 35)).fromScreenEndX(1)).fromScreenEndY(1)).tabOrderGroup(tabOrder.getAndDecrement())).onPress(() -> new DebugOverlay().open())).build(this.homeScreen::addWidget);
        ButtonWidget heart = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(this::getHeart, 12)).tooltip(Lang.Home.SUPPORTERS, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.HOME_SUPPORTERS, 35)).leftOf(debug, 1)).tabOrderGroup(tabOrder.getAndDecrement())).onPress(() -> new SupporterOverlay().open())).build(this.homeScreen::addWidget);
        ((IconFactory)((IconFactory)this.heartOutline.pos(heart::getIconX, heart::getIconY)).visibleIf(heart::isHoveredOrFocused)).build(this.homeScreen::addWidget);
        ButtonWidget init = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(Icons.SAVE_FLOPPY)).tooltip(Lang.Home.INIT_CONFIG, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.HOME_INIT, 35)).leftOf(heart, 1)).tabOrderGroup(tabOrder.getAndDecrement())).onPress(SetupOverlay::open)).build(this.homeScreen::addWidget);
        if (ModTracker.SODIUM.isInstalled()) {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(Icons.SODIUM)).tooltip(Lang.Home.SODIUM_TITLE, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.HOME_SODIUM, 35)).leftOf(init, 1)).tabOrderGroup(tabOrder.getAndDecrement())).onPress(SodiumOverlay::open)).build(this.homeScreen::addWidget);
        }
        if (WarningOverlay.isActive()) {
            ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(Icons.WARNING)).tooltip(Lang.Home.WARNING_OVERLAY, 35, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.HOME_WARNING, 35)).tabOrderGroup(tabOrder.getAndDecrement())).onPress(WarningOverlay::open)).leftOf((DynamicWidget)((UniqueArrayList)this.homeScreen.getWidgets()).getLast(), 1)).build(this.homeScreen::addWidget);
        }
        WarningBanner.setupIfNeeded(this.homeScreen);
        String version = NostalgicTweaks.getTinyVersion();
        String beta = NostalgicTweaks.getBetaVersion();
        ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create("Made by Adrenix\nVersion: v" + version + (String)(beta.isEmpty() ? "" : "-" + beta)).onPress(LinkUtil.onPress("https://github.com/Adrenix/Nostalgic-Tweaks/")).color(Color.fromFormatting(ChatFormatting.GRAY)).useTextWidth().centerAligned().centerInScreenX()).fromScreenEndY(1)).tabOrderGroup(tabOrder.getAndDecrement())).build(this.homeScreen::addWidget);
    }

    private TextureIcon getHeart() {
        if (this.flashTimer.getFlag() && !((Boolean)ModTweak.OPENED_SUPPORTER_SCREEN.get()).booleanValue()) {
            return Icons.HEART_EMPTY;
        }
        return Icons.HEART;
    }

    private TextureIcon getPlayOrPause(TextureIcon play, TextureIcon pause) {
        if (Panorama.isPaused()) {
            return play;
        }
        return pause;
    }

    private void renderLeftTransparent(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Color bar = Color.BLACK.fromAlpha(0.0);
        Color fill = Color.BLACK.fromAlpha(0.6f);
        BufferBuilder builder = RenderUtil.getAndBeginFill();
        if (button.isHoveredOrFocused()) {
            bar.set(Color.LEMON_YELLOW);
            bar.setAlpha(1.0);
            RenderUtil.fill((VertexConsumer)builder, graphics, (float)button.getX(), (float)button.getY(), (float)button.getEndX(), (float)button.getEndY(), fill.get());
        }
        RenderUtil.fill((VertexConsumer)builder, graphics, (float)button.getX(), (float)button.getY(), (float)(button.getX() + 2), (float)button.getEndY(), bar.get());
        RenderUtil.endFill(builder);
    }
}

