/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.tag;

import mod.adrenix.nostalgic.client.gui.screen.config.widget.tag.TagType;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tag.TagWidget;
import mod.adrenix.nostalgic.client.gui.tooltip.Tooltip;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.text.TextWrap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

class Tag {
    private final TagWidget widget;
    private final TagType type;
    private int offset = 0;

    Tag(TagWidget widget, TagType type) {
        this.widget = widget;
        this.type = type;
    }

    static void setFromPrev(Tag prev, Tag next) {
        next.offset = prev.offset + prev.getWidth() + prev.widget.padding;
    }

    public boolean isAlertTag() {
        return this.type == TagType.ALERT;
    }

    public int getX() {
        return this.widget.getX() + this.offset;
    }

    public int getY() {
        return this.widget.getY();
    }

    public int getWidth() {
        return GuiUtil.font().width((FormattedText)this.type.getTitle()) + 3;
    }

    public int getHeight() {
        return this.widget.getHeight();
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.isWithinBox(mouseX, mouseY, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setTooltip(int mouseX, int mouseY) {
        boolean isHovered = this.widget.isHoveredOrFocused();
        boolean isMouseOver = this.isMouseOver(mouseX, mouseY);
        boolean isTooltipOn = (Boolean)ModTweak.DISPLAY_TAG_TOOLTIPS.get();
        if (!(isMouseOver && isTooltipOn && isHovered)) {
            return;
        }
        MutableComponent tooltip = switch (this.type) {
            default -> throw new MatchException(null, null);
            case TagType.NEW -> Lang.Tag.NEW_TOOLTIP.get(new Object[0]);
            case TagType.CLIENT -> Lang.Tag.CLIENT_TOOLTIP.get(new Object[0]);
            case TagType.SERVER -> Lang.Tag.SERVER_TOOLTIP.get(new Object[0]);
            case TagType.DYNAMIC -> Lang.Tag.DYNAMIC_TOOLTIP.get(new Object[0]);
            case TagType.RELOAD -> Lang.Tag.RELOAD_TOOLTIP.get(new Object[0]);
            case TagType.SYNC -> Lang.Tag.SYNC_TOOLTIP.get(new Object[0]);
            case TagType.ALERT -> this.widget.getTweak().getAlertMessage();
            case TagType.WARNING -> this.widget.getTweak().getWarningMessage();
            case TagType.NO_SSO -> this.widget.getTweak().getNoSSOMessage();
        };
        Tooltip.setListTooltip(TextWrap.tooltip((Component)tooltip, 40));
        Tooltip.setMousePosition(mouseX, mouseY);
    }

    public void render(GuiGraphics graphics) {
        int borderX = this.getX();
        int borderY = this.getY();
        int borderEndX = this.getX() + this.getWidth();
        int borderEndY = this.getY() + this.getHeight();
        Color borderColor = this.type.getBorderColor();
        RenderUtil.fill(graphics, (float)borderX, (float)borderY, (float)borderEndX, (float)borderEndY, borderColor);
        int inX = this.getX() + 1;
        int inY = this.getY() + 1;
        int inEndX = this.getX() + this.getWidth() - 1;
        int inEndY = this.getY() + this.getHeight() - 1;
        Color inColor = this.type.getBackgroundColor();
        RenderUtil.fill(graphics, (float)inX, (float)inY, (float)inEndX, (float)inEndY, inColor);
        int titleX = this.getX() + 2;
        int titleY = this.getY() + 2;
        DrawText.begin(graphics, (Component)this.type.getTitle()).pos(titleX, titleY).flat().draw();
    }
}

