/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.list;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.AfterConfigSave;
import mod.adrenix.nostalgic.client.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.StatusOverlay;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.crumb.CrumbBuilder;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.crumb.CrumbWidget;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.TweakDescription;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.TweakRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.controller.Controller;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tag.TagBuilder;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.tag.TagWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.TooltipBuilder;
import mod.adrenix.nostalgic.client.gui.widget.input.ColorInput;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.config.cache.ConfigCache;
import mod.adrenix.nostalgic.tweak.FavoriteTweak;
import mod.adrenix.nostalgic.tweak.TweakContext;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.network.chat.Component;

public class TweakRowLayout {
    final int x = 5;
    final int y = 5;
    final int padding = 5;
    final NullableHolder<DynamicWidget<?, ?>> controller = NullableHolder.empty();
    final NullableHolder<DynamicWidget<?, ?>> picker = NullableHolder.empty();
    final LinkedHashSet<TextWidget> descriptions = new LinkedHashSet();
    final CrumbWidget breadcrumbs;
    final TagWidget tags;
    final TextWidget title;
    final ButtonWidget modern;
    final ButtonWidget reset;
    final ButtonWidget undo;
    final ButtonWidget save;
    final ButtonWidget cache;
    final ButtonWidget status;
    final ButtonWidget favorite;
    final DynamicWidget<?, ?> startOfRightSide;
    final Tweak<?> tweak;
    final TweakRow row;

    TweakRowLayout(TweakRow row) {
        this.row = row;
        this.tweak = row.getTweak();
        CrumbBuilder crumbBuilder = CrumbWidget.create(this.tweak);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.breadcrumbs = ((CrumbBuilder)crumbBuilder.pos(5, 5)).syncWithRow(this.row).build(this.row::addWidget);
        TagBuilder tagBuilder = (TagBuilder)TagWidget.create(this.tweak).alignFlushTo(this.breadcrumbs);
        Objects.requireNonNull(this);
        this.tags = ((TagBuilder)tagBuilder.below(this.breadcrumbs, 5)).build(this.row::addWidget);
        TextBuilder textBuilder = TextWidget.create(this.tweak.getTranslation()).color(this.row.getColor().brighter());
        Objects.requireNonNull(this);
        this.title = ((TextBuilder)((TextBuilder)textBuilder.below(this.tags, 5 + 2)).alignFlushTo(this.breadcrumbs)).italicsWhen(this.tweak::isCurrentCacheSavable).build(this.row::addWidget);
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[2];
        booleanSupplierArray[0] = this.tweak::isCacheDisabled;
        booleanSupplierArray[1] = this.tweak::isNetworkLocked;
        ButtonBuilder buttonBuilder = (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().below(this.tags, 1)).icon(Icons.RED_X)).tooltip(Lang.Button.MODERN, 40, 700L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.TweakRow.MODERN, 40)).disabledInfoTooltip(Lang.TweakRow.MODERN_OFF, 45)).disableIf(CollectionUtil.areAnyTrue(booleanSupplierArray));
        Objects.requireNonNull(this);
        this.modern = ((ButtonBuilder)((ButtonBuilder)buttonBuilder.fromWidgetEndX(this.row, 5)).onPress(this.tweak::setCacheDisabled)).build(this.row::addWidget);
        BooleanSupplier[] booleanSupplierArray2 = new BooleanSupplier[2];
        booleanSupplierArray2[0] = this.tweak::isCacheDefault;
        booleanSupplierArray2[1] = this.tweak::isNetworkLocked;
        this.reset = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().leftOf(this.modern, 1)).icon(Icons.RED_REDO)).tooltip(Lang.Button.RESET, 40, 700L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.TweakRow.RESET, 40)).disabledInfoTooltip(Lang.TweakRow.RESET_OFF, 45)).disableIf(CollectionUtil.areAnyTrue(booleanSupplierArray2))).onPress(this.tweak::setCacheToDefault)).build(this.row::addWidget);
        BooleanSupplier[] booleanSupplierArray3 = new BooleanSupplier[2];
        booleanSupplierArray3[0] = this.tweak::isCacheNotUndoable;
        booleanSupplierArray3[1] = this.tweak::isNetworkLocked;
        this.undo = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().leftOf(this.reset, 1)).icon(Icons.UNDO)).hoverIcon(Icons.UNDO_HOVER)).tooltip(Lang.Button.UNDO, 500L, TimeUnit.MILLISECONDS)).disableIf(CollectionUtil.areAnyTrue(booleanSupplierArray3))).onPress(this.tweak::undoCache)).build(this.row::addWidget);
        Runnable[] runnableArray = new Runnable[3];
        runnableArray[0] = this.tweak::applyCurrentCache;
        runnableArray[1] = ConfigCache::save;
        runnableArray[2] = AfterConfigSave::run;
        BooleanSupplier[] booleanSupplierArray4 = new BooleanSupplier[2];
        booleanSupplierArray4[0] = this.tweak::isCurrentCacheSavable;
        booleanSupplierArray4[1] = this.tweak::isNetworkUnlocked;
        this.save = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().leftOf(this.undo, 1)).icon(Icons.SAVE_FLOPPY)).tooltip(Lang.Button.SAVE, 700L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.supply(this.tweak::isLocalMode, Lang.Tooltip.SAVE_TWEAK_LOCAL, Lang.Tooltip.SAVE_TWEAK_NETWORK), 35)).onPress(CollectionUtil.runAll(runnableArray))).enableIf(CollectionUtil.areAllTrue(booleanSupplierArray4))).build(this.row::addWidget);
        this.status = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().onPress(() -> new StatusOverlay(this.tweak).open())).icon(() -> TweakContext.from(this.tweak).getIcon(this.isFlashing()))).tooltip(Lang.Button.STATUS, 700L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.TweakRow.STATUS, 40)).build();
        this.favorite = (ButtonWidget)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().onPress(() -> FavoriteTweak.toggle(this.tweak))).icon(() -> FavoriteTweak.isPresent(this.tweak) ? Icons.STAR_ON : Icons.STAR_OFF)).tooltip(Lang.Button.FAVORITE, 700L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.supply(() -> FavoriteTweak.isAbsent(this.tweak), Lang.TweakRow.STAR, Lang.TweakRow.STAR_OFF), 40)).build();
        this.startOfRightSide = this.save;
        TweakDescription.init(this);
        DynamicWidget<?, ?> controller = new Controller(this).create();
        this.controller.set(controller);
        this.controller.ifPresent(this.row::addWidget);
        Object obj = controller.getBuilder();
        if (obj instanceof TooltipBuilder) {
            TooltipBuilder builder = (TooltipBuilder)obj;
            builder.disabledTooltip(Lang.Tooltip.NOT_OPERATOR, 45, 500L, TimeUnit.MILLISECONDS);
        }
        if (controller instanceof ColorInput) {
            ColorInput colorInput = (ColorInput)controller;
            this.picker.set(((ButtonBuilder)colorInput.getPickerButton().leftOf(controller, 1)).build(this.row::addWidget));
        }
        this.cache = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().icon(() -> this.tweak.isLocalMode() ? Icons.CLIENT : Icons.SERVER)).tooltip(Lang.Button.LOGICAL_SIDE, 700L, TimeUnit.MILLISECONDS)).infoTooltip(this::getCacheTooltip, 40)).onPress(this.tweak::toggleCacheMode)).enableIf(this.tweak::isNetworkAvailable)).leftOf(this.picker.orElse(controller), 1)).build(this.row::addWidget);
        ((ButtonBuilder)this.status.getBuilder()).leftOf(this.cache, 1);
        ((ButtonBuilder)this.favorite.getBuilder()).leftOf(this.status, 1);
        this.row.addWidget(this.status);
        this.row.addWidget(this.favorite);
        ((TextBuilder)this.title.getBuilder()).extendWidthTo(this.favorite, 3);
        this.setTabOrder();
        this.setUpdateOrder();
    }

    public Tweak<?> getTweak() {
        return this.tweak;
    }

    public TweakRow getRow() {
        return this.row;
    }

    public DynamicWidget<?, ?> getStartOfRightSide() {
        return this.startOfRightSide;
    }

    public ButtonWidget getFavorite() {
        return this.favorite;
    }

    public ButtonWidget getStatus() {
        return this.status;
    }

    public ButtonWidget getSave() {
        return this.save;
    }

    public ButtonWidget getUndo() {
        return this.undo;
    }

    public ButtonWidget getReset() {
        return this.reset;
    }

    public ButtonWidget getModern() {
        return this.modern;
    }

    private Component getCacheTooltip() {
        if (this.tweak.isClient()) {
            return Lang.TweakRow.CACHE_CLIENT.get(new Object[0]);
        }
        if (this.tweak.isNetworkUnavailable()) {
            return Lang.TweakRow.NETWORK_DISCONNECTED.get(new Object[0]);
        }
        return Lang.TweakRow.CACHE.get(this.tweak.isNetworkMode() ? "client" : "server");
    }

    private boolean isFlashing() {
        return GuiUtil.getScreenAs(ConfigScreen.class).stream().anyMatch(ConfigScreen::getTimerState);
    }

    private void setTabOrder() {
        IntegerHolder order = IntegerHolder.create(0);
        Consumer<DynamicWidget> setOrder = widget -> widget.setTabOrderGroup(order.getAndIncrement());
        setOrder.accept(this.favorite);
        setOrder.accept(this.status);
        setOrder.accept(this.cache);
        if (this.picker.isPresent()) {
            setOrder.accept(this.picker.get());
        }
        if (this.controller.isPresent()) {
            setOrder.accept(this.controller.get());
        }
        setOrder.accept(this.save);
        setOrder.accept(this.undo);
        setOrder.accept(this.reset);
        setOrder.accept(this.modern);
    }

    private void setUpdateOrder() {
        this.row.moveToFront(this.favorite);
        this.row.moveToFront(this.status);
        this.row.moveToFront(this.cache);
        if (this.picker.isPresent()) {
            this.row.moveToFront(this.picker.getOrThrow());
        }
        if (this.controller.isPresent()) {
            this.row.moveToFront(this.controller.getOrThrow());
        }
        this.row.moveToFront(this.save);
        this.row.moveToFront(this.undo);
        this.row.moveToFront(this.reset);
        this.row.moveToFront(this.modern);
        this.row.moveToFront(this.tags);
        this.row.moveToFront(this.breadcrumbs);
    }
}

