/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.list;

import java.util.LinkedHashSet;
import java.util.Objects;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.TweakRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.TweakRowLayout;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;

class TweakDescription {
    private final TweakRowLayout layout;

    static void init(TweakRowLayout layout) {
        new TweakDescription(layout).create(Lang.TweakRow.DESCRIPTION, layout.tweak.getDescription(), TextureIcon.fromItem(Items.BOOK), Color.fromFormatting(ChatFormatting.GRAY), BooleanSupplier.ALWAYS);
        new TweakDescription(layout).create(Lang.Tag.ALERT, layout.tweak.getAlertMessage(), Icons.ALERT, Color.fromFormatting(ChatFormatting.RED), layout.tweak::isAlertTag);
        new TweakDescription(layout).create(Lang.Tag.WARNING, layout.tweak.getWarningMessage(), Icons.WARNING, Color.fromFormatting(ChatFormatting.YELLOW), layout.tweak::isWarningTag);
        new TweakDescription(layout).create(Lang.Tag.CONFLICT, layout.tweak.getConflictMessage(), Icons.WARNING, Color.fromFormatting(ChatFormatting.RED), layout.tweak::isModConflict);
        new TweakDescription(layout).create(Lang.Tag.NO_SSO_HEADER, layout.tweak.getNoSSOMessage(), Icons.WARNING, Color.fromFormatting(ChatFormatting.YELLOW), layout.tweak::isNotSSO);
        layout.tweak.getModIssues().forEach(issue -> new TweakDescription(layout).create(issue.getTitle(), issue.getDescription(layout.tweak), issue.getIcon(), issue.getColor(), issue.isActive()));
    }

    private TweakDescription(TweakRowLayout layout) {
        this.layout = layout;
    }

    private void create(Translation header, Component description, TextureIcon icon, Color color, BooleanSupplier visibleIf) {
        TextBuilder textBuilder = (TextBuilder)((TextBuilder)TextWidget.create(header).icon(icon).color(color).visibleIf(visibleIf)).alignFlushTo(this.layout.breadcrumbs);
        TweakRow tweakRow = this.layout.row;
        Objects.requireNonNull(this.layout);
        TextBuilder textBuilder2 = (TextBuilder)textBuilder.extendWidthToEnd(tweakRow, 5);
        LinkedHashSet<TextWidget> linkedHashSet = this.layout.descriptions;
        Objects.requireNonNull(this.layout);
        TextBuilder textBuilder3 = (TextBuilder)textBuilder2.belowAll(linkedHashSet, 5 * 2);
        TextWidget textWidget = this.layout.title;
        Objects.requireNonNull(this.layout);
        TextWidget title = ((TextBuilder)textBuilder3.below(textWidget, 5 * 2)).build(this.layout.row::addWidget);
        TextBuilder textBuilder4 = (TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(description).visibleIf(visibleIf)).below(title, 3)).alignFlushTo(this.layout.breadcrumbs);
        TweakRow tweakRow2 = this.layout.row;
        Objects.requireNonNull(this.layout);
        TextWidget body = ((TextBuilder)textBuilder4.extendWidthToEnd(tweakRow2, 5)).build(this.layout.row::addWidget);
        this.layout.descriptions.add(body);
    }
}

