/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.list;

import java.util.LinkedHashSet;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.ConfigRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.DescriptionRow;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.GroupRowMaker;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.RowProvider;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.list.TweakRow;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankBuilder;
import mod.adrenix.nostalgic.client.gui.widget.blank.BlankWidget;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonRenderer;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GroupRow
extends ConfigRow<GroupRowMaker, GroupRow> {
    private final Container container;
    private final LinkedHashSet<ConfigRow<?, ?>> children = new LinkedHashSet();
    private boolean collapsed;

    public static GroupRowMaker create(Container container, RowList rowList) {
        return new GroupRowMaker(container, rowList);
    }

    public static GroupRowMaker create(Container container, GroupRow group) {
        return new GroupRowMaker(container, group);
    }

    GroupRow(GroupRowMaker maker) {
        super(maker);
        this.parent = maker.parent;
        this.container = maker.container;
        this.collapsed = true;
        Color color = this.container.getColor();
        ButtonWidget toggle = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().title(() -> this.collapsed ? Component.literal((String)"+") : Component.literal((String)"-"))).backgroundRenderer(ButtonRenderer.EMPTY).color(color, color.brighter())).padding(3)).cannotFocus()).useTextWidth()).noClickSound()).build(this::addWidget);
        IconWidget icon = ((IconFactory)((IconFactory)((IconFactory)IconWidget.create(this.container.getIcon()).posY(() -> Math.round(MathUtil.center(toggle.getY(), 16, toggle.getHeight())))).rightOf(toggle, 6)).size(16)).build(this::addWidget);
        BlankWidget area = ((BlankBuilder)((BlankBuilder)((BlankBuilder)BlankWidget.create().pos(this::getX, this::getY)).height(this.getDefaultRowHeight())).width(this::getWidth)).build(this::addWidget);
        ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create((Component)Component.literal((String)this.container.toString())).pressArea(area).onPress(this::toggle, color.brighter()).posY(toggle::getTextY)).color(color).rightOf(icon, 6)).extendWidthToEnd(this, 0)).highlightIf(ModTweak.DISPLAY_ROW_HIGHLIGHT_FADE::fromCache).highlighter(this.highlighter).build(this::addWidget);
        ((GroupRowMaker)((GroupRowMaker)((GroupRowMaker)((GroupRowMaker)this.getBuilder()).indent(this.container.getIndentForGroupRow())).heightOverflowMargin(0)).highlightColor(color)).postRenderer(this::renderBox);
    }

    public Container getContainer() {
        return this.container;
    }

    public LinkedHashSet<ConfigRow<?, ?>> getChildren() {
        return this.children;
    }

    public LinkedHashSet<ConfigRow<?, ?>> getDeepChildren() {
        LinkedHashSet allChildren = new LinkedHashSet(this.children);
        if (!this.children.isEmpty()) {
            CollectionUtil.fromCast(this.children, GroupRow.class).map(GroupRow::getDeepChildren).forEach(allChildren::addAll);
        }
        return allChildren;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isExpanded() {
        return !this.isCollapsed();
    }

    public void expand() {
        this.collapsed = true;
        this.toggle();
    }

    public void jumpToMe() {
        if (this.isCollapsed()) {
            this.expand();
        }
        this.focusOnFirst();
        this.rowList.setSmoothScrollOn(this);
    }

    private void addRow(ConfigRow<?, ?> row) {
        this.rowList.addBelowRow(row, CollectionUtil.last(this.children).orElse(this));
        this.children.add(row);
    }

    private void addTweakRow(Tweak<?> tweak) {
        if (RowProvider.get().test(tweak)) {
            this.addRow((ConfigRow)TweakRow.create(tweak, this).build());
        }
    }

    private void addGroupRow(Container group) {
        if (group.getDeepTweaks().stream().noneMatch(RowProvider.get()::test)) {
            return;
        }
        this.addRow((ConfigRow)GroupRow.create(group, this).build());
    }

    private void removeChildren() {
        CollectionUtil.fromCast(this.children, GroupRow.class).forEach(GroupRow::removeChildren);
        this.children.forEach(this.rowList::removeRow);
        this.children.clear();
    }

    public void toggle() {
        if (this.collapsed) {
            if (this.container.getDescription().isPresent()) {
                this.addRow((ConfigRow)DescriptionRow.create(this.container, this.rowList).build());
            }
            this.container.getChildren().forEach(this::addGroupRow);
            this.container.getTweaks().forEach(this::addTweakRow);
        } else {
            this.removeChildren();
        }
        this.collapsed = !this.collapsed;
    }

    private void renderBox(GroupRow row, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (row.isWidgetFocused()) {
            RenderUtil.outline(graphics, (float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), Color.FRENCH_SKY_BLUE);
        }
        this.renderTree(row, graphics, mouseX, mouseY, partialTick);
    }
}

