/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget.crumb;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.crumb.Crumb;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.crumb.CrumbBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicField;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicFunction;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetCache;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.data.CacheValue;
import mod.adrenix.nostalgic.util.common.function.ForEachWithPrevious;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class CrumbWidget
extends DynamicWidget<CrumbBuilder, CrumbWidget> {
    static final MutableComponent SLASH = Component.literal((String)" / ").withStyle(ChatFormatting.WHITE);
    final int crumbMargin = 3;
    final LinkedHashSet<Crumb> crumbs = new LinkedHashSet();
    @Nullable
    final AbstractRow<?, ?> row;

    public static CrumbBuilder create(Tweak<?> tweak) {
        return new CrumbBuilder(tweak);
    }

    CrumbWidget(CrumbBuilder builder) {
        super(builder);
        builder.tweak.getContainer().getGroupSetFromCategory().forEach(container -> this.crumbs.add(new Crumb(this, (Container)container)));
        this.row = builder.row;
        class Sync
        implements DynamicFunction<CrumbBuilder, CrumbWidget> {
            Sync(CrumbWidget this$0) {
            }

            @Override
            public void apply(CrumbWidget widget, CrumbBuilder builder) {
                ForEachWithPrevious.create(widget.crumbs).forEach(Crumb::setFromPrev).run();
                CollectionUtil.last(widget.crumbs).ifPresent(Crumb::setAsLast);
                widget.setWidth(widget.getWidthFromCrumbs());
                widget.setHeight(widget.getHeightFromCrumbs());
            }

            @Override
            public boolean isReapplyNeeded(CrumbWidget widget, CrumbBuilder builder, WidgetCache cache) {
                if (widget.row != null) {
                    return CacheValue.isAnyExpired(widget.row.cache.x, widget.row.cache.width);
                }
                return false;
            }

            @Override
            public List<DynamicField> getManaging(CrumbBuilder builder) {
                return List.of(DynamicField.WIDTH, DynamicField.HEIGHT);
            }
        }
        ((CrumbBuilder)this.getBuilder()).addFunction(new Sync(this));
    }

    int getLineHeight() {
        return GuiUtil.textHeight() + this.crumbMargin;
    }

    private int getHeightFromCrumbs() {
        int maxLineHeight = this.crumbs.stream().mapToInt(Crumb::getLineHeight).max().orElse(0);
        return Math.max(this.getLineHeight(), maxLineHeight) - this.crumbMargin;
    }

    private int getWidthFromCrumbs() {
        return this.crumbs.stream().mapToInt(Crumb::getMaxWidthFromCrumbLine).max().orElse(0);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInvalidClick(mouseX, mouseY, button)) {
            return false;
        }
        Optional<Crumb> clicked = this.crumbs.stream().filter(crumb -> crumb.isMouseOver(mouseX, mouseY)).findFirst();
        if (clicked.isPresent()) {
            clicked.get().onClick();
            GuiUtil.playClick();
            return true;
        }
        return false;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        RenderUtil.beginBatching();
        this.crumbs.forEach(crumb -> crumb.render(graphics, mouseX, mouseY, partialTick));
        this.renderDebug(graphics);
        RenderUtil.endBatching();
    }
}

