/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.slider.SliderBuilder;
import mod.adrenix.nostalgic.client.gui.widget.slider.SliderWidget;
import mod.adrenix.nostalgic.tweak.gui.SliderType;
import mod.adrenix.nostalgic.tweak.gui.TweakSlider;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.GameSprite;
import mod.adrenix.nostalgic.util.common.asset.ModSprite;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SliderTweak {
    private final TweakSlider slider;
    private final Consumer<Number> valueConsumer;
    private final Supplier<Number> valueSupplier;

    public static SliderBuilder create(TweakSlider slider, Consumer<? super Number> valueConsumer, Supplier<? super Number> valueSupplier) {
        return new SliderTweak(slider, valueConsumer::accept, () -> (Number)valueSupplier.get()).getBuilder();
    }

    private SliderTweak(TweakSlider slider, Consumer<Number> valueConsumer, Supplier<Number> valueSupplier) {
        this.slider = slider;
        this.valueConsumer = valueConsumer;
        this.valueSupplier = valueSupplier;
    }

    private SliderBuilder getBuilder() {
        return (SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)((SliderBuilder)SliderWidget.create(this.slider.getMin(), this.slider.getMax(), this.valueConsumer, this.valueSupplier).effectsRenderer(this::effectsRenderer)).title(this::getTitle)).suffix(this::getSuffix)).formatter(this::getFormatter)).interval(this.slider.getInterval())).roundTo(this.slider.getRoundTo());
    }

    private String getFormatter(Number number) {
        return String.valueOf(this.slider.getType().getColor(this.valueSupplier.get())) + this.slider.getFormatter().apply(number);
    }

    private Component getTitle() {
        Component fromType = this.slider.getType().getTranslation(this.valueSupplier.get());
        if (fromType.getString().isEmpty()) {
            return this.slider.getTranslation();
        }
        return fromType;
    }

    private Component getSuffix() {
        Component fromType = this.slider.getType().getSuffix(this.valueSupplier.get());
        if (fromType.getString().isEmpty()) {
            return Component.literal((String)this.slider.getSuffix());
        }
        return fromType;
    }

    private void effectsRenderer(SliderWidget slider, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int i;
        boolean isStamina;
        boolean isHearts = this.slider.getType() == SliderType.HEARTS;
        boolean bl = isStamina = this.slider.getType() == SliderType.STAMINA;
        if (!isHearts && !isStamina) {
            return;
        }
        if (slider.isInactive()) {
            RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        }
        int value = this.valueSupplier.get().intValue();
        int x = slider.getX() + slider.getWidth() / 2 - 45;
        int y = slider.getY() + 6;
        int dx = x;
        ResourceLocation empty = isHearts ? GameSprite.EMPTY_HEART : ModSprite.STAMINA_EMPTY;
        ResourceLocation full = isHearts ? GameSprite.FULL_HEART : ModSprite.STAMINA_LEVEL;
        ResourceLocation half = isHearts ? GameSprite.HALF_HEART : ModSprite.STAMINA_LEVEL_HALF;
        RenderUtil.beginBatching();
        for (i = 0; i < 10; ++i) {
            RenderUtil.blitSprite(empty, graphics, dx, y, 9, 9);
            dx += 9;
        }
        dx = x;
        for (i = 0; i < value - 1; ++i) {
            if (MathUtil.isOdd(i)) continue;
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 1.0f);
            RenderUtil.blitSprite(full, graphics, dx, y, 9, 9);
            graphics.pose().popPose();
            dx += 9;
        }
        if (MathUtil.isOdd(value)) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 1.0f);
            RenderUtil.blitSprite(half, graphics, dx, y, 9, 9);
            graphics.pose().popPose();
        }
        RenderUtil.endBatching();
    }
}

