/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.GroupConfigPresets;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.GroupCreateBackup;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.GroupHelp;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.GroupImportExport;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.GroupMenuOptions;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.GroupServerOps;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.GroupToggleAll;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.GroupViewBackups;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageGroup;
import mod.adrenix.nostalgic.client.gui.widget.button.AbstractButtonMaker;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.SelfBuilder;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.Nullable;

public enum ManageSection {
    MENU_OPTIONS(Icons.MECHANICAL_TOOLS, Lang.Button.MENU_OPTIONS, new GroupMenuOptions()),
    IMPORT_AND_EXPORT(Icons.SAVE_FLOPPY, Lang.Button.IMPORT_AND_EXPORT, new GroupImportExport()),
    CREATE_BACKUP(Icons.ADD, Lang.Button.CREATE_BACKUP, new GroupCreateBackup()),
    VIEW_BACKUPS(Icons.BOOK_OPEN, Lang.Button.VIEW_BACKUPS, new GroupViewBackups()),
    CONFIG_PRESETS(Icons.COPY, Lang.Button.CONFIG_PRESETS, new GroupConfigPresets()),
    SERVER_OPERATIONS(Icons.SERVER, Lang.Button.SERVER_OPERATIONS, new GroupServerOps()),
    TOGGLE_ALL_TWEAKS(Icons.LIGHTNING, Lang.Button.TOGGLE_ALL_TWEAKS, new GroupToggleAll()),
    HELP(Icons.TOOLTIP, Lang.Button.HELP, new GroupHelp());

    @Nullable
    private Overlay overlay;
    private final ManageGroup manager;
    private final TextureIcon icon;
    private final Translation title;
    private boolean active;

    private ManageSection(TextureIcon icon, Translation title, ManageGroup manager) {
        this.icon = icon;
        this.title = title;
        this.manager = manager;
        this.overlay = null;
    }

    public static Stream<ManageSection> stream() {
        return Arrays.stream(ManageSection.values());
    }

    public static ManageSection getActive() {
        return ManageSection.stream().filter(ManageSection::isActive).findFirst().orElse(MENU_OPTIONS);
    }

    public static int getLargestWidth() {
        List<ButtonWidget> buttons = ManageSection.stream().map(ManageSection::button).map(AbstractButtonMaker::useTextWidth).map(SelfBuilder::build).toList();
        return buttons.stream().mapToInt(DynamicWidget::getWidth).max().orElse(0);
    }

    public static void setServerBackups(Set<BackupObject> backups) {
        ManageGroup manageGroup = VIEW_BACKUPS.getManager();
        if (manageGroup instanceof GroupViewBackups) {
            GroupViewBackups view = (GroupViewBackups)manageGroup;
            view.setServerBackups(backups);
        }
    }

    public static void setReceiveFailed() {
        ManageGroup manageGroup = VIEW_BACKUPS.getManager();
        if (manageGroup instanceof GroupViewBackups) {
            GroupViewBackups view = (GroupViewBackups)manageGroup;
            view.setReceiveFailed();
        }
    }

    ManageGroup getManager() {
        return this.manager;
    }

    public void setOverlay(@Nullable Overlay overlay) {
        this.overlay = overlay;
    }

    public void activate() {
        ManageSection.stream().map(ManageSection::getManager).forEach(ManageGroup::setInvisible);
        ManageSection.getActive().active = false;
        this.manager.setVisible();
        this.active = true;
        if (this.overlay != null) {
            this.overlay.resetScrollAmount();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public ButtonBuilder button() {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(this.title).icon(this.icon)).disabledIcon(this.icon)).disableIf(this::isActive)).onPress(this::activate)).renderer(this::render);
    }

    private void render(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (button.isHoveredOrFocused() || button.isInactive()) {
            Color fillColor;
            Color barColor = button.isInactive() ? Color.fromFormatting(ChatFormatting.GOLD) : Color.AZURE_WHITE;
            Color color = fillColor = button.isInactive() ? Color.fromFormatting(ChatFormatting.GOLD) : Color.CADET_GRAY;
            if (button.isHoveredOrFocused() && button.isInactive()) {
                barColor = Color.RIPE_MANGO;
                fillColor = Color.RIPE_MANGO;
            }
            fillColor = fillColor.fromAlpha(0.2f);
            RenderUtil.fill(graphics, (float)button.getX(), (float)button.getY(), (float)button.getEndX(), (float)button.getEndY(), fillColor.get());
            RenderUtil.fill(graphics, (float)button.getX(), (float)button.getY(), (float)(button.getX() + 2), (float)button.getEndY(), barColor.get());
        }
        button.getIconManager().apply(icon -> icon.pos(button.getX() + 6, button.getIconY()));
        button.getIconManager().render(graphics, mouseX, mouseY, partialTick);
        DrawText.begin(graphics, button.getTitle()).pos(button.getIconManager().get().getEndX() + 4, button.getTextY()).color(button.isHoveredOrFocused() ? Color.fromFormatting(ChatFormatting.YELLOW) : Color.WHITE).draw();
    }
}

