/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.AfterConfigSave;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageGroup;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageOverlay;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.manage.ManageThreadMessage;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonTemplate;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.config.ClientConfig;
import mod.adrenix.nostalgic.config.ServerConfig;
import mod.adrenix.nostalgic.config.cache.ConfigCache;
import mod.adrenix.nostalgic.config.factory.ConfigBuilder;
import mod.adrenix.nostalgic.config.factory.ConfigHandler;
import mod.adrenix.nostalgic.network.packet.backup.ServerboundReloadConfig;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.client.dialog.DialogType;
import mod.adrenix.nostalgic.util.client.dialog.FileDialog;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;

public class GroupImportExport
extends ManageGroup {
    @Override
    void define(ManageOverlay manager) {
        Group header = ((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(manager.overlay).forceRelativeY()).icon(Icons.SAVE_FLOPPY).title(Lang.Button.IMPORT_AND_EXPORT).border(Color.IRIS_BLUE).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).build(this::register);
        ((TextBuilder)TextWidget.create(Lang.Manage.IMPORT_EXPORT_HEADER).width(header::getInsideWidth)).build(header::addWidget);
        Group swap = ((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(manager.overlay).icon(Icons.RED_UNDO).title(Lang.Manage.HOT_SWAP).border(Color.GOLDEN_GATE_BRIDGE).below(header, manager.padding)).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).build(this::register);
        TextWidget swapInformation = ((TextBuilder)TextWidget.create(Lang.Manage.HOT_SWAP_INFO).width(swap::getInsideWidth)).build(swap::addWidget);
        Grid swapGrid = ((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)manager.overlay, 2).columnSpacing(1).extendWidthToEnd(swap, swap.getInsidePaddingX())).below(swapInformation, manager.padding * 2)).build(swap::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.CLIENT_RELOAD).icon(Icons.CLIENT)).holdFor(1L, TimeUnit.SECONDS)).onPress(GroupImportExport::clientReload)).build(swapGrid::addCell);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.SERVER_RELOAD).disabledTooltip(Lang.Tooltip.NOT_CONNECTED_OR_OPERATOR, 35, 500L, TimeUnit.MILLISECONDS)).disableIf(NetUtil::isNotConnectedOrOperator)).onPress(GroupImportExport::serverReload)).icon(Icons.SERVER)).holdFor(1L, TimeUnit.SECONDS)).cooldown(2L, TimeUnit.SECONDS)).build(swapGrid::addCell);
        Group advisement = ((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(manager.overlay).icon(Icons.WARNING).title(Lang.Manage.IMPORT_ADVISORY_TITLE).border(Color.SCHOOL_BUS).below(swap, manager.padding)).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).build(this::register);
        TextWidget advisoryInformation = ((TextBuilder)TextWidget.create(Lang.Manage.IMPORT_ADVISORY_MESSAGE).width(advisement::getInsideWidth)).build(advisement::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonTemplate.openFolder(PathUtil.getLogsPath()).useTextWidth()).centerInWidgetX(advisement)).below(advisoryInformation, manager.padding * 2)).build(advisement::addWidget);
        Group importing = ((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(manager.overlay).icon(Icons.IMPORT_FLOPPY).title(Lang.Button.IMPORT).border(Color.VIVID_LIME).below(advisement, manager.padding)).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).build(this::register);
        TextWidget clientTextImport = ((TextBuilder)TextWidget.create(Lang.Manage.CLIENT_IMPORT).width(importing::getInsideWidth)).build(importing::addWidget);
        ButtonWidget clientImport = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.CLIENT_IMPORT).icon(Icons.CLIENT)).useTextWidth()).centerInWidgetX(importing)).onPress(GroupImportExport::clientImport)).below(clientTextImport, manager.padding * 2)).build(importing::addWidget);
        SeparatorWidget separatorImport = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(importing.getColor()).height(1)).below(clientImport, manager.padding * 2)).width(importing::getInsideWidth)).build(importing::addWidget);
        TextWidget serverTextImport = ((TextBuilder)((TextBuilder)TextWidget.create(Lang.Manage.SERVER_IMPORT).below(separatorImport, manager.padding * 2)).width(importing::getInsideWidth)).build(importing::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.SERVER_IMPORT).icon(Icons.SERVER)).useTextWidth()).centerInWidgetX(importing)).enableIf(NetUtil::isConnectedAndOperator)).onPress(GroupImportExport::serverImport)).below(serverTextImport, manager.padding * 2)).build(importing::addWidget);
        Group exporting = ((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(manager.overlay).icon(Icons.EXPORT_FLOPPY).title(Lang.Button.EXPORT).border(Color.ATOMIC_TANGERINE).below(importing, manager.padding)).rightOf(manager.separator, manager.padding)).extendWidthToScreenEnd(0)).build(this::register);
        TextWidget clientTextExport = ((TextBuilder)TextWidget.create(Lang.Manage.CLIENT_EXPORT).width(exporting::getInsideWidth)).build(exporting::addWidget);
        ButtonWidget clientExport = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.CLIENT_EXPORT).icon(Icons.CLIENT)).useTextWidth()).centerInWidgetX(exporting)).onPress(GroupImportExport::clientExport)).below(clientTextExport, manager.padding * 2)).build(exporting::addWidget);
        SeparatorWidget separatorExport = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(exporting.getColor()).height(1)).below(clientExport, manager.padding * 2)).width(exporting::getInsideWidth)).build(exporting::addWidget);
        TextWidget serverTextExport = ((TextBuilder)((TextBuilder)TextWidget.create(Lang.Manage.SERVER_EXPORT).below(separatorExport, manager.padding * 2)).width(exporting::getInsideWidth)).build(exporting::addWidget);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.SERVER_EXPORT).icon(Icons.SERVER)).useTextWidth()).centerInWidgetX(exporting)).onPress(GroupImportExport::serverExport)).below(serverTextExport, manager.padding * 2)).build(exporting::addWidget);
    }

    private static void clientReload() {
        Path reloadLocation = ConfigBuilder.getHandler().getPath();
        ConfigHandler<ClientConfig> hotSwap = ConfigBuilder.temp(ClientConfig.class, reloadLocation);
        if (hotSwap.load()) {
            ConfigHandler<ClientConfig> handler = ConfigBuilder.getHandler();
            handler.setLoaded(hotSwap.getLoaded());
            handler.save();
            TweakPool.values().forEach(TweakMeta::sync);
            AfterConfigSave.reloadAndRun();
        } else {
            ManageThreadMessage.IMPORT_ERROR.open();
        }
    }

    private static void serverReload() {
        PacketUtil.sendToServer(new ServerboundReloadConfig());
    }

    private static void clientImport() {
        CompletableFuture.runAsync(() -> {
            Path defaultFile = ConfigBuilder.getHandler().getPath();
            String readLocation = FileDialog.getJsonLocation("Client Config Import", defaultFile, DialogType.OPEN_FILE);
            if (readLocation != null) {
                ConfigHandler<ClientConfig> handler = ConfigBuilder.temp(ClientConfig.class, Path.of(readLocation, new String[0]));
                if (handler.load()) {
                    ManageThreadMessage.IMPORT_CLIENT_SUCCESS.open(handler);
                    NostalgicTweaks.LOGGER.info("[Config Import] Imported a new client config using the file at %s", readLocation);
                } else {
                    ManageThreadMessage.IMPORT_ERROR.open();
                }
            }
        }).exceptionally(throwable -> {
            ManageThreadMessage.JAVA_ERROR.open();
            NostalgicTweaks.LOGGER.error("[Config Import] An error occurred while importing client config file\n%s", throwable);
            return null;
        });
    }

    private static void clientExport() {
        CompletableFuture.runAsync(() -> {
            try {
                Path defaultFile = ConfigBuilder.getHandler().getPath();
                String writeLocation = FileDialog.getJsonLocation("Client Config Export", defaultFile, DialogType.SAVE_FILE);
                if (writeLocation != null) {
                    Path savePath = Path.of(writeLocation, new String[0]);
                    Files.copy(ConfigCache.path(), savePath, StandardCopyOption.REPLACE_EXISTING);
                    ManageThreadMessage.EXPORT_CLIENT_SUCCESS.open(savePath.getParent());
                    NostalgicTweaks.LOGGER.info("[Config Export] Created a new client export file at %s", writeLocation);
                }
            }
            catch (IOException exception) {
                ManageThreadMessage.JAVA_ERROR.open();
                NostalgicTweaks.LOGGER.error("[Config Export] (I/O Error) Could not export client config file\n%s", exception);
            }
        }).exceptionally(throwable -> {
            ManageThreadMessage.JAVA_ERROR.open();
            NostalgicTweaks.LOGGER.error("[Config Export] An error occurred while exporting client config file\n%s", throwable);
            return null;
        });
    }

    private static void serverImport() {
        CompletableFuture.runAsync(() -> {
            String loadLocation = FileDialog.getJsonLocation("Server Config Import", null, DialogType.OPEN_FILE);
            if (loadLocation != null) {
                ConfigHandler<ServerConfig> importHandler = ConfigBuilder.temp(ServerConfig.class, Path.of(loadLocation, new String[0]));
                if (importHandler.load()) {
                    ManageThreadMessage.IMPORT_SERVER_SUCCESS.open(importHandler);
                    NostalgicTweaks.LOGGER.info("[Config Import] Imported a new server config using the file at %s", loadLocation);
                } else {
                    ManageThreadMessage.IMPORT_ERROR.open();
                    NostalgicTweaks.LOGGER.info("[Config Import] An error occurred while importing server config file\n%s", loadLocation);
                }
            }
        }).exceptionally(throwable -> {
            ManageThreadMessage.JAVA_ERROR.open();
            NostalgicTweaks.LOGGER.error("[Config Import] An error occurred while importing server config file\n%s", throwable);
            return null;
        });
    }

    private static void serverExport() {
        CompletableFuture.runAsync(() -> {
            Path defaultFile = Path.of("server-export.json", new String[0]);
            String saveLocation = FileDialog.getJsonLocation("Server Config Export", defaultFile, DialogType.SAVE_FILE);
            if (saveLocation != null) {
                ManageThreadMessage.EXPORT_SERVER_SUCCESS.open(Path.of(saveLocation, new String[0]));
                NostalgicTweaks.LOGGER.info("[Config Export] Created a new server export file at %s", saveLocation);
            }
        }).exceptionally(throwable -> {
            ManageThreadMessage.JAVA_ERROR.open();
            NostalgicTweaks.LOGGER.error("[Config Export] An error occurred while exporting server config file\n%s", throwable);
            return null;
        });
    }
}

