/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing;

import java.util.Collection;
import java.util.stream.Collectors;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.ListingOverlay;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.Row;
import mod.adrenix.nostalgic.client.gui.widget.list.RowMaker;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.tweak.listing.DeletableSet;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.Pair;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;

public interface DeletableSetOverlay<V, L extends DeletableSet<V, L>>
extends ListingOverlay<V, L> {
    public L getSet();

    @Override
    default public Collection<Pair<String, V>> getEntries() {
        return this.getSet().stream().map(Pair::keyValue).collect(Collectors.toSet());
    }

    @Override
    default public void onRowAdd(Object object) {
        this.getSet().applySafely((Object)object, arg_0 -> this.getSet().add(arg_0));
    }

    default public Row createRow(String key, V value) {
        Row row = (Row)((RowMaker)Row.create(this.getWidgets().rowList).heightOverflowMargin(2)).build();
        ((RowMaker)row.getBuilder()).highlightColor(this.getWidgets().getColor(row, key, () -> this.getSet().isDeleted((Object)value)));
        ((RowMaker)row.getBuilder()).postRenderer(this.getWidgets()::renderOutline);
        return row;
    }

    default public IconFactory getIconFactory(String key, V value) {
        return (IconFactory)((IconFactory)((IconFactory)IconWidget.create(this.getRowIcon(key)).pos(1, 4)).disableIf(() -> this.getSet().isDeleted((Object)value))).darkenOnDisable(0.8f);
    }

    default public TextBuilder getTitleBuilder(String key, V value, IconWidget icon) {
        int red = Color.fromFormatting(ChatFormatting.RED).get();
        int white = Color.WHITE.get();
        return ((TextBuilder)((TextBuilder)TextWidget.create(() -> this.getRowTitle(key)).rightOf(icon, 4)).posY(() -> icon.getY() + 4)).color(() -> this.getSet().isDeleted((Object)value) ? red : white).italicsWhen(() -> this.getSet().isDeleted((Object)value));
    }

    default public TextBuilder getTitleBuilder(String key, V value, IconWidget icon, BooleanSupplier italicsWhen) {
        return this.getTitleBuilder(key, value, icon).italicsWhen(() -> italicsWhen.getAsBoolean() || this.getSet().isDeleted((Object)value));
    }

    default public ButtonBuilder getUndoBuilder(V value) {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.UNDO).posY(2)).icon(Icons.UNDO)).hoverIcon(Icons.UNDO_HOVER)).onPress(() -> this.getSet().add((Object)value))).disableIf(() -> this.getSet().contains((Object)value) || this.isLocked())).useTextWidth();
    }

    default public ButtonBuilder getDeleteBuilder(V value) {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.DELETE).icon(Icons.TRASH_CAN)).onPress(() -> this.getSet().delete((Object)value))).disableIf(() -> this.getSet().isDeleted((Object)value) || this.isLocked())).useTextWidth();
    }
}

