/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.ListingOverlay;
import mod.adrenix.nostalgic.client.gui.screen.config.widget.SliderTweak;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.list.Row;
import mod.adrenix.nostalgic.client.gui.widget.list.RowMaker;
import mod.adrenix.nostalgic.client.gui.widget.slider.SliderBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.tweak.factory.TweakMap;
import mod.adrenix.nostalgic.tweak.listing.DeletableMap;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.Holder;
import mod.adrenix.nostalgic.util.common.data.Pair;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.Items;

public interface DeletableMapOverlay<V, L extends DeletableMap<V, L>>
extends ListingOverlay<V, L> {
    public L getMap();

    @Override
    default public Collection<Pair<String, V>> getEntries() {
        return this.getMap().entrySet().stream().map(Pair::entry).collect(Collectors.toSet());
    }

    @Override
    default public void onRowAdd(Object object) {
        this.getMap().putIfAbsent(object.toString());
    }

    default public Row createRow(String key) {
        Row row = (Row)((RowMaker)Row.create(this.getWidgets().rowList).heightOverflowMargin(2)).build();
        ((RowMaker)row.getBuilder()).highlightColor(this.getWidgets().getColor(row, key, () -> this.getMap().isDeleted(key)));
        ((RowMaker)row.getBuilder()).postRenderer(this.getWidgets()::renderOutline);
        return row;
    }

    default public IconFactory getIconFactory(String key, TextureIcon icon) {
        return (IconFactory)((IconFactory)((IconFactory)IconWidget.create(icon).pos(1, GameUtil.isModelFlat(icon.getItem().orElse(Items.BARRIER)) ? 1 : 2)).disableIf(() -> this.getMap().isDeleted(key))).darkenOnDisable(0.8f);
    }

    default public TextBuilder getTitleBuilder(String key, IconWidget icon, Holder<V> cache) {
        int red = Color.fromFormatting(ChatFormatting.RED).get();
        int white = Color.WHITE.get();
        return ((TextBuilder)((TextBuilder)TextWidget.create(() -> this.getRowTitle(key)).posY(() -> icon.getY() + 4)).color(() -> this.getMap().isDeleted(key) ? red : white).italicsWhen(() -> this.isUndoable(key, cache)).rightOf(icon, 4)).centerAligned().useTextWidth();
    }

    default public TextBuilder getTitleBuilder(String key, IconWidget icon, Holder<V> cache, BooleanSupplier italicsWhen) {
        return this.getTitleBuilder(key, icon, cache).italicsWhen(() -> italicsWhen.getAsBoolean() || this.isUndoable(key, cache));
    }

    default public ButtonBuilder getDeleteBuilder(String key) {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.DELETE).icon(Icons.TRASH_CAN)).onPress(() -> this.getMap().delete(key, this.getMap().getOrDeleted(key)))).disableIf(() -> this.getMap().isDeleted(key) || this.isLocked())).useTextWidth();
    }

    default public ButtonBuilder getUndoBuilder(String key, Holder<V> cache) {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.UNDO).icon(Icons.UNDO)).hoverIcon(Icons.UNDO_HOVER)).onPress(() -> this.undo(key, cache))).enableIf(() -> this.isUndoable(key, cache) && this.isUnlocked())).useTextWidth();
    }

    default public ButtonBuilder getResetBuilder(String key, V resetValue) {
        return (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.RESET).icon(Icons.REDO)).hoverIcon(Icons.REDO_HOVER)).onPress(() -> this.getMap().put(key, resetValue))).disableIf(() -> this.isResettable(key, resetValue) || this.isLocked())).useTextWidth();
    }

    default public V getResetValue(String key) {
        Object resetValue = this.getMap().getDefaultValue();
        if (((DeletableMap)this.getTweak().getDefault()).getMap().containsKey(key)) {
            return ((DeletableMap)this.getTweak().getDefault()).getMap().get(key);
        }
        return resetValue;
    }

    default public boolean isResettable(String key, V resetValue) {
        Object value = this.getMap().getOrDeleted(key);
        if (value != null) {
            return value.equals(resetValue);
        }
        return false;
    }

    default public boolean isUndoable(String key, Holder<V> cached) {
        if (this.getMap().isDeleted(key)) {
            return true;
        }
        Object fromCache = ((DeletableMap)this.getTweak().fromCache()).getOrDeleted(key);
        Object fromSaved = ((DeletableMap)this.getTweak().fromMode()).getOrDeleted(key);
        boolean isCacheDiff = fromCache != null && !fromCache.equals(cached.get());
        boolean isSaveDiff = fromSaved != null && !fromSaved.equals(cached.get());
        return isCacheDiff || isSaveDiff;
    }

    default public void undo(String key, Holder<V> cached) {
        if (this.getMap().isDeleted(key)) {
            this.getMap().undo(key, this.getMap().getOrDeleted(key));
        } else {
            Object fromCache = ((DeletableMap)this.getTweak().fromCache()).getOrDeleted(key);
            Object fromSaved = ((DeletableMap)this.getTweak().fromMode()).getOrDeleted(key);
            if (fromCache != null && !fromCache.equals(cached.get())) {
                this.getMap().put(key, cached.get());
            } else if (fromSaved != null && !fromSaved.equals(cached.get())) {
                Object saved = ((DeletableMap)this.getTweak().fromMode()).getMap().get(key);
                cached.set(saved);
                this.getMap().put(key, saved);
            }
        }
    }

    default public DynamicWidget<?, ?> getController(String key, Row row, DynamicWidget<?, ?> rightOf) {
        if (Number.class.isAssignableFrom(this.getMap().genericType())) {
            TweakMap tweak = this.getTweak().cast(TweakMap.class).orElseThrow();
            Supplier<Number> getValue = () -> {
                Number number = (Number)this.getMap().getOrDeleted(key);
                if (number == null) {
                    return 0;
                }
                return number;
            };
            Consumer<Number> setValue = number -> {
                if (this.getMap().isDeleted(key)) {
                    return;
                }
                this.getMap().applySafely(key, (Number)number, (arg_0, arg_1) -> this.getMap().put(arg_0, arg_1));
            };
            return ((SliderBuilder)((SliderBuilder)SliderTweak.create(tweak.getSlider().orElseThrow(), setValue, getValue).rightOf(rightOf, 1)).extendWidthToEnd(row, 2)).build(row::addWidget);
        }
        return ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.literal("NO-IMPL")).rightOf(rightOf, 1)).extendWidthToEnd(row, 2)).disabledTooltip(Lang.TweakRow.NO_IMPL, 45)).disableIf(BooleanSupplier.ALWAYS)).icon(Icons.NO_ENTRY)).padding(4)).build();
    }
}

