/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen.config.overlay;

import java.util.function.ToIntFunction;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.grid.Grid;
import mod.adrenix.nostalgic.client.gui.widget.grid.GridBuilder;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.config.cache.CacheMode;
import mod.adrenix.nostalgic.tweak.StatusContext;
import mod.adrenix.nostalgic.tweak.TweakContext;
import mod.adrenix.nostalgic.tweak.TweakStatus;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.DynamicRectangle;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StatusOverlay {
    private Viewing viewing = Viewing.STATUS;
    private final ButtonWidget statusButton;
    private final ButtonWidget helpButton;
    private final Group clientGroup;
    private final Group serverGroup;
    private final Grid header;
    private final Grid helpGrid;
    private final Grid statusGrid;
    private final Overlay overlay;
    private final Tweak<?> tweak;
    private final int padding;

    public StatusOverlay(Tweak<?> tweak) {
        this.tweak = tweak;
        this.padding = 2;
        this.overlay = Overlay.create((Component)Lang.Status.TITLE.get(this.tweak.getTranslation().getString())).icon(Icons.SMALL_TRAFFIC_LIGHT).resizeUsingPercentage(0.85).padding(this.padding).build();
        this.header = ((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.overlay, 2).anchor()).columnSpacing(0).extendWidthToScreenEnd(0)).build(this.overlay::addWidget);
        this.statusButton = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.STATUS).icon(this.tweak.getStatus().getIcon())).onPress(this::setStatusView)).backgroundRenderer(this::renderHeader)).build(this.header::addCell);
        this.helpButton = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.HELP).icon(Icons.TOOLTIP)).hoverIcon(Icons.TOOLTIP_HOVER)).onPress(this::setHelpView)).backgroundRenderer(this::renderHeader)).build(this.header::addCell);
        this.statusGrid = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.overlay, 2).below(this.header, this.padding)).spacing(2).forceRelativeY()).alignRowHeights().extendWidthToScreenEnd(0)).build(this.overlay::addWidget);
        this.helpGrid = ((GridBuilder)((GridBuilder)((GridBuilder)Grid.create((WidgetHolder)this.overlay, () -> this.overlay.getWidth() > 400 ? 3 : 2).below(this.header, this.padding)).spacing(this.padding).forceRelativeY()).alignRowHeights().extendWidthToScreenEnd(0)).build(this.overlay::addWidget);
        this.clientGroup = Group.create(this.overlay).icon(Icons.CLIENT).title(Lang.Tag.CLIENT).border(Color.MANTIS_GREEN).build(this.statusGrid::addCell);
        this.serverGroup = Group.create(this.overlay).icon(Icons.SERVER).title(Lang.Tag.SERVER).border(Color.SHADOW_BLUE).build(this.statusGrid::addCell);
        this.init();
    }

    public void open() {
        this.setStatusView();
        this.overlay.addProjectedWidgets(this.statusButton, this.helpButton);
        this.overlay.setCustomScissor(this.getCustomScissor());
        this.overlay.open();
    }

    private void init() {
        this.createStatus(TweakContext.from(this.tweak, CacheMode.LOCAL), this.clientGroup);
        this.createStatus(TweakContext.from(this.tweak, CacheMode.NETWORK), this.serverGroup);
        for (TweakStatus tweakStatus : TweakStatus.values()) {
            this.createContext(tweakStatus);
        }
        for (Enum enum_ : TweakContext.values()) {
            this.createContext((StatusContext)((Object)enum_));
        }
    }

    private DynamicRectangle<Overlay> getCustomScissor() {
        ToIntFunction<Overlay> startY = overlay -> this.header.getEndY() + overlay.getPadding();
        return new DynamicRectangle<Overlay>(this.overlay::getScissorX, startY, this.overlay::getScissorEndX, this.overlay::getScissorEndY);
    }

    private void createStatus(StatusContext tweakStatus, Group group) {
        boolean isOff;
        boolean isClientOnly = this.tweak.isClient() && group.equals(this.serverGroup);
        boolean isDisconnected = this.tweak.isMultiplayerLike() && group.equals(this.serverGroup) && !NetUtil.isConnected();
        boolean bl = isOff = isClientOnly || isDisconnected;
        IconWidget statusSignal = ((IconFactory)IconWidget.create(isOff ? Icons.TRAFFIC_LIGHT_OFF : tweakStatus.getIcon()).posX(this.padding * -1)).build(group::addWidget);
        MutableComponent statusTitle = tweakStatus.getTitle().withStyle(tweakStatus.getColor(), ChatFormatting.UNDERLINE);
        if (isClientOnly) {
            statusTitle = Lang.Status.CLIENT_ONLY.withStyle(ChatFormatting.GRAY, ChatFormatting.ITALIC);
        } else if (isDisconnected) {
            statusTitle = Lang.Status.NO_CONNECTION.withStyle(ChatFormatting.GRAY, ChatFormatting.ITALIC);
        }
        TextWidget statusText = ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create((Component)statusTitle).rightOf(statusSignal, this.padding + 1)).centerInWidgetY(statusSignal)).extendWidthToEnd(group, group.getInsidePaddingX())).build(group::addWidget);
        ((TextBuilder)((TextBuilder)TextWidget.create(isOff ? Lang.EMPTY : tweakStatus.getInfo()).belowAll(this.padding * 3, statusSignal, statusText)).width(group::getInsideWidth)).build(group::addWidget);
    }

    private void createContext(StatusContext context) {
        Group group = Group.create(this.overlay).icon(context.getIcon()).border(Color.fromFormatting(context.getColor())).title(TextUtil.toTitleCase(context.toString())).build(this.helpGrid::addCell);
        ((TextBuilder)TextWidget.create(context.getInfo()).width(group::getInsideWidth)).build(group::addWidget);
    }

    private void setStatusView() {
        this.viewing = Viewing.STATUS;
        this.helpGrid.setInvisible();
        this.statusGrid.setVisible();
    }

    private void setHelpView() {
        this.viewing = Viewing.HELP;
        this.statusGrid.setInvisible();
        this.helpGrid.setVisible();
    }

    private boolean isViewingStatus() {
        return this.viewing == Viewing.STATUS;
    }

    private boolean isViewingHelp() {
        return this.viewing == Viewing.HELP;
    }

    private void renderHeader(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean isActive = false;
        if (this.statusButton == button) {
            isActive = this.isViewingStatus();
        } else if (this.helpButton == button) {
            isActive = this.isViewingHelp();
        }
        Color bar = isActive ? Color.fromFormatting(ChatFormatting.GOLD) : Color.AZURE_WHITE;
        Color fill = bar.fromAlpha(0.2f);
        if (button.isHoveredOrFocused() && isActive) {
            bar = Color.RIPE_MANGO;
            fill = bar.fromAlpha(0.2f);
        }
        float startX = button.getX();
        float endX = button.getEndX();
        float barStartY = button.getEndY() - 1;
        float barEndY = button.getEndY();
        float fillStartY = button.getY();
        if (isActive || button.isHoveredOrFocused()) {
            RenderUtil.fill(graphics, startX, fillStartY, endX, barStartY, fill);
        }
        RenderUtil.fill(graphics, startX, barStartY, endX, barEndY, bar);
    }

    private static enum Viewing {
        STATUS,
        HELP;

    }
}

