/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen;

import java.util.function.Consumer;
import java.util.function.Function;
import mod.adrenix.nostalgic.client.gui.screen.DynamicScreen;
import mod.adrenix.nostalgic.client.gui.screen.WidgetManager;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedScreen<T extends EnhancedScreen<T, W>, W extends WidgetManager>
extends Screen
implements DynamicScreen<T> {
    @Nullable
    protected final Screen parentScreen;
    protected final Minecraft minecraft = Minecraft.getInstance();
    private final Function<T, W> widgetManager;
    private final UniqueArrayList<DynamicWidget<?, ?>> widgets = new UniqueArrayList();

    public EnhancedScreen(Function<T, W> widgetManager, @Nullable Screen parentScreen, Component title) {
        super(title);
        this.widgetManager = widgetManager;
        this.parentScreen = parentScreen;
    }

    public abstract W getWidgetManager();

    public abstract void setWidgetManager(W var1);

    @Override
    @Nullable
    public Screen getParentScreen() {
        return this.parentScreen;
    }

    protected void init() {
        this.clearWidgets();
        this.setWidgetManager((WidgetManager)this.widgetManager.apply((EnhancedScreen)this.self()));
        this.getWidgetManager().init();
    }

    public void tick() {
        this.getWidgetManager().tick();
        this.widgets.forEach((Consumer<DynamicWidget<?, ?>>)((Consumer<DynamicWidget>)DynamicWidget::tick));
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (KeyboardUtil.isEsc(keyCode) && this.getWidgets().stream().anyMatch(widget -> widget.keyPressed(keyCode, scanCode, modifiers))) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return super.charTyped(codePoint, modifiers);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        DynamicWidget dynamic;
        boolean isMouseClicked = super.mouseClicked(mouseX, mouseY, button);
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof DynamicWidget && !(dynamic = (DynamicWidget)guiEventListener).canFocusOnClick()) {
            dynamic.setFocused(false);
        }
        return isMouseClicked;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets() {
        return this.widgets;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        DynamicWidget.render(this.widgets, graphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }
}

