/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.screen;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.screen.ParentHolder;
import mod.adrenix.nostalgic.client.gui.tooltip.TooltipManager;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public interface DynamicScreen<T extends Screen>
extends WidgetHolder,
ParentHolder,
TooltipManager {
    public T self();

    public UniqueArrayList<DynamicWidget<?, ?>> getWidgets();

    default public UniqueArrayList<DynamicWidget<?, ?>> getTooltipWidgets() {
        return this.getWidgets();
    }

    @Override
    default public void addWidget(DynamicWidget<?, ?> widget) {
        ((UniqueArrayList)this.getWidgets()).add(widget);
        widget.setScreen((Screen)this.self());
    }

    default public boolean isKeyPressed(int keyCode, int scanCode, int modifiers) {
        GuiEventListener focused = this.self().getFocused();
        if (focused != null && focused.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (DynamicWidget widget : this.getWidgets()) {
            if (!widget.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (KeyboardUtil.isEsc(keyCode) && this.self().shouldCloseOnEsc()) {
            this.self().onClose();
            return true;
        }
        if (Screen.hasShiftDown() && Screen.hasControlDown() && keyCode == 68) {
            NostalgicTweaks.LOGGER.setDebug();
            return true;
        }
        if (Screen.hasShiftDown() && Screen.hasControlDown() && keyCode == 84) {
            Minecraft.getInstance().reloadResourcePacks();
            return true;
        }
        if (Screen.hasShiftDown() && Screen.hasControlDown() && keyCode == 70) {
            GuiUtil.toggleShowFps();
            return true;
        }
        return false;
    }

    default public boolean isKeyReleased(int keyCode, int scanCode, int modifiers) {
        return this.getWidgets().stream().anyMatch(widget -> widget.keyReleased(keyCode, scanCode, modifiers));
    }

    default public boolean isMouseClicked(double mouseX, double mouseY, int button) {
        NostalgicTweaks.LOGGER.debug(String.format("mouseX: %s | mouseY: %s", mouseX, mouseY));
        boolean isWidgetClicked = false;
        for (DynamicWidget widget : this.getWidgets()) {
            if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
            this.getWidgets().stream().filter(DynamicWidget::isFocused).forEach(DynamicWidget::setUnfocused);
            widget.setClickFocus();
            this.self().setFocused((GuiEventListener)widget);
            if (button == 0) {
                this.self().setDragging(true);
            }
            isWidgetClicked = true;
            break;
        }
        if (isWidgetClicked) {
            return true;
        }
        this.getWidgets().stream().filter(DynamicWidget::isFocused).forEach(DynamicWidget::setUnfocused);
        return false;
    }

    default public boolean isMouseReleased(double mouseX, double mouseY, int button) {
        return this.getWidgets().stream().anyMatch(widget -> widget.mouseReleased(mouseX, mouseY, button));
    }

    default public boolean isMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getWidgets().stream().anyMatch(widget -> widget.mouseDragged(mouseX, mouseY, button, dragX, dragY));
    }

    default public boolean isMouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.getWidgets().stream().anyMatch(widget -> widget.mouseScrolled(mouseX, mouseY, deltaX, deltaY));
    }

    default public void focusFirst() {
        this.getWidgets().stream().filter(DynamicWidget::canFocus).findFirst().ifPresent(arg_0 -> this.self().setFocused(arg_0));
    }

    default public void setDynamicFocus(@Nullable GuiEventListener focused) {
        DynamicWidget dynamic;
        if (focused instanceof DynamicWidget && !(dynamic = (DynamicWidget)focused).canFocus()) {
            return;
        }
        this.getWidgets().stream().filter(DynamicWidget::isFocused).forEach(DynamicWidget::setUnfocused);
    }
}

