/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.item;

import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.overlay.types.item.ItemPicker;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.Gradient;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemizeMaker {
    @Nullable
    Supplier<Component> title;
    @Nullable
    Gradient backgroundGradient;
    @Nullable
    Color backgroundColor;
    @Nullable
    Color separatorColor;
    @Nullable
    Color borderColor;
    final Consumer<ItemStack> onItemAdd;
    final Runnable onEmptyAdd;
    final HashSet<ItemRule> rules;

    protected ItemizeMaker(Consumer<ItemStack> onItemAdd, Runnable onEmptyAdd, HashSet<ItemRule> rules) {
        this.onItemAdd = onItemAdd;
        this.onEmptyAdd = onEmptyAdd;
        this.rules = rules;
    }

    public ItemizeMaker title(Supplier<Component> title) {
        this.title = title;
        return this;
    }

    public ItemizeMaker title(Translation title) {
        this.title = () -> title.get(new Object[0]);
        return this;
    }

    public ItemizeMaker title(Component title) {
        this.title = () -> title;
        return this;
    }

    public ItemizeMaker gradientBackground(Gradient gradient) {
        this.backgroundGradient = gradient;
        return this;
    }

    public ItemizeMaker backgroundColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public ItemizeMaker borderColor(Color color) {
        this.borderColor = color;
        return this;
    }

    public ItemizeMaker separatorColor(Color color) {
        this.separatorColor = color;
        return this;
    }

    public ItemPicker build() {
        return new ItemPicker(this);
    }

    public void open() {
        new ItemPicker(this).open();
    }
}

