/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.item;

import java.util.List;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.overlay.types.item.ItemPicker;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

class ItemSquare {
    private final ItemPicker itemPicker;
    private final Consumer<ButtonBuilder> extraSteps;
    private final int index;

    public ItemSquare(ItemPicker itemPicker, int index, Consumer<ButtonBuilder> extraSteps) {
        this.itemPicker = itemPicker;
        this.extraSteps = extraSteps;
        this.index = index;
    }

    private ItemPicker parent() {
        return this.itemPicker;
    }

    private ItemStack getItemStack() {
        if (this.parent().found.size() > this.index) {
            return this.parent().found.get(this.index);
        }
        return (ItemStack)this.parent().items.get(this.index);
    }

    private void onPress() {
        this.parent().selected = this.getItemStack();
        this.parent().overlay.close();
    }

    private TextureIcon getIcon() {
        return this.parent().icons.get(this.getItemStack().getItem());
    }

    private List<Component> getListTooltip() {
        try {
            return Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)this.getItemStack());
        }
        catch (Throwable throwable) {
            return List.of(Component.literal((String)ItemUtil.getResourceKey(this.getItemStack())));
        }
    }

    private boolean isInvisible() {
        return !this.parent().found.isEmpty() && this.parent().found.size() <= this.index;
    }

    private void render(ButtonWidget button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean isHoveredOrFocused;
        Color color = Color.WHITE.fromAlpha(85);
        boolean isMouseOver = this.parent().rowList.isMouseOver(mouseX, mouseY) && button.isMouseOver(mouseX, mouseY);
        boolean isFocused = button.isFocused();
        boolean bl = isHoveredOrFocused = isMouseOver || isFocused;
        if (isHoveredOrFocused) {
            RenderUtil.fill(graphics, (float)button.getX(), (float)button.getY(), (float)button.getEndX(), (float)button.getEndY(), color);
        }
        int startY = button.getIconY() - (isHoveredOrFocused ? 1 : 0);
        button.getIconManager().pos(button.getIconX(), startY);
        button.getIconManager().render(graphics, mouseX, mouseY, partialTick);
        if (isHoveredOrFocused) {
            button.getIconManager().get().setY(startY + 1);
        }
    }

    public ButtonWidget getButton() {
        ButtonBuilder builder = (ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create().darkenOnDisable(0.5f)).onPress(this::onPress)).icon(this::getIcon)).listTooltip(this::getListTooltip)).invisibleIf(this::isInvisible)).renderer(this::render);
        this.extraSteps.accept(builder);
        return (ButtonWidget)builder.build();
    }
}

