/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.item.ItemSquare;
import mod.adrenix.nostalgic.client.gui.overlay.types.item.ItemizeMaker;
import mod.adrenix.nostalgic.client.gui.screen.config.overlay.listing.FilterOverlay;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconFactory;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconTemplate;
import mod.adrenix.nostalgic.client.gui.widget.icon.IconWidget;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInput;
import mod.adrenix.nostalgic.client.gui.widget.input.GenericInputBuilder;
import mod.adrenix.nostalgic.client.gui.widget.list.Row;
import mod.adrenix.nostalgic.client.gui.widget.list.RowList;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorBuilder;
import mod.adrenix.nostalgic.client.gui.widget.separator.SeparatorWidget;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.util.client.search.GenericDatabase;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.Gradient;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.math.Rectangle;
import mod.adrenix.nostalgic.util.common.world.ItemFilter;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemPicker {
    final RowList rowList;
    final IconWidget close;
    final TextWidget title;
    final GenericInput search;
    final ButtonWidget abacus;
    final SeparatorWidget top;
    final SeparatorWidget bottom;
    final IntegerHolder tabOrder;
    final ItemizeMaker builder;
    final HashSet<ItemRule> rules;
    final Overlay overlay;
    final FilterOverlay filter;
    final GenericDatabase<ItemStack> database;
    final UniqueArrayList<ItemStack> items;
    final HashMap<Item, TextureIcon> icons;
    final Consumer<ItemStack> onItemAdd;
    final Runnable onEmptyAdd;
    double lastScrollAmount = -1.0;
    String lastQuery = "";
    ItemStack selected = null;
    List<ItemStack> found = new ArrayList<ItemStack>();

    public static ItemizeMaker create(Consumer<ItemStack> onItemAdd, ItemRule ... rules) {
        return new ItemizeMaker(onItemAdd, () -> {}, new HashSet<ItemRule>(List.of(rules)));
    }

    public static ItemizeMaker create(Consumer<ItemStack> onItemAdd, Runnable onEmptyAdd, ItemRule ... rules) {
        return new ItemizeMaker(onItemAdd, onEmptyAdd, new HashSet<ItemRule>(List.of(rules)));
    }

    protected ItemPicker(ItemizeMaker builder) {
        this.builder = builder;
        this.rules = builder.rules;
        this.onEmptyAdd = builder.onEmptyAdd;
        this.onItemAdd = builder.onItemAdd;
        this.database = new GenericDatabase();
        this.items = new UniqueArrayList();
        this.icons = new HashMap();
        this.tabOrder = IntegerHolder.create(0);
        this.overlay = Overlay.create().outlineColor(builder.borderColor != null ? builder.borderColor : Color.WHITE).onResize(this::onResize).onClose(this::close).resizeUsingPercentage(0.7).padding(2).borderless().build();
        if (builder.backgroundGradient == null && builder.backgroundColor == null) {
            this.overlay.getBuilder().gradientBackground(Gradient.vertical(Color.RICH_BLACK.fromAlpha(96), Color.DARK_BLUE.fromAlpha(160)));
        } else if (builder.backgroundGradient != null) {
            this.overlay.getBuilder().gradientBackground(builder.backgroundGradient);
        } else {
            this.overlay.getBuilder().backgroundColor(builder.backgroundColor);
        }
        this.close = ((IconFactory)((IconFactory)IconTemplate.close().fromScreenEndX(0)).tabOrderGroup(this.tabOrder.getAndIncrement())).onPress(this.overlay::close).build(this.overlay::addWidget);
        this.title = ((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(builder.title != null ? builder.title : () -> Lang.Itemize.TITLE.get(new Object[0])).tooltip(Lang.Overlay.DRAG_TIP, 36, 1L, TimeUnit.SECONDS)).onPress(this.overlay::move, Color.LEMON_YELLOW).intersection(this.close).extendWidthToScreenEnd(0)).disableUnderline().centerAligned().cannotFocus()).shorten().build(this.overlay::addWidget);
        this.abacus = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonWidget.create(Lang.Button.FILTER).onPress(() -> this.getFilter().ifPresent(FilterOverlay::open))).enableIf(this.rules::isEmpty)).skipFocusOnClick()).fromScreenEndY(0)).useTextWidth()).padding(5)).icon(Icons.FILTER)).tooltip(Lang.Button.FILTER, 500L, TimeUnit.MILLISECONDS)).disabledTooltip(Lang.Tooltip.FILTER_DISABLED, 45, 500L, TimeUnit.MILLISECONDS)).infoTooltip(Lang.Tooltip.FILTER, 45)).tabOrderGroup(this.tabOrder.getAndIncrement())).build(this.overlay::addWidget);
        this.filter = new FilterOverlay(this.abacus, this::filter);
        this.top = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(builder.separatorColor != null ? builder.separatorColor : Color.SILVER_CHALICE).below(this.title, 1)).height(1)).extendWidthToScreenEnd(0)).build(this.overlay::addWidget);
        this.bottom = ((SeparatorBuilder)((SeparatorBuilder)((SeparatorBuilder)SeparatorWidget.create(builder.separatorColor != null ? builder.separatorColor : Color.SILVER_CHALICE).above(this.abacus, 1)).height(1)).extendWidthToScreenEnd(0)).build(this.overlay::addWidget);
        this.search = ((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)((GenericInputBuilder)GenericInput.create().onInput(this::find)).icon(Icons.SEARCH)).whenEmpty(Lang.Input.SEARCH)).background(Color.OLIVE_BLACK, Color.OLIVE_BLACK)).border(Color.BLACK, Color.WHITE)).maxLength(100)).searchShortcut()).rightOf(this.abacus, 1)).extendWidthToScreenEnd(0)).tabOrderGroup(this.tabOrder.getAndIncrement())).build(this.overlay::addWidget);
        this.rowList = ((RowListBuilder)((RowListBuilder)((RowListBuilder)((RowListBuilder)RowList.create().below(this.top, 0)).extendWidthToScreenEnd(0)).extendHeightTo(this.bottom, 0)).horizontalMargin(0).verticalMargin(2).emptyMessage(Lang.Listing.NOTHING_FOUND).tabOrderGroup(this.tabOrder.getAndIncrement())).useScissorRectangle(this::getListScissoringBounds).build(this.overlay::addWidget);
        this.populateItemList();
    }

    public void open() {
        this.overlay.open();
        if (this.lastScrollAmount > 0.0) {
            this.rowList.setScrollAmount(this.lastScrollAmount);
        }
    }

    private void close() {
        this.lastScrollAmount = this.rowList.getScrollAmount();
        this.close.setUnfocused();
        if (this.selected != null) {
            this.onItemAdd.accept(this.selected);
        } else {
            this.onEmptyAdd.run();
        }
    }

    private void onResize() {
        this.populateSquaresForList();
        this.find(this.search.getInput());
    }

    private void find(String query) {
        if (query.equals(this.lastQuery)) {
            return;
        }
        this.lastQuery = query;
        this.found.clear();
        if (!query.isEmpty()) {
            this.found = this.database.findValues(query);
        }
    }

    private void filter() {
        this.found.clear();
        if (!this.lastQuery.isEmpty()) {
            this.found = this.database.findValues(this.lastQuery);
        }
        if (this.found.isEmpty()) {
            Predicate[] predicateArray = new Predicate[1];
            predicateArray[0] = this.filter::isFiltered;
            this.found = CollectionUtil.filterOut(this.items, predicateArray).collect(Collectors.toList());
        } else {
            Predicate[] predicateArray = new Predicate[1];
            predicateArray[0] = this.filter::isFiltered;
            this.found = CollectionUtil.filterOut(this.found, predicateArray).collect(Collectors.toList());
        }
    }

    private Optional<FilterOverlay> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    private Rectangle getListScissoringBounds() {
        int startX = this.overlay.getInsideX();
        int startY = this.top.getY() + 2;
        int endX = this.overlay.getInsideEndX();
        int endY = this.bottom.getY() - 2;
        return new Rectangle(startX, startY, endX, endY);
    }

    private void populateItemList() {
        Stream<Item> items = CollectionUtil.filterOut(BuiltInRegistries.ITEM.stream(), ItemFilter::isUnique);
        if (this.rules.contains((Object)ItemRule.NONE)) {
            this.items.addAll(items.map(Item::getDefaultInstance).toList());
        } else if (this.rules.contains((Object)ItemRule.ONLY_TOOLS)) {
            this.items.addAll(items.filter(ItemFilter::isToolLike).map(Item::getDefaultInstance).toList());
        } else if (this.rules.contains((Object)ItemRule.ONLY_ITEMS)) {
            this.items.addAll(items.filter(ItemFilter::isItemLike).map(Item::getDefaultInstance).toList());
        } else if (this.rules.contains((Object)ItemRule.ONLY_BLOCKS)) {
            this.items.addAll(items.filter(ItemFilter::isBlockLike).map(Item::getDefaultInstance).toList());
        } else if (this.rules.contains((Object)ItemRule.ONLY_CHESTS)) {
            this.items.addAll(items.filter(ItemFilter::isChestLike).map(Item::getDefaultInstance).toList());
        } else if (this.rules.contains((Object)ItemRule.ONLY_EDIBLES)) {
            this.items.addAll(items.filter(ItemUtil::isEdible).map(Item::getDefaultInstance).toList());
        } else if (this.rules.contains((Object)ItemRule.ONLY_DAMAGEABLE)) {
            this.items.addAll(items.filter(ItemUtil::isDamageable).map(Item::getDefaultInstance).toList());
        } else {
            items.forEach(item -> {
                boolean isFiltered;
                ItemStack itemStack = item.getDefaultInstance();
                boolean areToolsFiltered = ItemFilter.isToolLike(item) && this.rules.contains((Object)ItemRule.NO_TOOLS);
                boolean areItemsFiltered = ItemFilter.isItemLike(item) && this.rules.contains((Object)ItemRule.NO_ITEMS);
                boolean areBlocksFiltered = ItemFilter.isBlockLike(item) && this.rules.contains((Object)ItemRule.NO_BLOCKS);
                boolean areEdiblesFiltered = ItemUtil.isEdible(item) && this.rules.contains((Object)ItemRule.NO_EDIBLES);
                boolean areDamageableFiltered = ItemUtil.isDamageable(item) && this.rules.contains((Object)ItemRule.INVINCIBLE);
                boolean bl = isFiltered = areToolsFiltered || areItemsFiltered || areBlocksFiltered || areEdiblesFiltered || areDamageableFiltered;
                if (!isFiltered) {
                    this.items.add(itemStack);
                }
            });
        }
        this.items.forEach(itemStack -> {
            this.database.put(ItemUtil.getLocalizedItem(itemStack), (ItemStack)itemStack);
            this.icons.put(itemStack.getItem(), TextureIcon.fromItem(itemStack.getItem()));
        });
    }

    private void populateSquaresForList() {
        int squaresPerRow = Math.round((float)this.rowList.getRowWidth() / 22.0f);
        int scrollbarSize = this.rowList.getScrollbar().getWidth();
        int rowListWidth = 22 * squaresPerRow + scrollbarSize + 2;
        this.rowList.clear();
        this.rowList.setWidth(rowListWidth);
        this.overlay.resizeForOverflow();
        AtomicReference<Row> row = new AtomicReference<Row>((Row)Row.create(this.rowList).build());
        for (int i = 0; i < this.items.size(); ++i) {
            boolean isLastSquare = i == this.items.size() - 1;
            ItemSquare square = new ItemSquare(this, i, builder -> builder.rightOf((DynamicWidget)((UniqueArrayList)((Row)row.get()).getWidgets()).getLast(), 2));
            row.get().addWidget(square.getButton());
            if (!isLastSquare && squaresPerRow != ((ArrayList)row.get().getWidgets()).size()) continue;
            this.rowList.addBottomRow(row.get());
            if (isLastSquare) continue;
            row.set((Row)Row.create(this.rowList).build());
        }
    }
}

