/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.color;

import mod.adrenix.nostalgic.client.gui.overlay.types.color.ColorPicker;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.group.Group;
import mod.adrenix.nostalgic.client.gui.widget.group.GroupBuilder;
import mod.adrenix.nostalgic.util.common.lang.Lang;

class PickerGroup {
    final Group hsb;
    final Group rgb;
    final Group alpha;
    final Group sample;
    final Group hex;
    final Group palette;
    final Group recent;
    final Group random;
    final ColorPicker picker;

    PickerGroup(ColorPicker picker) {
        this.picker = picker;
        this.hsb = (Group)((GroupBuilder)Group.create(picker.overlay).size(120)).title(Lang.literal("HSB")).border(picker.color).build();
        this.rgb = (Group)((GroupBuilder)((GroupBuilder)Group.create(picker.overlay).rightOf(this.hsb, 3)).size(120)).title(Lang.literal("RGB")).border(picker.color).build();
        this.alpha = (Group)((GroupBuilder)((GroupBuilder)Group.create(picker.overlay).below(this.hsb, 3)).size(120)).title(Lang.Colorize.OPACITY).border(picker.color).build();
        this.sample = (Group)((GroupBuilder)((GroupBuilder)Group.create(picker.overlay).rightOf(this.alpha, 3)).size(120)).title(Lang.Colorize.SAMPLE).border(picker.color).build();
        this.hex = (Group)((GroupBuilder)((GroupBuilder)Group.create(picker.overlay).rightOf(this.rgb, 3)).size(120, 24)).title(Lang.literal("Hex")).border(picker.color).build();
        this.palette = (Group)((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(picker.overlay).posX(this.hex::getX)).below(this.hex, 3)).size(120, 24)).title(Lang.Colorize.PALETTE).border(picker.color).bottomOffset(-1).build();
        this.recent = (Group)((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(picker.overlay).extendHeightTo(picker.done, 3)).rightOf(this.sample, 3)).size(120, 12)).title(Lang.Colorize.RECENT).border(picker.color).bottomOffset(-2).build();
        this.random = (Group)((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)Group.create(picker.overlay).extendHeightTo(this.recent, 3)).rightOf(this.sample, 3)).below(this.palette, 3)).size(120)).title(Lang.Colorize.RANDOM).border(picker.color).build();
        ((GroupBuilder)this.recent.getBuilder()).below(this.random, 3);
    }

    void build() {
        this.picker.overlay.addWidgets(new DynamicWidget[]{this.hsb, this.alpha});
        this.picker.overlay.addWidgets(new DynamicWidget[]{this.rgb, this.sample});
        this.picker.overlay.addWidgets(new DynamicWidget[]{this.hex, this.palette, this.random, this.recent});
        this.hsb.addWidgets(new DynamicWidget[]{this.picker.text.hue, this.picker.slider.hue});
        this.hsb.addWidgets(new DynamicWidget[]{this.picker.text.saturation, this.picker.slider.saturation});
        this.hsb.addWidgets(new DynamicWidget[]{this.picker.text.brightness, this.picker.slider.brightness});
        this.rgb.addWidgets(new DynamicWidget[]{this.picker.text.red, this.picker.slider.red});
        this.rgb.addWidgets(new DynamicWidget[]{this.picker.text.green, this.picker.slider.green});
        this.rgb.addWidgets(new DynamicWidget[]{this.picker.text.blue, this.picker.slider.blue});
        this.alpha.addWidgets(new DynamicWidget[]{this.picker.text.opacity, this.picker.slider.opacity});
        this.sample.addWidgets(new DynamicWidget[]{this.picker.text.sample});
    }
}

