/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.overlay.types.color;

import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.PickerGroup;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.PickerHex;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.PickerPalette;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.PickerSlider;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.PickerText;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonBuilder;
import mod.adrenix.nostalgic.client.gui.widget.button.ButtonWidget;
import mod.adrenix.nostalgic.util.common.array.ArrayUtil;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.lang.Lang;

public class ColorPicker {
    public static final int GROUP_WIDTH = 120;
    public static final int GROUP_HEIGHT = 24;
    public static final int PADDING = 3;
    private final Consumer<ColorPicker> onClose = picker -> {
        PickerPalette.RECENT.removeIf(Color::isEmpty);
        Color copy = new Color(this.getColor());
        if (PickerPalette.RECENT.stream().noneMatch(recent -> recent.equals(copy))) {
            ArrayUtil.popPush(PickerPalette.RECENT, copy, 7);
        }
        onClose.accept((ColorPicker)picker);
    };
    final Overlay overlay;
    final Color color;
    final Color resetColor;
    final ButtonWidget done;
    final PickerGroup group;
    final PickerText text;
    final PickerSlider slider;
    final PickerHex hex;
    final PickerPalette palette;
    final boolean transparent;

    private ColorPicker(Color color, Consumer<ColorPicker> onClose, boolean transparent) {
        this.color = color;
        this.transparent = transparent;
        this.resetColor = new Color(color.get(), (double)color.getFloatAlpha());
        this.overlay = Overlay.create(Lang.Colorize.TITLE).resizeForWidgets().infoMessage(Lang.Colorize.HINT).icon(Icons.SMALL_COLOR_WHEEL).padding(3).onClose(() -> this.onClose.accept(this)).build();
        this.done = (ButtonWidget)ButtonWidget.create(Lang.Vanilla.GUI_DONE).build();
        this.group = new PickerGroup(this);
        this.text = new PickerText(this);
        this.slider = new PickerSlider(this);
        this.hex = new PickerHex(this);
        this.palette = new PickerPalette(this);
        ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)this.done.getBuilder()).icon(Icons.GREEN_CHECK)).extendWidthToEnd(this.group.recent, 0)).below(this.group.recent, 3)).rightOf(this.group.sample, 3)).onPress(this.overlay::close);
        this.text.build();
        this.slider.build();
        this.group.build();
        this.palette.build();
        this.overlay.addWidget(this.done);
        this.setTabOrder();
    }

    private void setTabOrder() {
        IntegerHolder order = IntegerHolder.create(0);
        this.slider.hue.setTabOrderGroup(order.getAndIncrement());
        this.slider.saturation.setTabOrderGroup(order.getAndIncrement());
        this.slider.brightness.setTabOrderGroup(order.getAndIncrement());
        this.slider.opacity.setTabOrderGroup(order.getAndIncrement());
        this.slider.red.setTabOrderGroup(order.getAndIncrement());
        this.slider.green.setTabOrderGroup(order.getAndIncrement());
        this.slider.blue.setTabOrderGroup(order.getAndIncrement());
        this.hex.input.setTabOrderGroup(order.getAndIncrement());
        this.hex.reset.setTabOrderGroup(order.getAndIncrement());
        this.group.palette.getWidgetStream().forEach(widget -> widget.setTabOrderGroup(order.getAndIncrement()));
        this.group.random.getWidgetStream().forEach(widget -> widget.setTabOrderGroup(order.getAndIncrement()));
        this.group.recent.getWidgetStream().forEach(widget -> widget.setTabOrderGroup(order.getAndIncrement()));
        this.done.setTabOrderGroup(order.getAndIncrement());
    }

    public Color getColor() {
        return this.color;
    }

    private Overlay open() {
        return this.overlay.open();
    }

    public static Builder create(Color color, Consumer<ColorPicker> onClose) {
        return new Builder(color, onClose);
    }

    public static Builder create(Color color) {
        return new Builder(color, picker -> {});
    }

    public static class Builder {
        private final Color color;
        private final Consumer<ColorPicker> onClose;
        private boolean transparent = true;

        private Builder(Color color, Consumer<ColorPicker> onClose) {
            this.color = color;
            this.onClose = onClose;
        }

        public Builder opaque() {
            this.transparent = false;
            return this;
        }

        public Builder transparent() {
            this.transparent = true;
            return this;
        }

        public Builder opaque(boolean state) {
            if (state) {
                return this.opaque();
            }
            return this.transparent();
        }

        public ColorPicker build() {
            return new ColorPicker(this.color, this.onClose, this.transparent);
        }

        public Overlay open() {
            return new ColorPicker(this.color, this.onClose, this.transparent).open();
        }
    }
}

