/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic;

import dev.architectury.platform.Platform;
import dev.architectury.utils.EnvExecutor;
import java.util.Locale;
import java.util.Optional;
import mod.adrenix.nostalgic.config.cache.ConfigCache;
import mod.adrenix.nostalgic.init.ModInitializer;
import mod.adrenix.nostalgic.network.ModConnection;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import mod.adrenix.nostalgic.util.common.log.ModLogger;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.server.MinecraftServer;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.Nullable;

public abstract class NostalgicTweaks {
    public static final String MOD_ID = "nostalgic_tweaks";
    public static final String MOD_NAME = "Nostalgic Tweaks";
    public static final ModLogger LOGGER = new ModLogger("Nostalgic Tweaks");
    private static final NullableHolder<String> FULL_VERSION = NullableHolder.empty();
    private static final NullableHolder<String> BETA_VERSION = NullableHolder.empty();
    private static final NullableHolder<String> TINY_VERSION = NullableHolder.empty();
    private static final NullableHolder<String> SHORT_VERSION = NullableHolder.empty();
    public static final String PROTOCOL = "3.1";
    private static boolean isNetworkSupported = false;
    private static ModConnection connection = null;
    private static MinecraftServer server;
    private static boolean modInitialized;
    private static final boolean isEventTesting = false;

    public static boolean isClient() {
        return Platform.getEnv() == Dist.CLIENT;
    }

    public static boolean isServer() {
        return Platform.getEnv() == Dist.DEDICATED_SERVER;
    }

    public static boolean isFabric() {
        return Platform.isFabric();
    }

    public static boolean isForge() {
        return Platform.isNeoForge();
    }

    public static String getLoader() {
        return NostalgicTweaks.isFabric() ? "Fabric" : "NeoForge";
    }

    public static String getMinecraftVersion() {
        return Platform.getMinecraftVersion();
    }

    public static String getRawVersion() {
        return Platform.getMod((String)MOD_ID).getVersion();
    }

    public static String getFullVersion() {
        return FULL_VERSION.computeIfAbsent(() -> String.format("%s-%s-%s", NostalgicTweaks.getLoader(), NostalgicTweaks.getMinecraftVersion(), NostalgicTweaks.getRawVersion()));
    }

    public static String getBetaVersion() {
        return BETA_VERSION.computeIfAbsent(() -> TextUtil.extract(NostalgicTweaks.getRawVersion(), "beta\\.\\d+"));
    }

    public static String getTinyVersion() {
        return TINY_VERSION.computeIfAbsent(() -> TextUtil.extract(NostalgicTweaks.getRawVersion(), "(\\d\\.\\d\\.\\d)"));
    }

    public static String getShortVersion() {
        return SHORT_VERSION.computeIfAbsent(() -> String.format("%s-%s", NostalgicTweaks.getMinecraftVersion(), NostalgicTweaks.getRawVersion()));
    }

    public static String getProtocol() {
        return PROTOCOL;
    }

    public static void setConnection(@Nullable ModConnection data) {
        connection = data;
    }

    public static Optional<ModConnection> getConnection() {
        return Optional.ofNullable(connection);
    }

    public static void setServer(MinecraftServer minecraftServer) {
        server = minecraftServer;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return server;
    }

    @Nullable
    public static MinecraftServer getIntegratedOrDedicatedServer() {
        return (MinecraftServer)EnvExecutor.getEnvSpecific(() -> GameUtil::getIntegratedServer, () -> NostalgicTweaks::getServer);
    }

    public static boolean isNetworkVerified() {
        return NostalgicTweaks.isServer() || isNetworkSupported;
    }

    public static void setNetworkVerification(boolean verified) {
        LOGGER.debug("Setting network verification to: %s", verified);
        isNetworkSupported = verified;
    }

    public static boolean isMixinEarly() {
        return !modInitialized;
    }

    public static void initialize() {
        ModInitializer.register();
        if (NostalgicTweaks.isServer()) {
            ConfigCache.initServer();
        } else {
            ConfigCache.initClient();
            if (ModTracker.OPTIFINE.isInstalled()) {
                LOGGER.warn("Optifine is installed - some tweaks may not work as intended");
            }
        }
        modInitialized = true;
        String loader = LogColor.apply(LogColor.LIGHT_PURPLE, NostalgicTweaks.getLoader());
        String environment = Platform.getEnv().toString().toLowerCase(Locale.ROOT);
        LOGGER.info("Loading mod in [%s] %s environment", loader, environment);
    }

    public static boolean isDebugging() {
        return LOGGER.isDebugMode();
    }

    public static boolean isDeveloping() {
        return Platform.isDevelopmentEnvironment();
    }

    public static boolean isEventTesting() {
        if (Platform.isDevelopmentEnvironment()) {
            // empty if block
        }
        return false;
    }

    static {
        modInitialized = false;
    }
}

